/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.net.MalformedURLException;
import org.openide.ErrorManager;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryFile {
    public static final String[] ROOT_FOLDER_PATH = new String[0];
    private final SVNUrl repositoryUrl;
    private final SVNRevision revision;
    private SVNUrl fileUrl;
    private String[] pathSegments;
    private String path;
    private String toString = null;
    private boolean repositoryRoot;
    private String name;

    public RepositoryFile(SVNUrl repositoryUrl, SVNRevision revision) {
        assert (repositoryUrl != null);
        assert (revision != null);
        this.repositoryUrl = repositoryUrl;
        this.revision = revision;
        this.repositoryRoot = true;
    }

    public RepositoryFile(SVNUrl repositoryUrl, SVNUrl fileUrl, SVNRevision revision) {
        this(repositoryUrl, revision);
        this.fileUrl = fileUrl;
        boolean bl = this.repositoryRoot = fileUrl == null;
        if (!this.repositoryRoot) {
            String[] fileUrlSegments = fileUrl.getPathSegments();
            int fileSegmentsLength = fileUrlSegments.length;
            int repositorySegmentsLength = repositoryUrl.getPathSegments().length;
            this.pathSegments = new String[fileSegmentsLength - repositorySegmentsLength];
            StringBuffer sb = new StringBuffer();
            for (int i = repositorySegmentsLength; i < fileSegmentsLength; ++i) {
                this.pathSegments[i - repositorySegmentsLength] = fileUrlSegments[i];
                sb.append(fileUrlSegments[i]);
                if (i - repositorySegmentsLength >= this.pathSegments.length - 1) continue;
                sb.append("/");
            }
            this.path = sb.toString();
        }
    }

    public RepositoryFile(SVNUrl repositoryUrl, String[] pathSegments, SVNRevision revision) throws MalformedURLException {
        this(repositoryUrl, revision);
        this.pathSegments = pathSegments;
        boolean bl = this.repositoryRoot = pathSegments == null;
        if (!this.repositoryRoot) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < pathSegments.length; ++i) {
                sb.append(pathSegments[i]);
                if (i >= pathSegments.length - 1) continue;
                sb.append("/");
            }
            this.path = sb.toString();
            this.fileUrl = repositoryUrl.appendPath(this.path);
        }
    }

    public RepositoryFile(SVNUrl repositoryUrl, String path, SVNRevision revision) throws MalformedURLException {
        this(repositoryUrl, revision);
        this.path = path;
        boolean bl = this.repositoryRoot = path == null;
        if (!this.repositoryRoot) {
            this.fileUrl = repositoryUrl.appendPath(path);
            this.pathSegments = path.split("/");
        }
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public SVNUrl getFileUrl() {
        if (this.isRepositoryRoot()) {
            return this.getRepositoryUrl();
        }
        return this.fileUrl;
    }

    public String[] getPathSegments() {
        if (this.isRepositoryRoot()) {
            return ROOT_FOLDER_PATH;
        }
        return this.pathSegments;
    }

    public String getPath() {
        if (this.isRepositoryRoot()) {
            return "";
        }
        return this.path;
    }

    public boolean isRepositoryRoot() {
        return this.repositoryRoot;
    }

    public String getName() {
        if (this.name == null) {
            if (this.isRepositoryRoot()) {
                String url = this.getRepositoryUrl().toString();
                int idx = url.indexOf("://");
                if (idx >= 0) {
                    url = url.substring(idx + 3);
                }
                return url;
            }
            return this.getFileUrl().getLastPathSegment();
        }
        return this.name;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.fileUrl);
            sb.append("@");
            sb.append(this.revision);
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public RepositoryFile appendPath(String path) {
        return new RepositoryFile(this.repositoryUrl, this.getFileUrl().appendPath(path), this.revision);
    }

    public RepositoryFile replaceLastSegment(String segment, int level) {
        assert (segment != null && !segment.equals(""));
        assert (level > -1 && level < this.fileUrl.getPathSegments().length);
        assert (!this.isRepositoryRoot());
        String fileUrlString = this.fileUrl.toString();
        int fromIdx = fileUrlString.lastIndexOf(47);
        int toIdx = fileUrlString.length() - 1;
        for (int i = 0; i < level; ++i) {
            toIdx = fromIdx - 1;
            fromIdx = fileUrlString.lastIndexOf(47, fromIdx - 1);
        }
        assert (fromIdx >= this.repositoryUrl.toString().length());
        assert (toIdx >= fromIdx && toIdx < fileUrlString.length());
        SVNUrl newUrl = null;
        try {
            newUrl = new SVNUrl(fileUrlString.substring(0, fromIdx + 1) + segment + fileUrlString.substring(toIdx + 1));
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return new RepositoryFile(this.repositoryUrl, newUrl, this.revision);
    }

    public RepositoryFile removeLastSegment() {
        assert (!this.isRepositoryRoot());
        String fileUrlStrint = this.fileUrl.toString();
        int idx = fileUrlStrint.lastIndexOf(47);
        assert (idx >= this.repositoryUrl.toString().length());
        SVNUrl newUrl = null;
        try {
            newUrl = new SVNUrl(fileUrlStrint.substring(0, idx));
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return new RepositoryFile(this.repositoryUrl, newUrl, this.revision);
    }
}

