/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Diagnostics;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.FileStatusProvider;
import org.netbeans.modules.subversion.FilesystemHandler;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Subversion {
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final int STATUS_DIFFABLE = 1272;
    private static Subversion instance;
    private FileStatusCache fileStatusCache;
    private FilesystemHandler filesystemHandler;
    private FileStatusProvider fileStatusProvider;
    private Annotator annotator;
    private HashMap<String, RequestProcessor> processorsToUrl;
    private SvnClient noUrlClientWithoutListeners;
    private SvnClient noUrlClientWithListeners;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public static synchronized Subversion getInstance() {
        if (instance == null) {
            instance = new Subversion();
            instance.init();
        }
        return instance;
    }

    private Subversion() {
    }

    private void init() {
        Diagnostics.init();
        this.loadIniParserClassesWorkaround();
        SvnClientFactory.init();
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator(this);
        this.fileStatusProvider = new FileStatusProvider();
        this.filesystemHandler = new FilesystemHandler(this);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIniParserClassesWorkaround() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SvnConfigFiles.getInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void cleanup() {
        this.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Diagnostics.println("Cleaning up");
                    Subversion.this.fileStatusCache.cleanUp();
                }
                finally {
                    Diagnostics.println("END Cleaning up");
                }
            }
        }, 3000);
    }

    public void shutdown() {
        this.fileStatusProvider.shutdown();
    }

    public SvnFileNode[] getNodes(Context context, int includeStatus) {
        File[] files = this.fileStatusCache.listFiles(context, includeStatus);
        SvnFileNode[] nodes = new SvnFileNode[files.length];
        for (int i = 0; i < files.length; ++i) {
            nodes[i] = new SvnFileNode(files[i]);
        }
        return nodes;
    }

    public String getMimeType(File file) {
        String foMime;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return SvnUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        PropertiesClient client = new PropertiesClient(file);
        try {
            byte[] mimeProperty = client.getProperties().get("svn:mime-type");
            if (mimeProperty == null) {
                return foMime;
            }
            return new String(mimeProperty);
        }
        catch (IOException e) {
            return foMime;
        }
    }

    public boolean isAdministrative(File file) {
        String name = file.getName();
        return this.isAdministrative(name) && file.isDirectory();
    }

    public boolean isAdministrative(String fileName) {
        return fileName.equals(".svn") || fileName.equals("_svn");
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public boolean checkClientAvailable() {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return false;
        }
        return true;
    }

    public SvnClient getClient(SVNUrl repositoryUrl, String username, String password) throws SVNClientException {
        return this.getClient(repositoryUrl, username, password, 44);
    }

    public SvnClient getClient(SVNUrl repositoryUrl, String username, String password, int handledExceptions) throws SVNClientException {
        SvnClient client = SvnClientFactory.getInstance().createSvnClient(repositoryUrl, null, username, password, handledExceptions);
        this.attachListeners(client);
        return client;
    }

    public SvnClient getClient(SVNUrl repositoryUrl, SvnProgressSupport support) throws SVNClientException {
        String username = "";
        String password = "";
        RepositoryConnection rc = SvnModuleConfig.getDefault().getRepositoryConnection(repositoryUrl.toString());
        if (rc != null) {
            username = rc.getUsername();
            password = rc.getPassword();
        }
        SvnClient client = SvnClientFactory.getInstance().createSvnClient(repositoryUrl, support, username, password, 44);
        this.attachListeners(client);
        return client;
    }

    public SvnClient getClient(File file) throws SVNClientException {
        return this.getClient(file, null);
    }

    public SvnClient getClient(File file, SvnProgressSupport support) throws SVNClientException {
        SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(file);
        assert (repositoryUrl != null) : "Unable to get repository: " + file.getAbsolutePath() + " is probably unmanaged.";
        return this.getClient(repositoryUrl, support);
    }

    public SvnClient getClient(Context ctx, SvnProgressSupport support) throws SVNClientException {
        File[] roots = ctx.getRootFiles();
        SVNUrl repositoryUrl = null;
        for (int i = 0; i < roots.length && (repositoryUrl = SvnUtils.getRepositoryRootUrl(roots[0])) == null; ++i) {
        }
        assert (repositoryUrl != null) : "Unable to get repository, context contains only unmanaged files!";
        return this.getClient(repositoryUrl, support);
    }

    public SvnClient getClient(SVNUrl repositoryUrl) throws SVNClientException {
        return this.getClient(repositoryUrl, null);
    }

    public SvnClient getClient(boolean attachListeners) throws SVNClientException {
        this.cleanupFilesystem();
        if (attachListeners) {
            if (this.noUrlClientWithListeners == null) {
                this.noUrlClientWithListeners = SvnClientFactory.getInstance().createSvnClient();
                this.attachListeners(this.noUrlClientWithListeners);
            }
            return this.noUrlClientWithListeners;
        }
        if (this.noUrlClientWithoutListeners == null) {
            this.noUrlClientWithoutListeners = SvnClientFactory.getInstance().createSvnClient();
        }
        return this.noUrlClientWithoutListeners;
    }

    public FilesystemHandler getFileSystemHandler() {
        return this.filesystemHandler;
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    File getTopmostManagedParent(File file) {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException ex) {
            return null;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            while (file != null) {
                if (this.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File topmost = null;
        while (file != null) {
            if (new File(file, ".svn/entries").canRead() || new File(file, "_svn/entries").canRead()) {
                topmost = file;
            }
            file = file.getParentFile();
        }
        return topmost;
    }

    public void cleanupFilesystem() {
        this.filesystemHandler.removeInvalidMetadata();
    }

    private void attachListeners(SvnClient client) {
        client.addNotifyListener(this.getLogger(client.getSvnUrl()));
        client.addNotifyListener(this.fileStatusCache);
    }

    public OutputLogger getLogger(SVNUrl repositoryRoot) {
        return OutputLogger.getLogger(repositoryRoot);
    }

    boolean isIgnored(File file) {
        int pstatus;
        String name = file.getName();
        File parent = file.getParentFile();
        if (parent != null && ((pstatus = this.fileStatusCache.getStatus(parent).getStatus()) & 0x1DF8) != 0) {
            try {
                SvnClient client = this.getClient(false);
                List patterns = client.getIgnoredPatterns(parent);
                List<String> gignores = SvnConfigFiles.getInstance().getGlobalIgnores();
                Iterator<String> it = gignores.iterator();
                while (it.hasNext()) {
                    patterns.add(it.next());
                }
                if (SvnUtils.getMatchinIgnoreParterns(patterns, name, true).size() > 0) {
                    return true;
                }
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
        if (SharabilityQuery.getSharability((File)file) == 2) {
            try {
                FileInformation info = this.fileStatusCache.getCachedStatus(file);
                if (SubversionVisibilityQuery.isHiddenFolder(info, file)) {
                    return false;
                }
                if (SharabilityQuery.getSharability((File)parent) != 2 && (this.fileStatusCache.getStatus(parent).getStatus() & 0x1DF8) != 0) {
                    IgnoreAction.ignore(file);
                }
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
            return true;
        }
        return ".nbintdb".equals(name);
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getRequestProcessor(SVNUrl url) {
        String key;
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(key = url != null ? url.toString() : "ANY_URL")) == null) {
            rp = new RequestProcessor("Subversion - " + key, 1, true);
            this.processorsToUrl.put(key, rp);
        }
        return rp;
    }

    FileStatusProvider getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    VCSInterceptor getVCSInterceptor() {
        return this.filesystemHandler;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        FileInformation info = this.fileStatusCache.getStatus(workingCopy);
        if ((info.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            File original = VersionsCache.getInstance().getFileRevision(workingCopy, "BASE");
            if (original == null) {
                throw new IOException("Unable to get BASE revision of " + workingCopy);
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(originalFile), (InputStream)new FileInputStream(original));
        }
        catch (IOException e) {
            Logger.getLogger(Subversion.class.getName()).log(Level.INFO, "Unable to get original file", e);
        }
    }
}

