/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SubversionVisibilityQuery
implements VisibilityQueryImplementation,
VersioningListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private FileStatusCache cache = Subversion.getInstance().getStatusCache();

    public SubversionVisibilityQuery() {
        this.cache.addVersioningListener(this);
    }

    public boolean isVisible(FileObject fileObject) {
        if (fileObject.isData()) {
            return true;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return true;
        }
        return this.cache.getStatus(file).getStatus() != 256;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.add(l);
        this.listeners = newList;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.remove(l);
        this.listeners = newList;
    }

    public void versioningEvent(VersioningEvent event) {
        File file;
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED && (file = (File)event.getParams()[0]) != null && file.isDirectory()) {
            FileInformation old = (FileInformation)event.getParams()[1];
            FileInformation cur = (FileInformation)event.getParams()[2];
            if (old != null && old.getStatus() == 256 || cur.getStatus() == 256) {
                this.fireVisibilityChanged();
            }
        }
    }

    static boolean isHiddenFolder(FileInformation info, File file) {
        return file.isDirectory() && info != null && info.getStatus() == 256;
    }

    private void fireVisibilityChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }
}

