/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_TEXT_ANNOTATIONS_FORMAT = "textAnnotations";
    public static final String KEY_EXECUTABLE_BINARY = "svnExecBinary";
    public static final String KEY_ANNOTATION_FORMAT = "annotationFormat";
    private static final String RECENT_URL = "repository.recentURL";
    private static final String SHOW_CHECKOUT_COMPLETED = "checkoutCompleted.showCheckoutCompleted";
    private static final String URL_EXP = "annotator.urlExp";
    private static final String ANNOTATION_EXP = "annotator.annotationExp";
    public static final String TEXT_ANNOTATIONS_FORMAT_DEFAULT = "{DEFAULT}";
    private static final SvnModuleConfig INSTANCE = new SvnModuleConfig();
    private Set<String> exclusions;
    private TableSorter importTableSorter;
    private TableSorter commitTableSorter;

    public static SvnModuleConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(SvnModuleConfig.class);
    }

    public boolean getShowCheckoutCompleted() {
        return this.getPreferences().getBoolean(SHOW_CHECKOUT_COMPLETED, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return SvnModuleConfig.getDefaultFilePatterns();
    }

    public boolean isExcludedFromCommit(String path) {
        return this.getCommitExclusions().contains(path);
    }

    public void addExclusionPaths(Collection<String> paths) {
        Set<String> exclusions = this.getCommitExclusions();
        if (exclusions.addAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(exclusions));
        }
    }

    public void removeExclusionPaths(Collection<String> paths) {
        Set<String> exclusions = this.getCommitExclusions();
        if (exclusions.removeAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(exclusions));
        }
    }

    public String getExecutableBinaryPath() {
        return this.getPreferences().get(KEY_EXECUTABLE_BINARY, "");
    }

    public void setExecutableBinaryPath(String path) {
        this.getPreferences().put(KEY_EXECUTABLE_BINARY, path);
    }

    public String getAnnotationFormat() {
        return this.getPreferences().get(KEY_ANNOTATION_FORMAT, this.getDefaultAnnotationFormat());
    }

    public String getDefaultAnnotationFormat() {
        return "[{" + Annotator.ANNOTATION_STATUS + "} {" + Annotator.ANNOTATION_FOLDER + "}]";
    }

    public void setAnnotationFormat(String annotationFormat) {
        this.getPreferences().put(KEY_ANNOTATION_FORMAT, annotationFormat);
    }

    public void setShowCheckoutCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CHECKOUT_COMPLETED, bl);
    }

    public RepositoryConnection getRepositoryConnection(String url) {
        List<RepositoryConnection> rcs = this.getRecentUrls();
        for (RepositoryConnection rc : rcs) {
            if (!url.equals(rc.getUrl())) continue;
            return rc;
        }
        return null;
    }

    public void insertRecentUrl(RepositoryConnection rc) {
        Preferences prefs = this.getPreferences();
        List urlValues = Utils.getStringList((Preferences)prefs, (String)RECENT_URL);
        for (String rcOldString : urlValues) {
            RepositoryConnection rcOld = RepositoryConnection.parse(rcOldString);
            if (!rcOld.equals(rc)) continue;
            Utils.removeFromArray((Preferences)prefs, (String)RECENT_URL, (String)rcOldString);
        }
        Utils.insert((Preferences)prefs, (String)RECENT_URL, (String)RepositoryConnection.getString(rc), (int)-1);
    }

    public void setRecentUrls(List<RepositoryConnection> recentUrls) {
        ArrayList<String> urls = new ArrayList<String>(recentUrls.size());
        int idx = 0;
        Iterator<RepositoryConnection> it = recentUrls.iterator();
        while (it.hasNext()) {
            ++idx;
            RepositoryConnection rc = it.next();
            urls.add(RepositoryConnection.getString(rc));
        }
        Preferences prefs = this.getPreferences();
        Utils.put((Preferences)prefs, (String)RECENT_URL, urls);
    }

    public List<RepositoryConnection> getRecentUrls() {
        Preferences prefs = this.getPreferences();
        List urls = Utils.getStringList((Preferences)prefs, (String)RECENT_URL);
        ArrayList<RepositoryConnection> ret = new ArrayList<RepositoryConnection>(urls.size());
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            RepositoryConnection rc = RepositoryConnection.parse((String)it.next());
            ret.add(rc);
        }
        return ret;
    }

    public void setAnnotationExpresions(List<AnnotationExpression> exps) {
        ArrayList<String> urlExp = new ArrayList<String>(exps.size());
        ArrayList<String> annotationExp = new ArrayList<String>(exps.size());
        int idx = 0;
        Iterator<AnnotationExpression> it = exps.iterator();
        while (it.hasNext()) {
            ++idx;
            AnnotationExpression exp = it.next();
            urlExp.add(exp.getUrlExp());
            annotationExp.add(exp.getAnnotationExp());
        }
        Preferences prefs = this.getPreferences();
        Utils.put((Preferences)prefs, (String)URL_EXP, urlExp);
        Utils.put((Preferences)prefs, (String)ANNOTATION_EXP, annotationExp);
    }

    public List<AnnotationExpression> getAnnotationExpresions() {
        Preferences prefs = this.getPreferences();
        List urlExp = Utils.getStringList((Preferences)prefs, (String)URL_EXP);
        List annotationExp = Utils.getStringList((Preferences)prefs, (String)ANNOTATION_EXP);
        List<AnnotationExpression> ret = new ArrayList<AnnotationExpression>(urlExp.size());
        for (int i = 0; i < urlExp.size(); ++i) {
            ret.add(new AnnotationExpression((String)urlExp.get(i), (String)annotationExp.get(i)));
        }
        if (ret.size() < 1) {
            ret = this.getDefaultAnnotationExpresions();
        }
        return ret;
    }

    public List<AnnotationExpression> getDefaultAnnotationExpresions() {
        ArrayList<AnnotationExpression> ret = new ArrayList<AnnotationExpression>(1);
        ret.add(new AnnotationExpression(".*/(branches|tags)/(.+?)/.*", "\\2"));
        return ret;
    }

    public TableSorter getImportTableSorter() {
        return this.importTableSorter;
    }

    public void setImportTableSorter(TableSorter sorter) {
        this.importTableSorter = sorter;
    }

    public TableSorter getCommitTableSorter() {
        return this.commitTableSorter;
    }

    public void setCommitTableSorter(TableSorter sorter) {
        this.commitTableSorter = sorter;
    }

    private synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }
}

