/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.MissingSvnClientPanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MissingSvnClient
implements ActionListener {
    private final MissingSvnClientPanel panel = new MissingSvnClientPanel();

    public MissingSvnClient() {
        this.panel.browseButton.addActionListener(this);
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
    }

    void show() {
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        JButton cancel = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)this.panel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), 2, 0, new Object[]{ok, cancel}, (Object)ok);
        if (DialogDisplayer.getDefault().notify(descriptor) == ok) {
            SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
        }
    }

    private void onBrowseClick() {
        File oldFile = this.getExecutableFile();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(SvnOptionsController.class, (String)"SVNExec");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.panel.executablePathTextField.setText(f.getAbsolutePath());
        }
    }

    private File getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        }
    }
}

