/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import org.netbeans.modules.subversion.Diagnostics;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.CommandReport;
import org.netbeans.modules.subversion.client.MissingSvnClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.config.CertificateFile;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SvnClientExceptionHandler {
    private final ISVNClientAdapter adapter;
    private final SvnClient client;
    private final int handledExceptions;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String CHARSET_NAME = "ASCII7";
    private CertificateFailure[] failures = new CertificateFailure[]{new CertificateFailure(1, "certificate is not yet valid", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotYetValid")), new CertificateFailure(2, "certificate has expired", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureHasExpired")), new CertificateFailure(4, "certificate issued for a different hostname", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureWrongHostname")), new CertificateFailure(8, "issuer is not trusted", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotTrusted"))};
    public static final int EX_UNKNOWN = 0;
    public static final int EX_ACTION_CANCELED_BY_USER = 2;
    public static final int EX_AUTHENTICATION = 4;
    public static final int EX_NO_CERTIFICATE = 8;
    public static final int EX_WRONG_URL = 16;
    public static final int EX_NO_HOST_CONNECTION = 32;
    public static final int EX_UNVERSIONED_RESOURCE = 64;
    public static final int EX_WRONG_URL_IN_REVISION = 128;
    public static final int EX_URL_NON_EXISTENT = 256;
    public static final int EX_HTTP_405 = 512;
    public static final int EX_IS_ALREADY_WC = 1024;
    public static final int EX_CLOSED_CONNECTION = 2048;
    public static final int EX_COMMIT_FAILED = 4096;
    public static final int EX_FILE_ALREADY_EXISTS = 8192;
    public static final int EX_IS_OUT_OF_DATE = 16384;
    public static final int EX_NO_SVN_CLIENT = 32768;
    public static final int EX_HANDLED_EXCEPTIONS = 44;
    public static final int EX_DEFAULT_HANDLED_EXCEPTIONS = 44;
    private final SVNClientException exception;
    private final int exceptionMask;
    static final String ACTION_CANCELED_BY_USER = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ActionCanceledByUser");

    public SvnClientExceptionHandler(SVNClientException exception, ISVNClientAdapter adapter, SvnClient client, int handledExceptions) {
        this.exception = exception;
        this.adapter = adapter;
        this.client = client;
        this.handledExceptions = handledExceptions;
        this.exceptionMask = SvnClientExceptionHandler.getMask(exception.getMessage());
    }

    public boolean handleException() throws Exception {
        if (this.exceptionMask != 0) {
            if ((this.handledExceptions & this.exceptionMask & 0x20) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
            if ((this.handledExceptions & this.exceptionMask & 8) == this.exceptionMask) {
                return this.handleNoCertificateError();
            }
            if ((this.handledExceptions & this.exceptionMask & 4) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
        }
        throw this.getException();
    }

    private boolean handleRepositoryConnectError() {
        boolean ret;
        SVNUrl url = this.client.getSvnUrl();
        String title = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_ConnectionParameters");
        Repository repository = new Repository(64, title);
        repository.selectUrl(url, true);
        JButton retryButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Retry"));
        Object option = repository.show(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_AuthFailed"), new HelpCtx(this.getClass()), new Object[]{retryButton, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel")});
        boolean bl = ret = option == retryButton;
        if (ret) {
            RepositoryConnection rc = repository.getSelectedRC();
            String username = rc.getUsername();
            String password = rc.getPassword();
            this.adapter.setUsername(username);
            this.adapter.setPassword(password);
            SvnModuleConfig.getDefault().insertRecentUrl(rc);
        }
        return ret;
    }

    private boolean handleNoCertificateError() throws Exception {
        SSLSocket socket;
        SVNUrl url = this.client.getSvnUrl();
        String hostString = SvnUtils.ripUserFromHost(url.getHost());
        String realmString = url.getProtocol() + "://" + hostString + ":" + url.getPort();
        File certFile = CertificateFile.getSystemCertFile(realmString);
        File nbCertFile = CertificateFile.getNBCertFile(realmString);
        if (!nbCertFile.exists() && certFile.exists()) {
            FileUtils.copyFile(certFile, CertificateFile.getNBCertFile(realmString));
            return true;
        }
        try {
            socket = this.getSSLSocket(url.getProtocol(), hostString, url.getPort());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
        if (socket == null) {
            return false;
        }
        X509Certificate cert = null;
        Certificate[] serverCerts = null;
        try {
            serverCerts = socket.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        for (int i = 0; i < serverCerts.length; ++i) {
            Diagnostics.println("Cert[" + i + "] type - " + serverCerts[i].getType());
            if (!(serverCerts[i] instanceof X509Certificate)) continue;
            cert = (X509Certificate)serverCerts[i];
            Diagnostics.println("Cert[" + i + "] - notAfter " + cert.getNotAfter());
            Diagnostics.println("Cert[" + i + "] - notBefore " + cert.getNotBefore());
            try {
                cert.checkValidity();
                break;
            }
            catch (CertificateExpiredException ex) {
                Diagnostics.println("Cert[" + i + "] - " + ex);
                continue;
            }
            catch (CertificateNotYetValidException ex) {
                Diagnostics.println("Cert[" + i + "] - " + ex);
            }
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(this.getCertMessage(cert, hostString));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        JButton permanentlyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton temporarilyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton rejectButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{permanentlyButton, temporarilyButton, rejectButton});
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() != permanentlyButton && dialogDescriptor.getValue() != temporarilyButton) {
            return false;
        }
        CertificateFile cf = null;
        try {
            boolean temporarily = dialogDescriptor.getValue() == temporarilyButton;
            cf = new CertificateFile(cert, url.getProtocol() + "://" + hostString + ":" + url.getPort(), this.getFailuresMask(), temporarily);
            cf.store();
        }
        catch (CertificateEncodingException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        return true;
    }

    private SSLSocket getSSLSocket(String protocol, String host, int port) throws Exception {
        TrustManager[] trust = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        ProxySettings proxySettings = new ProxySettings();
        String proxyHost = "";
        int proxyPort = -1;
        if (protocol.startsWith("https")) {
            proxyHost = proxySettings.getHttpsHost();
            proxyPort = proxySettings.getHttpsPort();
        }
        if (proxyHost.equals("")) {
            proxyHost = proxySettings.getHttpHost();
            proxyPort = proxySettings.getHttpPort();
        }
        Socket proxySocket = new Socket(Proxy.NO_PROXY);
        if (proxySettings.isDirect()) {
            proxySocket.connect(new InetSocketAddress(host, port));
        } else {
            boolean directWorks = false;
            try {
                proxySocket.connect(new InetSocketAddress(host, port));
                directWorks = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!directWorks) {
                proxySocket.connect(new InetSocketAddress(proxyHost, proxyPort));
                this.connectProxy(proxySocket, host, port, proxyHost, proxyPort);
            }
        }
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, trust, null);
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(proxySocket, host, port, true);
        socket.startHandshake();
        return socket;
    }

    private void connectProxy(Socket proxy, String host, int port, String proxyHost, int proxyPort) throws IOException {
        byte[] connectBytes;
        String connectString = "CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "Connection: Keep-Alive\r\n\r\n";
        try {
            connectBytes = connectString.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException ignored) {
            connectBytes = connectString.getBytes();
        }
        OutputStream out = proxy.getOutputStream();
        out.write(connectBytes);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = proxy.getInputStream();
        while (newlinesSeen < 2) {
            byte b = (byte)in.read();
            if (b < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (b == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (b == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = b;
        }
        String ret = "";
        try {
            ret = new String(reply, 0, replyLen, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException ignored) {
            ret = new String(reply, 0, replyLen);
        }
        if (!this.isOKresponse(ret.toLowerCase())) {
            throw new IOException("Unable to connect through proxy " + proxyHost + ":" + proxyPort + ".  Proxy returns \"" + ret + "\"");
        }
    }

    private boolean isOKresponse(String ret) {
        return ret.startsWith("http/1.1 200") || ret.startsWith("http/1.0 200");
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private String getCertMessage(X509Certificate cert, String host) {
        CertificateFailure[] certFailures = this.getCertFailures();
        Object[] param = new Object[]{host, cert.getNotBefore(), cert.getNotAfter(), cert.getIssuerDN().getName(), this.getFingerprint(cert, "SHA1"), this.getFingerprint(cert, "MD5")};
        String message = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_BadCertificate", (Object[])param);
        for (int i = 0; i < certFailures.length; ++i) {
            message = certFailures[i].message + message;
        }
        return message;
    }

    private CertificateFailure[] getCertFailures() {
        ArrayList<CertificateFailure> ret = new ArrayList<CertificateFailure>();
        String exceptionMessage = this.getException().getMessage();
        for (int i = 0; i < this.failures.length; ++i) {
            if (exceptionMessage.indexOf(this.failures[i].error) <= -1) continue;
            ret.add(this.failures[i]);
        }
        return ret.toArray(new CertificateFailure[ret.size()]);
    }

    private int getFailuresMask() {
        CertificateFailure[] certFailures = this.getCertFailures();
        if (certFailures.length == 0) {
            return 15;
        }
        int mask = 0;
        for (int i = 0; i < certFailures.length; ++i) {
            mask |= certFailures[i].mask;
        }
        return mask;
    }

    private String getFingerprint(X509Certificate cert, String alg) {
        try {
            String str = new BASE64Encoder().encode(cert.getEncoded());
            str = str.replace(NEWLINE, "");
            MessageDigest md5 = MessageDigest.getInstance(alg);
            byte[] url = new BASE64Decoder().decodeBuffer(str);
            md5.update(url);
            byte[] md5digest = md5.digest();
            String ret = "";
            for (int i = 0; i < md5digest.length; ++i) {
                String hex = Integer.toHexString(md5digest[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                ret = ret + hex + (i < md5digest.length - 1 ? ":" : "");
            }
            return ret;
        }
        catch (CertificateEncodingException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return "";
    }

    private SVNClientException getException() {
        return this.exception;
    }

    private static int getMask(String msg) {
        if (msg == null || msg.trim().equals("")) {
            return 0;
        }
        if (SvnClientExceptionHandler.isAuthentication(msg = msg.toLowerCase())) {
            return 4;
        }
        if (SvnClientExceptionHandler.isCancelledAction(msg)) {
            return 2;
        }
        if (SvnClientExceptionHandler.isNoCertificate(msg)) {
            return 8;
        }
        if (SvnClientExceptionHandler.isWrongUrl(msg)) {
            return 16;
        }
        if (SvnClientExceptionHandler.isNoHostConnection(msg)) {
            return 32;
        }
        if (SvnClientExceptionHandler.isUnversionedResource(msg)) {
            return 64;
        }
        if (SvnClientExceptionHandler.isWrongURLInRevision(msg)) {
            return 128;
        }
        if (SvnClientExceptionHandler.isHTTP405(msg)) {
            return 512;
        }
        if (SvnClientExceptionHandler.isAlreadyAWorkingCopy(msg)) {
            return 1024;
        }
        if (SvnClientExceptionHandler.isClosedConnection(msg)) {
            return 2048;
        }
        if (SvnClientExceptionHandler.isCommitFailed(msg)) {
            return 4096;
        }
        if (SvnClientExceptionHandler.isNoSvnClient(msg)) {
            return 32768;
        }
        return 0;
    }

    private static boolean isCancelledAction(String msg) {
        return msg.equals(ACTION_CANCELED_BY_USER);
    }

    private static boolean isAuthentication(String msg) {
        return msg.indexOf("authentication error from server: username not found") > -1 || msg.indexOf("authorization failed") > -1 || msg.indexOf("authentication error from server: password incorrect") > -1 || msg.indexOf("can't get password") > -1;
    }

    private static boolean isNoCertificate(String msg) {
        return msg.indexOf("server certificate verification failed") > -1;
    }

    public static boolean isWrongUrl(String msg) {
        return (msg = msg.toLowerCase()).indexOf("(not a valid url)") > -1;
    }

    private static boolean isNoHostConnection(String msg) {
        return msg.indexOf("host not found") > -1 || msg.indexOf("could not connect to server") > -1 || msg.indexOf("could not resolve hostname") > -1;
    }

    public static boolean isUnversionedResource(String msg) {
        return (msg = msg.toLowerCase()).indexOf("(not a versioned resource)") > -1 || msg.indexOf("is not a working copy") > -1;
    }

    public static boolean isWrongURLInRevision(String msg) {
        if ((msg = msg.toLowerCase()).indexOf("no such revision") > -1) {
            return true;
        }
        int idx = msg.indexOf("unable to find repository location for");
        if (idx > -1 && msg.indexOf("in revision", idx + 23) > -1) {
            return true;
        }
        idx = msg.indexOf("url");
        return idx > -1 && msg.indexOf("non-existent in that revision", idx + 3) > -1;
    }

    private static boolean isHTTP405(String msg) {
        return msg.indexOf("405") > -1;
    }

    private static boolean isAlreadyAWorkingCopy(String msg) {
        return msg.indexOf("is already a working copy for a different url") > -1;
    }

    private static boolean isClosedConnection(String msg) {
        return msg.indexOf("could not read status line: an existing connection was forcibly closed by the remote host.") > -1;
    }

    private static boolean isCommitFailed(String msg) {
        return msg.indexOf("commit failed (details follow)") > -1;
    }

    public static boolean isFileAlreadyExists(String msg) {
        return (msg = msg.toLowerCase()).indexOf("file already exists") > -1 || msg.indexOf("mkcol") > -1 && SvnClientExceptionHandler.isHTTP405(msg);
    }

    private static boolean isOutOfDate(String msg) {
        return msg.indexOf("out of date") > -1;
    }

    private static boolean isNoSvnClient(String msg) {
        msg = msg.toLowerCase();
        return msg.equals("command line client adapter is not available");
    }

    public static void notifyException(Exception ex, boolean annotate, boolean isUI) {
        if (SvnClientExceptionHandler.isNoSvnClient(ex.getMessage())) {
            if (isUI) {
                SvnClientExceptionHandler.notifyNoClient();
            }
            return;
        }
        if (SvnClientExceptionHandler.isCancelledAction(ex.getMessage())) {
            SvnClientExceptionHandler.cancelledAction();
            return;
        }
        ErrorManager.getDefault().notify(1, (Throwable)ex);
        if (annotate) {
            String msg = SvnClientExceptionHandler.getCustomizedMessage(ex);
            if (msg == null) {
                msg = ex instanceof SVNClientException ? SvnClientExceptionHandler.parseExceptionMessage((SVNClientException)((Object)ex)) : ex.getMessage();
            }
            SvnClientExceptionHandler.annotate(msg);
        }
    }

    private static void notifyNoClient() {
        MissingSvnClient msc = new MissingSvnClient();
        msc.show();
    }

    private static String getCustomizedMessage(Exception exception) {
        String msg = null;
        if (SvnClientExceptionHandler.isHTTP405(exception.getMessage())) {
            msg = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error405");
        } else if (SvnClientExceptionHandler.isOutOfDate(exception.getMessage())) {
            msg = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_OutOfDate") + "\n";
        }
        return msg;
    }

    public static String parseExceptionMessage(SVNClientException ex) {
        String msg = ex.getMessage();
        int idx = msg.lastIndexOf("svn: ");
        if (idx > -1) {
            msg = msg.substring(idx + 5);
        }
        return msg;
    }

    private static void annotate(String msg) {
        CommandReport report = new CommandReport(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_SubversionCommandError"), msg);
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_CommandReport_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)report, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), -1, 0, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    private static void cancelledAction() {
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)ACTION_CANCELED_BY_USER, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_ActionCanceled_Title"), -1, 2, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    static void handleInvalidKeyException(InvalidKeyException ike) {
        ErrorManager.getDefault().notify(1, (Throwable)ike);
        String msg = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_InvalidKeyException");
        SvnClientExceptionHandler.annotate(msg);
    }

    private class CertificateFailure {
        int mask;
        String error;
        String message;

        CertificateFailure(int mask, String error, String message) {
            this.mask = mask;
            this.error = error;
            this.message = message;
        }
    }
}

