/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLKeyException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SvnClientInvocationHandler
implements InvocationHandler {
    private static Set<String> remoteMethods = new HashSet<String>();
    private static Object semaphor;
    private final ISVNClientAdapter adapter;
    private final SvnClientDescriptor desc;
    private Cancellable cancellable;
    private SvnProgressSupport support;
    private final int handledExceptions;

    public SvnClientInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, int handledExceptions) {
        assert (adapter != null);
        assert (desc != null);
        this.adapter = adapter;
        this.desc = desc;
        this.handledExceptions = handledExceptions;
    }

    public SvnClientInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
        assert (adapter != null);
        assert (desc != null);
        this.adapter = adapter;
        this.desc = desc;
        this.support = support;
        this.handledExceptions = handledExceptions;
        this.cancellable = new Cancellable(){

            public boolean cancel() {
                try {
                    SvnClientInvocationHandler.this.adapter.cancelOperation();
                }
                catch (SVNClientException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    return false;
                }
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        assert (this.noRemoteCallinAWT(methodName, args)) : "noRemoteCallinAWT(): " + methodName;
        try {
            Object ret = null;
            if (SwingUtilities.isEventDispatchThread()) {
                ret = this.invokeMethod(method, args);
            } else {
                Object object = semaphor;
                synchronized (object) {
                    ret = this.invokeMethod(method, args);
                }
            }
            Subversion.getInstance().getStatusCache().refreshDirtyFileSystems();
            return ret;
        }
        catch (Exception e) {
            try {
                if (this.handleException((SvnClient)proxy, e)) {
                    return this.invoke(proxy, method, args);
                }
                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof SVNClientException) {
                    throw t;
                }
                throw ite;
            }
            catch (SSLKeyException ex) {
                if (ex.getCause() instanceof InvalidKeyException) {
                    InvalidKeyException ike = (InvalidKeyException)ex.getCause();
                    if (ike.getMessage().toLowerCase().equals("illegal key size or default parameters")) {
                        SvnClientExceptionHandler.handleInvalidKeyException(ike);
                    }
                    return null;
                }
                throw ex;
            }
        }
    }

    protected Object invokeMethod(Method proxyMethod, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.handle(proxyMethod, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handle(Method proxyMethod, Object[] args) throws SecurityException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException {
        Class<?>[] parameters = proxyMethod.getParameterTypes();
        Class<?> declaringClass = proxyMethod.getDeclaringClass();
        if (ISVNClientAdapter.class.isAssignableFrom(declaringClass)) {
            if (this.support != null) {
                this.support.setCancellableDelegate(this.cancellable);
            }
            if (this.desc != null && this.desc.getSvnUrl() != null) {
                SvnConfigFiles.getInstance().setProxy(this.desc.getSvnUrl());
            }
        } else {
            if (Cancellable.class.isAssignableFrom(declaringClass)) {
                return this.cancellable.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.cancellable, args);
            }
            if (!SvnClientDescriptor.class.isAssignableFrom(declaringClass)) return this.adapter.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.adapter, args);
            if (this.desc == null) throw new NoSuchMethodException(proxyMethod.getName());
            return this.desc.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.desc, args);
        }
        Object ret = this.adapter.getClass().getMethod(proxyMethod.getName(), parameters).invoke((Object)this.adapter, args);
        if (this.support == null) return ret;
        this.support.setCancellableDelegate(null);
        return ret;
    }

    private boolean handleException(SvnClient client, Throwable t) throws Throwable {
        Object svnException = null;
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (!(t instanceof SVNClientException)) {
            throw t;
        }
        SvnClientExceptionHandler eh = new SvnClientExceptionHandler((SVNClientException)t, this.adapter, client, this.handledExceptions);
        return eh.handleException();
    }

    protected boolean noRemoteCallinAWT(String methodName, Object[] args) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return true;
        }
        return !remoteMethods.contains(methodName);
    }

    static {
        remoteMethods.add("checkout");
        remoteMethods.add("commit");
        remoteMethods.add("commitAcrossWC");
        remoteMethods.add("getList");
        remoteMethods.add("getDirEntry");
        remoteMethods.add("copy");
        remoteMethods.add("remove");
        remoteMethods.add("doExport");
        remoteMethods.add("doImport");
        remoteMethods.add("mkdir");
        remoteMethods.add("move");
        remoteMethods.add("update");
        remoteMethods.add("getLogMessages");
        remoteMethods.add("getContent");
        remoteMethods.add("setRevProperty");
        remoteMethods.add("diff");
        remoteMethods.add("annotate");
        remoteMethods.add("getInfo");
        remoteMethods.add("switchToUrl");
        remoteMethods.add("merge");
        remoteMethods.add("lock");
        remoteMethods.add("unlock");
        semaphor = new Object();
    }
}

