/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.subversion.client.parser.EntriesCache;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.client.parser.ParserSvnStatus;
import org.netbeans.modules.subversion.client.parser.WorkingCopyDetails;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcParser {
    private WorkingCopyDetails getWCDetails(File file) throws IOException, SAXException {
        Map<String, String> attributes = EntriesCache.getInstance().getFileAttributes(file);
        return WorkingCopyDetails.createWorkingCopy(file, attributes);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws LocalSubversionException {
        List<ISVNStatus> l = this.getStatus(path, descend);
        return l.toArray(new ISVNStatus[l.size()]);
    }

    private List<ISVNStatus> getStatus(File path, boolean descend) throws LocalSubversionException {
        ArrayList<ISVNStatus> ret = new ArrayList<ISVNStatus>(20);
        File[] children = path.listFiles();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                ret.add(this.getSingleStatus(children[i]));
                if (!descend || !children[i].isDirectory()) continue;
                ret.addAll(this.getStatus(children[i], descend));
            }
        }
        ret.add(this.getSingleStatus(path));
        return ret;
    }

    public ISVNStatus getSingleStatus(File file) throws LocalSubversionException {
        String finalTextStatus = SVNStatusKind.NORMAL.toString();
        String finalPropStatus = SVNStatusKind.NONE.toString();
        try {
            WorkingCopyDetails wcDetails = this.getWCDetails(file);
            if (wcDetails.isHandled()) {
                String value;
                if (wcDetails.propertiesExist()) {
                    finalPropStatus = SVNStatusKind.NORMAL.toString();
                    if (wcDetails.propertiesModified()) {
                        finalPropStatus = SVNStatusKind.MODIFIED.toString();
                    }
                }
                if (wcDetails.isFile() && wcDetails.textModified()) {
                    finalTextStatus = SVNStatusKind.MODIFIED.toString();
                }
                if ((value = wcDetails.getValue("schedule")) != null) {
                    if (value.equals("add")) {
                        finalTextStatus = SVNStatusKind.ADDED.toString();
                        finalPropStatus = SVNStatusKind.NONE.toString();
                    } else if (value.equals("delete")) {
                        finalTextStatus = SVNStatusKind.DELETED.toString();
                        finalPropStatus = SVNStatusKind.NONE.toString();
                    }
                }
                if ((value = wcDetails.getValue("deleted")) != null && value.equals("true")) {
                    finalTextStatus = SVNStatusKind.UNVERSIONED.toString();
                    finalPropStatus = SVNStatusKind.NONE.toString();
                }
                String fileUrl = wcDetails.getValue("url");
                long revision = wcDetails.getLongValue("revision");
                String nodeKind = wcDetails.getValue("kind", "normal");
                String lastCommitAuthor = wcDetails.getValue("last-author");
                long lastChangedRevision = wcDetails.getLongValue("committed-rev");
                Date lastCommittedDate = wcDetails.getDateValue("committed-date");
                boolean isCopied = wcDetails.getBooleanValue("copied");
                String urlCopiedFrom = null;
                if (isCopied) {
                    urlCopiedFrom = wcDetails.getValue("copyfrom-url");
                }
                File conflictNew = null;
                File conflictOld = null;
                File conflictWorking = null;
                value = wcDetails.getValue("conflict-wrk");
                if (value != null && value.length() > 0) {
                    conflictWorking = new File(file.getParentFile(), value);
                }
                if ((value = wcDetails.getValue("conflict-new")) != null && value.length() > 0) {
                    conflictNew = new File(file.getParentFile(), value);
                }
                if ((value = wcDetails.getValue("conflict-old")) != null && value.length() > 0) {
                    conflictOld = new File(file.getParentFile(), value);
                }
                if (conflictNew != null || conflictOld != null) {
                    finalTextStatus = SVNStatusKind.CONFLICTED.toString();
                }
                Date lockCreationDate = wcDetails.getDateValue("lock-creation-date");
                String lockComment = null;
                String lockOwner = null;
                if (lockCreationDate != null) {
                    lockComment = wcDetails.getValue("lock-comment");
                    lockOwner = wcDetails.getValue("lock-owner");
                }
                return new ParserSvnStatus(file, fileUrl, revision, nodeKind, finalTextStatus, finalPropStatus, lastCommitAuthor, lastChangedRevision, lastCommittedDate, isCopied, urlCopiedFrom, conflictNew, conflictOld, conflictWorking, lockCreationDate, lockComment, lockOwner);
            }
            return new ParserSvnStatus(file, wcDetails.getValue("url"), 0L, "unknown", SVNStatusKind.UNVERSIONED.toString(), SVNStatusKind.UNVERSIONED.toString(), null, 0L, null, false, null, null, null, null, null, null, null);
        }
        catch (IOException ex) {
            throw new LocalSubversionException(ex);
        }
        catch (SAXException ex) {
            throw new LocalSubversionException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new LocalSubversionException(ex);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws LocalSubversionException {
        ParserSvnInfo returnValue = null;
        try {
            WorkingCopyDetails wcDetails = this.getWCDetails(file);
            if (wcDetails.isHandled()) {
                String fileUrl = wcDetails.getValue("url");
                String reposUrl = wcDetails.getValue("repos");
                String reposUuid = wcDetails.getValue("uuid");
                String schedule = wcDetails.getValue("schedule");
                if (schedule == null) {
                    schedule = SVNScheduleKind.NORMAL.toString();
                }
                long revision = wcDetails.getLongValue("revision");
                boolean isCopied = wcDetails.getBooleanValue("copied");
                String urlCopiedFrom = null;
                long revisionCopiedFrom = 0L;
                if (isCopied) {
                    urlCopiedFrom = wcDetails.getValue("copyfrom-url");
                    revisionCopiedFrom = wcDetails.getLongValue("copyfrom-rev");
                }
                Date lastCommittedDate = wcDetails.getDateValue("committed-date");
                long lastChangedRevision = wcDetails.getLongValue("committed-rev");
                String lastCommitAuthor = wcDetails.getValue("last-author");
                Date lastDatePropsUpdate = wcDetails.getDateValue("prop-time");
                Date lastDateTextUpdate = wcDetails.getDateValue("text-time");
                Date lockCreationDate = wcDetails.getDateValue("lock-creation-date");
                String lockComment = null;
                String lockOwner = null;
                if (lockCreationDate != null) {
                    lockComment = wcDetails.getValue("lock-comment");
                    lockOwner = wcDetails.getValue("lock-owner");
                }
                String nodeKind = wcDetails.getValue("kind", "normal");
                returnValue = new ParserSvnInfo(file, fileUrl, reposUrl, reposUuid, schedule, revision, isCopied, urlCopiedFrom, revisionCopiedFrom, lastCommittedDate, lastChangedRevision, lastCommitAuthor, lastDatePropsUpdate, lastDateTextUpdate, lockCreationDate, lockOwner, lockComment, nodeKind, wcDetails.getPropertiesFile(), wcDetails.getBasePropertiesFile());
            } else {
                String fileUrl = wcDetails.getValue("url");
                String reposUrl = wcDetails.getValue("repos");
                String reposUuid = wcDetails.getValue("uuid");
                returnValue = new ParserSvnInfo(file, fileUrl, reposUrl, reposUuid, SVNScheduleKind.NORMAL.toString(), 0L, false, null, 0L, null, 0L, null, null, null, null, null, null, SVNNodeKind.UNKNOWN.toString(), null, null);
            }
        }
        catch (IOException ex) {
            throw new LocalSubversionException(ex);
        }
        catch (SAXException ex) {
            throw new LocalSubversionException(ex);
        }
        return returnValue;
    }
}

