/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SvnWcUtils {
    private static final String ENTRIES = "entries";
    public static final String[] ADMIN_DIR_NAMES = new String[]{".svn", "_svn"};
    private static final String PROPS = "props";
    private static final String PROPS_BASE = "prop-base";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");

    public static File getSvnFile(File file, String svnFileName) throws IOException {
        for (int i = 0; i < ADMIN_DIR_NAMES.length; ++i) {
            File svnFile = new File(file, ADMIN_DIR_NAMES[i] + "/" + svnFileName);
            if (!svnFile.canRead()) continue;
            return svnFile;
        }
        return null;
    }

    public static File getPropertiesFile(File file, boolean base) throws IOException {
        if (file.isFile()) {
            if (base) {
                return SvnWcUtils.getSvnFile(file.getParentFile(), "prop-base/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(base));
            }
            return SvnWcUtils.getSvnFile(file.getParentFile(), "props/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(base));
        }
        return SvnWcUtils.getSvnFile(file, base ? "/dir-prop-base" : "/dir-props");
    }

    private static String getPropFileNameSuffix(boolean base) {
        if (base) {
            return ".svn-base";
        }
        return ".svn-work";
    }

    public static File getTextBaseFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(file.getParentFile(), "text-base/" + file.getName() + ".svn-base");
    }

    public static Date parseSvnDate(String inputValue) throws ParseException {
        Date returnValue = null;
        if (inputValue != null) {
            returnValue = dateFormat.parse(inputValue);
        }
        return returnValue;
    }

    static File getEntriesFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(!file.isDirectory() ? file.getParentFile() : file, ENTRIES);
    }
}

