/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.subversion.util.FileUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KVFile {
    private Map<Key, byte[]> map;
    private Map<String, Key> keyMap;
    private final File file;

    public KVFile(File file) {
        this.file = file;
        try {
            if (file.exists()) {
                this.parse();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    protected byte[] getValue(Key key) {
        return this.getMap().get(key);
    }

    protected String getStringValue(Key key) {
        try {
            byte[] value = this.getValue(key);
            if (value == null) {
                return null;
            }
            return new String(value, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return null;
        }
    }

    protected void setValue(Key key, byte[] value) {
        this.getMap().put(key, value);
    }

    public Map<Key, byte[]> getMap() {
        if (this.map == null) {
            this.map = new TreeMap<Key, byte[]>();
        }
        return this.map;
    }

    private Map<String, Key> getKeyMap() {
        if (this.keyMap == null) {
            this.keyMap = new HashMap<String, Key>();
        }
        return this.keyMap;
    }

    protected Key getKey(Key key) {
        Key storedKey = this.getKey(key.getName());
        if (storedKey == null) {
            this.setKey(key);
            return key;
        }
        return storedKey;
    }

    private Key getKey(String name) {
        return this.getKeyMap().get(name);
    }

    protected void setKey(Key key) {
        this.getKeyMap().put(key.getName(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        BufferedInputStream is = null;
        try {
            is = FileUtils.createInputStream(this.file);
            int keyIdx = 0;
            while (!this.checkEOF(is)) {
                int keyLength = this.readEntryLength(is);
                byte[] keyName = new byte[keyLength];
                ((InputStream)is).read(keyName);
                ((InputStream)is).read();
                int valueLength = this.readEntryLength(is);
                byte[] value = new byte[valueLength];
                ((InputStream)is).read(value);
                Key key = new Key(keyIdx, new String(keyName, "UTF8"));
                this.setKey(key);
                this.getMap().put(key, value);
                ((InputStream)is).read();
                ++keyIdx;
            }
        }
        catch (EOFException eofe) {
            if (this.getMap().size() > 0) {
                throw new EOFException(this.file.getAbsolutePath());
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private boolean checkEOF(InputStream is) throws IOException {
        is.mark(3);
        byte[] end = new byte[3];
        is.read(end);
        is.reset();
        if (end[0] == -1 || end[1] == -1 || end[2] == -1) {
            throw new EOFException();
        }
        return end[0] == 69 && end[1] == 78 && end[2] == 68;
    }

    private int readEntryLength(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte b = (byte)is.read();
        while (b != 10) {
            if (b == -1) {
                throw new EOFException();
            }
            baos.write(b);
            b = (byte)is.read();
        }
        String line = baos.toString();
        return Integer.decode(line.substring(2));
    }

    public void store() throws IOException {
        this.store(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        OutputStream os = null;
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            os = FileUtils.createOutputStream(file);
            for (Key key : this.getMap().keySet()) {
                byte[] value = this.map.get(key);
                StringBuffer sb = new StringBuffer();
                sb.append("K ");
                sb.append(key.getName().length());
                sb.append("\n");
                sb.append(key.getName());
                sb.append("\n");
                sb.append("V ");
                sb.append(value.length);
                sb.append("\n");
                os.write(sb.toString().getBytes("UTF8"));
                os.write(value);
                os.write("\n".getBytes());
            }
            os.write("END\n".getBytes());
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    protected File getFile() {
        return this.file;
    }

    void setValue(Key key, String value) {
        this.setValue(key, value.getBytes());
    }

    protected static class Key
    implements Comparable {
        private final int idx;
        private final String name;

        protected Key(int idx, String name) {
            this.name = name;
            this.idx = idx;
        }

        public int getIndex() {
            return this.idx;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.getIndex() == this.getIndex() && key.getName().equals(this.getName());
        }

        public int hashCode() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName());
            sb.append(this.getIndex());
            return sb.toString().hashCode();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Key)) {
                return 0;
            }
            Key key = (Key)obj;
            if (key.getIndex() < this.getIndex()) {
                return 1;
            }
            if (key.getIndex() > this.getIndex()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.name;
        }
    }
}

