/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.ini4j.Ini;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnConfigFiles {
    private static SvnConfigFiles instance;
    private Ini svnServers = null;
    private Ini config = this.copyConfigFileToIDEConfigDir("config", new ConfigIniFilePatcher());
    private ProxySettings proxySettings;
    private static final String UNIX_CONFIG_DIR = ".subversion/";
    private static final String GROUPS_SECTION = "groups";
    private static final String GLOBAL_SECTION = "global";
    private static final String WINDOWS_USER_APPDATA;
    private static final String WINDOWS_CONFIG_DIR;
    private static final String WINDOWS_GLOBAL_CONFIG_DIR;
    private static final List<String> DEFAULT_GLOBAL_IGNORES;

    private SvnConfigFiles() {
        this.svnServers = this.loadSystemIniFile("servers");
    }

    public static SvnConfigFiles getInstance() {
        if (instance == null) {
            instance = new SvnConfigFiles();
        }
        return instance;
    }

    public void setProxy(SVNUrl url) {
        assert (url != null) : "can't do anything for a null host";
        if (!url.getProtocol().startsWith("http") && !url.getProtocol().startsWith("https")) {
            return;
        }
        String host = SvnUtils.ripUserFromHost(url.getHost());
        ProxySettings ps = new ProxySettings();
        if (this.proxySettings != null && ps.equals(this.proxySettings)) {
            return;
        }
        this.proxySettings = ps;
        Ini nbServers = new Ini();
        Ini.Section nbGlobalSection = nbServers.add(GLOBAL_SECTION);
        Ini.Section svnGlobalSection = (Ini.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        if (this.proxySettings.isDirect()) {
            if (svnGlobalSection != null) {
                this.mergeNonProxyKeys(svnGlobalSection, nbGlobalSection);
            }
        } else {
            Preferences prefs;
            boolean useAuth;
            String proxyHost = "";
            int proxyPort = -1;
            if (url.getProtocol().startsWith("https")) {
                proxyHost = this.proxySettings.getHttpsHost();
                proxyPort = this.proxySettings.getHttpsPort();
            }
            if (proxyHost.equals("")) {
                proxyHost = this.proxySettings.getHttpHost();
                proxyPort = this.proxySettings.getHttpPort();
            }
            String exceptions = this.proxySettings.getNotProxyHosts();
            nbGlobalSection.put((Object)"http-proxy-host", (Object)proxyHost);
            nbGlobalSection.put((Object)"http-proxy-port", (Object)Integer.toString(proxyPort));
            if (!exceptions.equals("")) {
                nbGlobalSection.put((Object)"http-proxy-exceptions", (Object)exceptions);
            }
            if (useAuth = (prefs = NbPreferences.root().node("org/netbeans/core")).getBoolean("useProxyAuthentication", false)) {
                String username = prefs.get("proxyAuthenticationUsername", "");
                String password = prefs.get("proxyAuthenticationPassword", "");
                nbGlobalSection.put((Object)"http-proxy-username", (Object)username);
                nbGlobalSection.put((Object)"http-proxy-password", (Object)password);
            }
            Ini.Section svnHostGroup = this.getServerGroup(host);
            if (svnGlobalSection != null) {
                this.mergeNonProxyKeys(svnGlobalSection, nbGlobalSection);
            }
            if (svnHostGroup != null) {
                this.mergeNonProxyKeys(svnHostGroup, nbGlobalSection);
            }
        }
        this.storeIni(nbServers, "servers");
    }

    private void mergeNonProxyKeys(Ini.Section source, Ini.Section target) {
        for (String key : source.keySet()) {
            if (this.isProxyConfigurationKey(key)) continue;
            target.put((Object)key, source.get((Object)key));
        }
    }

    public void setExternalCommand(String tunnelName, String command) {
        Ini.Section tunnels = this.getSection(this.config, "tunnels", true);
        tunnels.put((Object)tunnelName, (Object)command);
        this.storeIni(this.config, "config");
    }

    public String getExternalCommand(String tunnelName) {
        Ini.Section tunnels = this.getSection(this.config, "tunnels", true);
        String cmd = (String)tunnels.get((Object)tunnelName);
        return cmd != null ? cmd : "";
    }

    private Ini.Section getSection(Ini ini, String key, boolean create) {
        Ini.Section section = (Ini.Section)ini.get((Object)key);
        if (section == null) {
            return ini.add(key);
        }
        return section;
    }

    private void storeIni(Ini ini, String iniFile) {
        try {
            File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + iniFile));
            file.getParentFile().mkdirs();
            ini.store((OutputStream)FileUtils.createOutputStream(file));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public List<String> getGlobalIgnores() {
        String ignores;
        Ini.Section miscellany = (Ini.Section)this.config.get((Object)"miscellany");
        if (miscellany != null && (ignores = (String)miscellany.get((Object)"global-ignores")) != null && ignores.trim().length() > 0) {
            return SvnConfigFiles.parseGlobalIgnores(ignores);
        }
        return DEFAULT_GLOBAL_IGNORES;
    }

    private static List<String> parseGlobalIgnores(String ignores) {
        StringTokenizer st = new StringTokenizer(ignores, " ");
        ArrayList<String> ret = new ArrayList<String>(10);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry.equals("")) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static String getUserConfigPath() {
        if (Utilities.isUnix()) {
            String path = System.getProperty("user.home");
            return path + "/" + UNIX_CONFIG_DIR;
        }
        if (Utilities.isWindows()) {
            return WINDOWS_CONFIG_DIR;
        }
        return "";
    }

    public static String getNBConfigPath() {
        String nbHome = System.getProperty("netbeans.user");
        return nbHome + "/config/svn/config/";
    }

    private Ini.Section getServerGroup(String host) {
        if (host == null || host.equals("")) {
            return null;
        }
        Ini.Section groups = (Ini.Section)this.svnServers.get((Object)GROUPS_SECTION);
        if (groups != null) {
            for (String key : groups.keySet()) {
                String value = (String)groups.get((Object)key);
                if (value == null || (value = value.trim()) == null || !this.match(value, host)) continue;
                return (Ini.Section)this.svnServers.get((Object)key);
            }
        }
        return null;
    }

    private boolean match(String value, String host) {
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            value = values[i].trim();
            if (value.equals("*") || value.equals(host)) {
                return true;
            }
            int idx = value.indexOf("*");
            if (idx <= -1 || !this.matchSegments(value, host)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSegments(String value, String host) {
        String[] valueSegments = value.split(".");
        String[] hostSegments = host.split(".");
        int idx = 0;
        for (int i = 0; i < hostSegments.length; ++i) {
            if (!valueSegments[idx].equals("*") && !valueSegments[idx].equals(hostSegments[i])) {
                return false;
            }
            if (valueSegments[idx].equals("*")) continue;
            ++idx;
        }
        return false;
    }

    private Ini copyConfigFileToIDEConfigDir(String fileName, IniFilePatcher patcher) {
        Ini systemIniFile = this.loadSystemIniFile(fileName);
        patcher.patch(systemIniFile);
        File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + fileName));
        try {
            file.getParentFile().mkdirs();
            systemIniFile.store((OutputStream)FileUtils.createOutputStream(file));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return systemIniFile;
    }

    private Ini loadSystemIniFile(String fileName) {
        String filePath = SvnConfigFiles.getUserConfigPath() + "/" + fileName;
        File file = FileUtil.normalizeFile((File)new File(filePath));
        Ini system = null;
        try {
            system = new Ini((Reader)new FileReader(file));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (system == null) {
            system = new Ini();
            ErrorManager.getDefault().log(16, "Could not load the file " + filePath + ". Falling back on svn defaults.");
        }
        Ini global = null;
        try {
            global = new Ini((Reader)new FileReader(SvnConfigFiles.getGlobalConfigPath() + "/" + fileName));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (global != null) {
            this.merge(global, system);
        }
        return system;
    }

    private void merge(Ini source, Ini target) {
        for (String sectionName : source.keySet()) {
            Ini.Section sourceSection = (Ini.Section)source.get((Object)sectionName);
            Ini.Section targetSection = (Ini.Section)target.get((Object)sectionName);
            if (targetSection == null) {
                targetSection = target.add(sectionName);
            }
            for (String key : sourceSection.keySet()) {
                if (targetSection.containsKey((Object)key)) continue;
                targetSection.put((Object)key, sourceSection.get((Object)key));
            }
        }
    }

    private boolean isProxyConfigurationKey(String key) {
        return key.equals("http-proxy-host") || key.equals("http-proxy-port") || key.equals("http-proxy-username") || key.equals("http-proxy-password");
    }

    private static String getGlobalConfigPath() {
        if (Utilities.isUnix()) {
            return "/etc/subversion";
        }
        if (Utilities.isWindows()) {
            return WINDOWS_GLOBAL_CONFIG_DIR;
        }
        return "";
    }

    private static String getAPPDATA() {
        String appdata = "";
        if (Utilities.isWindows()) {
            appdata = System.getenv("APPDATA");
        }
        return appdata != null ? appdata : "";
    }

    private static String getGlobalAPPDATA() {
        if (Utilities.isWindows()) {
            String appdataPath;
            String globalProfile = System.getenv("ALLUSERSPROFILE");
            if (globalProfile == null || globalProfile.trim().equals("")) {
                globalProfile = "";
            }
            if ((appdataPath = WINDOWS_USER_APPDATA) == null || appdataPath.equals("")) {
                return "";
            }
            String appdata = "";
            int idx = appdataPath.lastIndexOf("\\");
            if (idx > -1) {
                appdata = appdataPath.substring(idx + 1);
                if (appdata.trim().equals("")) {
                    int previdx = appdataPath.lastIndexOf("\\", idx);
                    if (idx > -1) {
                        appdata = appdataPath.substring(previdx + 1, idx);
                    }
                }
            } else {
                return "";
            }
            return globalProfile + "/" + appdata;
        }
        return "";
    }

    static {
        WINDOWS_USER_APPDATA = SvnConfigFiles.getAPPDATA();
        WINDOWS_CONFIG_DIR = WINDOWS_USER_APPDATA + "\\Subversion";
        WINDOWS_GLOBAL_CONFIG_DIR = SvnConfigFiles.getGlobalAPPDATA() + "\\Subversion";
        DEFAULT_GLOBAL_IGNORES = SvnConfigFiles.parseGlobalIgnores("*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store");
    }

    private class ConfigIniFilePatcher
    implements IniFilePatcher {
        private ConfigIniFilePatcher() {
        }

        public void patch(Ini file) {
            Ini.Section auth = (Ini.Section)file.get((Object)"auth");
            if (auth == null) {
                auth = file.add("auth");
            }
            auth.put((Object)"store-auth-creds", (Object)"no");
        }
    }

    private static interface IniFilePatcher {
        public void patch(Ini var1);
    }
}

