/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.options.AnnotationSettings;
import org.netbeans.modules.subversion.options.LabelsPanel;
import org.netbeans.modules.subversion.options.SvnOptionsPanel;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SvnOptionsController
extends OptionsPanelController
implements ActionListener {
    private final SvnOptionsPanel panel;
    private final Repository repository;
    private final AnnotationSettings annotationSettings;

    public SvnOptionsController() {
        int repositoryModeMask = 20;
        String title = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_Repository_Location");
        this.repository = new Repository(repositoryModeMask, title);
        this.annotationSettings = new AnnotationSettings();
        this.panel = new SvnOptionsPanel();
        this.panel.browseButton.addActionListener(this);
        this.panel.manageConnSettingsButton.addActionListener(this);
        this.panel.manageLabelsButton.addActionListener(this);
        String tooltip = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.annotationTextField.toolTipText", (Object[])Annotator.LABELS);
        this.panel.annotationTextField.setToolTipText(tooltip);
        this.panel.addButton.addActionListener(this);
    }

    public void update() {
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.panel.annotationTextField.setText(SvnModuleConfig.getDefault().getDefaultAnnotationFormat());
        this.annotationSettings.update();
        this.repository.refreshUrlHistory();
    }

    public void applyChanges() {
        SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
        SvnModuleConfig.getDefault().setAnnotationFormat(this.panel.annotationTextField.getText());
        this.annotationSettings.applyChanges();
        Subversion.getInstance().getAnnotator().refresh();
        Subversion.getInstance().refreshAllAnnotations();
        this.repository.storeRecentUrls();
    }

    public void cancel() {
        this.repository.refreshUrlHistory();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.advanced.subversion");
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.panel.manageConnSettingsButton) {
            this.onManageConnClick();
        } else if (evt.getSource() == this.panel.manageLabelsButton) {
            this.onManageLabelsClick();
        } else if (evt.getSource() == this.panel.addButton) {
            this.onAddClick();
        }
    }

    private File getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    private void onBrowseClick() {
        File oldFile = this.getExecutableFile();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(SvnOptionsController.class, (String)"SVNExec");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.panel.executablePathTextField.setText(f.getAbsolutePath());
        }
    }

    private void onManageConnClick() {
        boolean ok = this.repository.show(NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageConnections"), new HelpCtx(Repository.class));
        if (!ok) {
            this.repository.refreshUrlHistory();
        }
    }

    private void onManageLabelsClick() {
        String labelFormat = this.panel.annotationTextField.getText().replaceAll(" ", "");
        this.annotationSettings.show(labelFormat != null && labelFormat.indexOf("{folder}") > -1);
    }

    private void onAddClick() {
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<LabelVariable> variables = new ArrayList<LabelVariable>(Annotator.LABELS.length);
        for (int i = 0; i < Annotator.LABELS.length; ++i) {
            LabelVariable variable = new LabelVariable(Annotator.LABELS[i], "{" + Annotator.LABELS[i] + "} - " + NbBundle.getMessage(AnnotationSettings.class, (String)("AnnotationSettings.label." + Annotator.LABELS[i])));
            variables.add(variable);
        }
        labelsPanel.labelsList.setListData(variables.toArray(new LabelVariable[variables.size()]));
        String title = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.title");
        String acsd = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, title);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] selection = labelsPanel.labelsList.getSelectedValues();
            String variable = "";
            for (int i = 0; i < selection.length; ++i) {
                variable = variable + "{" + ((LabelVariable)selection[i]).getVariable() + "}";
            }
            String annotation = this.panel.annotationTextField.getText();
            int pos = this.panel.annotationTextField.getCaretPosition();
            if (pos < 0) {
                pos = annotation.length();
            }
            StringBuffer sb = new StringBuffer(annotation.length() + variable.length());
            sb.append(annotation.substring(0, pos));
            sb.append(variable);
            if (pos < annotation.length()) {
                sb.append(annotation.substring(pos, annotation.length()));
            }
            this.panel.annotationTextField.setText(sb.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(pos + variable.length());
        }
    }

    private class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String variable, String description) {
            this.description = description;
            this.variable = variable;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

