/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.blame;

import java.io.File;
import java.util.Arrays;
import javax.swing.JEditorPane;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.blame.AnnotateLine;
import org.netbeans.modules.subversion.ui.blame.AnnotationBar;
import org.netbeans.modules.subversion.ui.blame.AnnotationBarManager;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BlameAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        if (this.visible(activatedNodes)) {
            return "CTL_MenuItem_HideAnnotations";
        }
        return "CTL_MenuItem_ShowAnnotations";
    }

    public boolean enable(Node[] nodes) {
        return super.enable(nodes) && this.activatedEditorCookie(nodes) != null;
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (this.visible(nodes)) {
            JEditorPane pane = this.activatedEditorPane(nodes);
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            SVNUrl repository;
            EditorCookie ec = this.activatedEditorCookie(nodes);
            if (ec == null) {
                return;
            }
            final File file = this.activatedFile(nodes);
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                ec.open();
            }
            if ((panes = ec.getOpenedPanes()) == null) {
                return;
            }
            JEditorPane currentPane = panes[0];
            final AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationSubstitute"));
            try {
                repository = SvnUtils.getRepositoryRootUrl(file);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
            SvnProgressSupport support = new SvnProgressSupport(){

                public void perform() {
                    BlameAction.this.computeAnnotations(file, this, ab);
                }
            };
            support.start(rp, repository, NbBundle.getMessage(BlameAction.class, (String)"MSG_Annotation_Progress"));
        }
    }

    private void computeAnnotations(File file, SvnProgressSupport progress, AnnotationBar ab) {
        ISVNLogMessage[] logs;
        ISVNAnnotations annotations;
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(file, progress);
        }
        catch (SVNClientException ex) {
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        try {
            annotations = client.annotate(file, (SVNRevision)new SVNRevision.Number(1L), SVNRevision.BASE);
        }
        catch (SVNClientException e) {
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            SvnClientExceptionHandler.notifyException((Exception)((Object)e), true, true);
            return;
        }
        if (progress.isCanceled()) {
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        AnnotateLine[] lines = BlameAction.toAnnotateLines(annotations);
        ab.annotationLines(file, Arrays.asList(lines));
        try {
            logs = client.getLogMessages(file, (SVNRevision)new SVNRevision.Number(1L), SVNRevision.BASE, false, false);
        }
        catch (SVNClientException e) {
            progress.annotate(e);
            return;
        }
        if (progress.isCanceled()) {
            return;
        }
        BlameAction.fillCommitMessages(lines, logs);
    }

    private static void fillCommitMessages(AnnotateLine[] annotations, ISVNLogMessage[] logs) {
        long lowestRevisionNumber = Long.MAX_VALUE;
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation = annotations[i];
            for (int j = 0; j < logs.length; ++j) {
                ISVNLogMessage log = logs[j];
                if (log.getRevision().getNumber() < lowestRevisionNumber) {
                    lowestRevisionNumber = log.getRevision().getNumber();
                }
                if (!annotation.getRevision().equals(log.getRevision().toString())) continue;
                annotation.setDate(log.getDate());
                annotation.setCommitMessage(log.getMessage());
            }
        }
        String lowestRev = Long.toString(lowestRevisionNumber);
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation;
            annotation.setCanBeRolledBack(!(annotation = annotations[i]).getRevision().equals(lowestRev));
        }
    }

    private static AnnotateLine[] toAnnotateLines(ISVNAnnotations annotations) {
        AnnotateLine[] lines = new AnnotateLine[annotations.numberOfLines()];
        int n = annotations.numberOfLines();
        for (int i = 0; i < n; ++i) {
            lines[i] = new AnnotateLine();
            lines[i].setAuthor(annotations.getAuthor(i));
            lines[i].setContent(annotations.getLine(i));
            lines[i].setLineNum(i + 1);
            lines[i].setRevision(Long.toString(annotations.getRevision(i)));
            lines[i].setDate(annotations.getChanged(i));
        }
        return lines;
    }

    public boolean visible(Node[] nodes) {
        JEditorPane currentPane = this.activatedEditorPane(nodes);
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodes) {
        JEditorPane[] panes;
        EditorCookie ec = this.activatedEditorCookie(nodes);
        if (ec != null && (panes = ec.getOpenedPanes()) != null && panes.length > 0) {
            return panes[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodes) {
        if (nodes == null) {
            nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodes.length == 1) {
            Node node = nodes[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodes) {
        Node node;
        DataObject dobj;
        if (nodes.length == 1 && (dobj = (DataObject)(node = nodes[0]).getCookie(DataObject.class)) != null) {
            FileObject fo = dobj.getPrimaryFile();
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }
}

