/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.BrowserPanel;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class Browser
implements VetoableChangeListener,
BrowserClient {
    public static final int BROWSER_SHOW_FILES = 1;
    public static final int BROWSER_SINGLE_SELECTION_ONLY = 2;
    public static final int BROWSER_FILES_SELECTION_ONLY = 4;
    public static final int BROWSER_FOLDERS_SELECTION_ONLY = 8;
    public static final int BROWSER_SELECT_ANYTHING = 12;
    private final int mode;
    private static final RepositoryFile[] EMPTY_ROOT = new RepositoryFile[0];
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private final BrowserPanel panel;
    private RepositoryFile repositoryRoot;
    private Action[] nodeActions;
    private SvnProgressSupport support;
    private boolean keepWarning = false;
    private boolean initialSelection = true;

    public Browser(String title, int mode, RepositoryFile repositoryRoot, RepositoryFile[] select, BrowserAction[] nodeActions) {
        this.mode = mode;
        this.panel = new BrowserPanel(title, NbBundle.getMessage(Browser.class, (String)"ACSN_RepositoryTree"), NbBundle.getMessage(Browser.class, (String)"ACSD_RepositoryTree"), (mode & 2) == 2);
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Browser_Prompt"));
        this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        if (nodeActions != null) {
            this.nodeActions = nodeActions;
            this.panel.setActions(nodeActions);
            for (int i = 0; i < nodeActions.length; ++i) {
                nodeActions[i].setBrowser(this);
            }
        } else {
            this.nodeActions = EMPTY_ACTIONS;
        }
        this.repositoryRoot = repositoryRoot;
        RepositoryPathNode rootNode = RepositoryPathNode.createRepositoryPathNode((BrowserClient)this, repositoryRoot);
        Node[] selectedNodes = this.getSelectedNodes(rootNode, repositoryRoot, select);
        this.getExplorerManager().setRootContext((Node)rootNode);
        if (selectedNodes == null) {
            selectedNodes = new Node[]{};
        }
        try {
            this.getExplorerManager().setSelectedNodes(selectedNodes);
            for (int i = 0; i < selectedNodes.length; ++i) {
                this.getExplorerManager().setExploredContext(selectedNodes[i]);
            }
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private Node[] getSelectedNodes(RepositoryPathNode rootNode, RepositoryFile repositoryRoot, RepositoryFile[] select) {
        if (select == null || select.length <= 0) {
            return null;
        }
        RepositoryPathNode segmentParentNode = null;
        ArrayList<RepositoryPathNode> nodesToSelect = new ArrayList<RepositoryPathNode>(select.length);
        for (int i = 0; i < select.length; ++i) {
            String[] segments = select[i].getPathSegments();
            segmentParentNode = rootNode;
            RepositoryFile segmentFile = repositoryRoot;
            for (int j = 0; j < segments.length; ++j) {
                segmentFile = segmentFile.appendPath(segments[j]);
                RepositoryPathNode segmentNode = RepositoryPathNode.createRepositoryPathNode((BrowserClient)this, segmentFile);
                segmentParentNode.getChildren().add(new Node[]{segmentNode});
                segmentParentNode = segmentNode;
            }
            nodesToSelect.add(segmentParentNode);
        }
        return nodesToSelect.toArray(new Node[nodesToSelect.size()]);
    }

    public void cancel() {
        Node rootNode = this.getExplorerManager().getRootContext();
        if (rootNode != null) {
            this.getExplorerManager().setRootContext(Node.EMPTY);
            try {
                rootNode.destroy();
                if (this.support != null) {
                    this.support.cancel();
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public List listRepositoryPath(RepositoryPathNode.RepositoryPathEntry entry, SvnProgressSupport support) throws SVNClientException {
        ArrayList<RepositoryPathNode.RepositoryPathEntry> ret;
        try {
            this.support = support;
            if (entry.getSvnNodeKind().equals((Object)SVNNodeKind.FILE)) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            SvnClient client = Subversion.getInstance().getClient(this.repositoryRoot.getRepositoryUrl(), support);
            if (support.isCanceled()) {
                List list = null;
                return list;
            }
            ret = new ArrayList<RepositoryPathNode.RepositoryPathEntry>();
            ISVNDirEntry[] dirEntries = client.getList(entry.getRepositoryFile().getFileUrl(), entry.getRepositoryFile().getRevision(), false);
            if (dirEntries == null || dirEntries.length == 0) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            for (int i = 0; i < dirEntries.length; ++i) {
                if (support.isCanceled()) {
                    List list = null;
                    return list;
                }
                ISVNDirEntry dirEntry = dirEntries[i];
                if (dirEntry.getNodeKind() != SVNNodeKind.DIR && (dirEntry.getNodeKind() != SVNNodeKind.FILE || (this.mode & 1) != 1)) continue;
                RepositoryFile repositoryFile = entry.getRepositoryFile();
                RepositoryPathNode.RepositoryPathEntry e = new RepositoryPathNode.RepositoryPathEntry(repositoryFile.appendPath(dirEntry.getPath()), dirEntry.getNodeKind(), (SVNRevision)dirEntry.getLastChangedRevision(), dirEntry.getLastChangedDate(), dirEntry.getLastCommitAuthor());
                ret.add(e);
            }
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isWrongURLInRevision(ex.getMessage())) {
                List list = null;
                return list;
            }
            support.annotate(ex);
            throw ex;
        }
        finally {
            this.support = null;
        }
        return ret;
    }

    public JPanel getBrowserPanel() {
        return this.panel;
    }

    public Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    public RepositoryFile[] getSelectedFiles() {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length == 0) {
            return EMPTY_ROOT;
        }
        RepositoryFile[] ret = new RepositoryFile[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ret[i] = ((RepositoryPathNode)nodes[i]).getEntry().getRepositoryFile();
        }
        return ret;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            boolean initialSelectionDone = !this.initialSelection;
            this.initialSelection = false;
            if (!this.keepWarning) {
                this.panel.warning(null);
            }
            this.keepWarning = false;
            Node[] newSelection = (Node[])evt.getNewValue();
            Node[] oldSelection = (Node[])evt.getOldValue();
            if (newSelection == null || newSelection.length == 0) {
                return;
            }
            if ((this.mode & 4) == 4 && this.checkForNodeType(newSelection, SVNNodeKind.DIR)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FileSelectionOnly"));
                if (initialSelectionDone) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", evt);
            }
            if ((this.mode & 8) == 8 && this.checkForNodeType(newSelection, SVNNodeKind.FILE)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FolderSelectionOnly"));
                if (initialSelectionDone) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", evt);
            }
            if (oldSelection.length == 0 && newSelection.length == 1) {
                return;
            }
            if (oldSelection.length != 0 && this.areDisjunct(oldSelection, newSelection)) {
                return;
            }
            Node selectedNode = null;
            selectedNode = oldSelection.length > 0 ? oldSelection[0] : newSelection[0];
            if (!this.selectionIsAtLevel(newSelection, this.getNodeLevel(selectedNode))) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_NoMultiSelection"));
                if (initialSelectionDone) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", evt);
            }
        }
    }

    private boolean checkForNodeType(Node[] newSelection, SVNNodeKind nodeKind) {
        for (int i = 0; i < newSelection.length; ++i) {
            RepositoryPathNode node;
            if (!(newSelection[i] instanceof RepositoryPathNode) || (node = (RepositoryPathNode)newSelection[i]).getEntry().getSvnNodeKind() != nodeKind) continue;
            return true;
        }
        return false;
    }

    private boolean selectionIsAtLevel(Node[] newSelection, int level) {
        for (int i = 0; i < newSelection.length; ++i) {
            if (this.getNodeLevel(newSelection[i]) == level) continue;
            return false;
        }
        return true;
    }

    private boolean areDisjunct(Node[] oldSelection, Node[] newSelection) {
        for (int i = 0; i < oldSelection.length; ++i) {
            if (!this.isInArray(oldSelection[i], newSelection)) continue;
            return false;
        }
        return true;
    }

    private int getNodeLevel(Node node) {
        int level = 0;
        while (node != null) {
            node = node.getParentNode();
            ++level;
        }
        return level;
    }

    private boolean isInArray(Node node, Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (node != nodeArray[i]) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getExplorerManager().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getExplorerManager().removePropertyChangeListener(listener);
    }

    ExplorerManager getExplorerManager() {
        return this.panel.getExplorerManager();
    }

    public Action[] getActions() {
        return this.nodeActions;
    }

    void setSelectedNodes(Node[] selection) throws PropertyVetoException {
        this.getExplorerManager().setSelectedNodes(selection);
    }
}

