/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.subversion.ui.browser.ControlPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class BrowserPanel
extends JPanel
implements ExplorerManager.Provider {
    private final BrowserTreeTableView treeView;
    private final ExplorerManager manager;
    private ControlPanel controlPanel;

    public BrowserPanel(String labelText, String browserAcsn, String browserAcsd, boolean singleSelection) {
        this.setName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_Prompt"));
        this.manager = new ExplorerManager();
        this.setLayout(new GridBagLayout());
        this.treeView = new BrowserTreeTableView();
        this.treeView.setDragSource(true);
        this.treeView.setDropTarget(true);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        this.treeView.getAccessibleContext().setAccessibleDescription(browserAcsd);
        this.treeView.getAccessibleContext().setAccessibleName(browserAcsn);
        if (singleSelection) {
            this.treeView.setSelectionMode(1);
        }
        this.treeView.setPopupAllowed(true);
        this.treeView.getTree().setShowsRootHandles(true);
        GridBagConstraints c = new GridBagConstraints();
        int gridY = 0;
        JLabel label = new JLabel();
        label.setLabelFor(this.treeView.getTree());
        label.setToolTipText(browserAcsd);
        if (labelText != null && !labelText.trim().equals("")) {
            Mnemonics.setLocalizedText((JLabel)label, (String)labelText);
        } else {
            Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BK2003"));
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = gridY++;
        c.insets = new Insets(4, 0, 4, 4);
        c.fill = 2;
        c.anchor = 17;
        this.add((Component)label, c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 1;
        this.add((Component)((Object)this.treeView), c);
        this.controlPanel = new ControlPanel();
        this.controlPanel.warningLabel.setVisible(false);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = gridY++;
        c.fill = 2;
        c.anchor = 13;
        this.add((Component)this.controlPanel, c);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.setPreferredSize(new Dimension(800, 400));
    }

    void warning(String warningText) {
        if (warningText != null) {
            this.controlPanel.warningLabel.setText(warningText);
            this.controlPanel.warningLabel.setVisible(true);
        } else {
            this.controlPanel.warningLabel.setText("");
            this.controlPanel.warningLabel.setVisible(false);
        }
    }

    public void setActions(AbstractAction[] actions) {
        if (actions != null) {
            this.controlPanel.buttonPanel.removeAll();
            for (int i = 0; i < actions.length; ++i) {
                JButton button = new JButton();
                button.setAction(actions[i]);
                button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowserPanel.class, (String)"CTL_Action_MakeDir"));
                Mnemonics.setLocalizedText((AbstractButton)button, (String)NbBundle.getMessage(BrowserPanel.class, (String)"CTL_Action_MakeDir"));
                this.controlPanel.buttonPanel.add(button);
            }
            this.revalidate();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private class BrowserTreeTableView
    extends TreeTableView {
        BrowserTreeTableView() {
            this.setupColumns();
        }

        public JTree getTree() {
            return this.tree;
        }

        public void startEditingAtPath(TreePath path) {
            this.tree.startEditingAtPath(path);
        }

        public void addNotify() {
            super.addNotify();
            this.setDefaultColumnSizes();
        }

        private void setupColumns() {
            ResourceBundle loc = NbBundle.getBundle(BrowserPanel.class);
            Node.Property[] columns = new Node.Property[]{new ColumnDescriptor<String>("revision", String.class, loc.getString("LBL_BrowserTree_Column_Revision"), loc.getString("LBL_BrowserTree_Column_Revision_Desc")), new ColumnDescriptor<String>("date", String.class, loc.getString("LBL_BrowserTree_Column_Date"), loc.getString("LBL_BrowserTree_Column_Date_Desc")), new ColumnDescriptor<String>("author", String.class, loc.getString("LBL_BrowserTree_Column_Author"), loc.getString("LBL_BrowserTree_Column_Author_Desc")), new ColumnDescriptor<String>("history", String.class, loc.getString("LBL_BrowserTree_Column_History"), loc.getString("LBL_BrowserTree_Column_History_Desc"))};
            this.setProperties(columns);
        }

        private void setDefaultColumnSizes() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int width = BrowserTreeTableView.this.getWidth();
                    BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(width * 50 / 100);
                    BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(width * 10 / 100);
                    BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(width * 20 / 100);
                    BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(width * 10 / 100);
                    BrowserTreeTableView.this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(width * 10 / 100);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

