/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.browser.WaitNode;
import org.netbeans.modules.subversion.ui.search.SvnSearch;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryPathNode
extends AbstractNode {
    private RepositoryPathEntry entry;
    private final BrowserClient client;
    private boolean repositoryFolder;
    static final String PROPERTY_NAME_REVISION = "revision";
    static final String PROPERTY_NAME_DATE = "date";
    static final String PROPERTY_NAME_AUTHOR = "author";
    static final String PROPERTY_NAME_HISTORY = "history";
    private static final String HISTORY_DISPLAY_NAME = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Name");
    private static final String HISTORY_SHORT_DESC = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Short_Desc");

    static RepositoryPathNode createRepositoryPathNode(BrowserClient client, RepositoryFile file) {
        return RepositoryPathNode.createRepositoryPathNode(client, new RepositoryPathEntry(file, SVNNodeKind.DIR, new SVNRevision(0), null, ""));
    }

    static RepositoryPathNode createRepositoryPathNode(BrowserClient client, RepositoryPathEntry entry) {
        RepositoryPathChildren kids = new RepositoryPathChildren(client, entry);
        RepositoryPathNode node = new RepositoryPathNode((Children)kids, client, entry, true);
        return node;
    }

    static RepositoryPathNode createBrowserPathNode(BrowserClient client, RepositoryPathEntry entry) {
        RepositoryPathNode node = new RepositoryPathNode((Children)new Children.Array(), client, entry, false);
        return node;
    }

    private RepositoryPathNode(Children children, BrowserClient client, RepositoryPathEntry entry, boolean repositoryFolder) {
        super(entry.getSvnNodeKind() == SVNNodeKind.DIR ? children : Children.LEAF);
        this.entry = entry;
        this.client = client;
        this.repositoryFolder = repositoryFolder;
        if (entry.getSvnNodeKind() == SVNNodeKind.DIR) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        } else {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFile.gif");
        }
        this.initProperties();
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new RevisionProperty());
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new AuthorProperty());
        ps.put((Node.Property)new HistoryProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        if (this.entry.getRepositoryFile().isRepositoryRoot()) {
            return this.entry.getRepositoryFile().getRepositoryUrl().toString();
        }
        return this.entry.getRepositoryFile().getName();
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (!oldName.equals(name)) {
            this.renameNode(this, name, 0);
            this.fireNameChange(oldName, name);
        }
    }

    private void renameNode(RepositoryPathNode node, String newParentsName, int level) {
        node.entry = new RepositoryPathEntry(node.entry.getRepositoryFile().replaceLastSegment(newParentsName, level), node.entry.getSvnNodeKind(), node.entry.getLastChangedRevision(), node.entry.getLastChangedDate(), node.entry.getLastChangedAuthor());
        Children childern = node.getChildren();
        Node[] childernNodes = childern.getNodes();
        ++level;
        for (int i = 0; i < childernNodes.length; ++i) {
            if (!(childernNodes[i] instanceof RepositoryPathNode)) continue;
            this.renameNode((RepositoryPathNode)childernNodes[i], newParentsName, level);
        }
    }

    public Action[] getActions(boolean context) {
        return this.client.getActions();
    }

    public RepositoryPathEntry getEntry() {
        return this.entry;
    }

    public BrowserClient getClient() {
        return this.client;
    }

    public boolean canRename() {
        return !this.repositoryFolder;
    }

    private void setRepositoryFolder(boolean bl) {
        this.repositoryFolder = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthorProperty
    extends NodeProperty<String> {
        public AuthorProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_AUTHOR, String.class, RepositoryPathNode.PROPERTY_NAME_AUTHOR, RepositoryPathNode.PROPERTY_NAME_AUTHOR);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedAuthor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateProperty
    extends NodeProperty<String> {
        public DateProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_DATE, String.class, RepositoryPathNode.PROPERTY_NAME_DATE, RepositoryPathNode.PROPERTY_NAME_DATE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            Date date = RepositoryPathNode.this.entry.getLastChangedDate();
            return date != null ? DateFormat.getDateTimeInstance().format(date) : "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryProperty
    extends PropertySupport.ReadOnly<String> {
        public HistoryProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_HISTORY, String.class, HISTORY_DISPLAY_NAME, HISTORY_SHORT_DESC);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return "";
        }

        public String toString() {
            try {
                String obj = this.getValue();
                return obj != null ? obj.toString() : "";
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            return new HistoryPropertyEditor();
        }
    }

    private class HistoryPropertyEditor
    extends PropertyEditorSupport {
        public HistoryPropertyEditor() {
            this.setValue("");
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            SVNRevision revision = RepositoryPathNode.this.entry.getLastChangedRevision();
            SVNUrl repositoryUrl = RepositoryPathNode.this.entry.getRepositoryFile().getRepositoryUrl();
            SVNUrl fileUrl = RepositoryPathNode.this.entry.getRepositoryFile().getFileUrl();
            SvnSearch svnSearch = new SvnSearch(new RepositoryFile(repositoryUrl, fileUrl, revision));
            return svnSearch.getSearchPanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected NodeProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                Object obj = this.getValue();
                return obj != null ? obj.toString() : "";
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public boolean canWrite() {
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport();
        }
    }

    private static class RepositoryPathChildren
    extends Children.Keys {
        private RequestProcessor.Task task;
        private final RepositoryPathEntry pathEntry;
        private final BrowserClient client;

        public RepositoryPathChildren(BrowserClient client, RepositoryPathEntry pathEntry) {
            this.client = client;
            this.pathEntry = pathEntry;
        }

        protected void addNotify() {
            super.addNotify();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2001"));
            this.setKeys(Collections.singleton(waitNode));
            this.listRepositoryPath();
        }

        protected void removeNotify() {
            this.task.cancel();
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node) {
                return new Node[]{(Node)key};
            }
            RepositoryPathEntry entry = (RepositoryPathEntry)key;
            Node node = this.findChild(entry.getRepositoryFile().getName());
            if (node != null) {
                return null;
            }
            RepositoryPathNode pathNode = RepositoryPathNode.createRepositoryPathNode(this.client, entry);
            return new Node[]{pathNode};
        }

        public void listRepositoryPath() {
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(this.pathEntry.getRepositoryFile().getRepositoryUrl());
            SvnProgressSupport support = new SvnProgressSupport(){

                public void perform() {
                    try {
                        List cl = RepositoryPathChildren.this.client.listRepositoryPath(RepositoryPathChildren.this.pathEntry, this);
                        if (cl == null) {
                            RepositoryPathChildren.this.setKeys(Collections.EMPTY_LIST);
                            RepositoryPathNode node = (RepositoryPathNode)RepositoryPathChildren.this.getNode();
                            node.setRepositoryFolder(false);
                        } else {
                            if (!RepositoryPathChildren.this.isCreativeBrowser(RepositoryPathChildren.this.client)) {
                                RepositoryPathChildren.this.removePreselectedFolders(cl);
                            }
                            RepositoryPathChildren.this.setKeys(cl);
                        }
                    }
                    catch (SVNClientException ex) {
                        RepositoryPathChildren.this.setKeys(Collections.singleton(RepositoryPathChildren.errorNode((Exception)((Object)ex))));
                        return;
                    }
                }
            };
            support.start(rp, this.pathEntry.getRepositoryFile().getRepositoryUrl(), NbBundle.getMessage(Browser.class, (String)"BK2001"));
        }

        private String getLastPathSegment(RepositoryPathEntry entry) {
            String[] childSegments = entry.getRepositoryFile().getPathSegments();
            return childSegments.length > 0 ? childSegments[childSegments.length - 1] : null;
        }

        private static Node errorNode(Exception ex) {
            AbstractNode errorNode = new AbstractNode(Children.LEAF);
            errorNode.setDisplayName(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2002"));
            errorNode.setShortDescription(ex.getLocalizedMessage());
            return errorNode;
        }

        private boolean isCreativeBrowser(BrowserClient client) {
            Action[] actions = client.getActions();
            for (int i = 0; i < actions.length; ++i) {
                if (!(actions[i] instanceof CreateFolderAction)) continue;
                return true;
            }
            return false;
        }

        private void removePreselectedFolders(Collection cl) {
            Node[] childNodes = this.getNodes();
            for (int i = 0; i < childNodes.length; ++i) {
                String lastChildSegment;
                if (!(childNodes[i] instanceof RepositoryPathNode) || (lastChildSegment = this.getLastPathSegment(((RepositoryPathNode)childNodes[i]).getEntry())) == null) continue;
                boolean pathExists = false;
                Iterator it = cl.iterator();
                while (it.hasNext()) {
                    String lastNewChildSegment = this.getLastPathSegment((RepositoryPathEntry)it.next());
                    if (lastNewChildSegment == null || !lastNewChildSegment.equals(lastChildSegment)) continue;
                    pathExists = true;
                    break;
                }
                if (pathExists) continue;
                this.remove(new Node[]{childNodes[i]});
            }
        }
    }

    static class RepositoryPathEntry {
        private final SVNNodeKind svnNodeKind;
        private final RepositoryFile file;
        private final SVNRevision revision;
        private Date date;
        private final String author;

        RepositoryPathEntry(RepositoryFile file, SVNNodeKind svnNodeKind, SVNRevision revision, Date date, String author) {
            this.svnNodeKind = svnNodeKind;
            this.file = file;
            this.revision = revision;
            this.date = date;
            this.author = author;
        }

        public SVNNodeKind getSvnNodeKind() {
            return this.svnNodeKind;
        }

        RepositoryFile getRepositoryFile() {
            return this.file;
        }

        SVNRevision getLastChangedRevision() {
            return this.revision;
        }

        Date getLastChangedDate() {
            return this.date;
        }

        String getLastChangedAuthor() {
            return this.author;
        }
    }

    private class RevisionProperty
    extends NodeProperty {
        public RevisionProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_REVISION, String.class, RepositoryPathNode.PROPERTY_NAME_REVISION, RepositoryPathNode.PROPERTY_NAME_REVISION);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedRevision();
        }
    }
}

