/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SelectPathAction
extends AbstractAction {
    private final SVNUrl selectionUrl;
    private Node[] selectionNodes;
    private final Browser browser;
    private static final Node[] EMPTY_NODES = new Node[0];

    public SelectPathAction(Browser browser, SVNUrl selection) {
        this.browser = browser;
        this.selectionUrl = selection;
        this.putValue("Name", NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Action_SelectPath"));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        Node[] nodes = this.getSelectionNodes();
        if (nodes == null || nodes == EMPTY_NODES) {
            return;
        }
        try {
            this.browser.getExplorerManager().setSelectedNodes(nodes);
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private Node[] getSelectionNodes() {
        if (this.selectionNodes == null) {
            Children children;
            String[] segments = this.selectionUrl.getPathSegments();
            RepositoryPathNode node = (RepositoryPathNode)this.browser.getExplorerManager().getRootContext();
            for (int i = 0; i < segments.length && (node = (children = node.getChildren()).findChild(segments[i])) != null; ++i) {
            }
            this.selectionNodes = node == null ? EMPTY_NODES : new Node[]{node};
        }
        return this.selectionNodes;
    }
}

