/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.checkout.CheckoutCompletedPanel;
import org.netbeans.modules.subversion.ui.checkout.ProjectUtilities;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CheckoutCompleted
implements ActionListener {
    private final File workingFolder;
    private final boolean openProject;
    private String[] checkedOutFolders;
    private CheckoutCompletedPanel panel;
    private Dialog dialog;
    private Project projectToBeOpened;

    public CheckoutCompleted(File workingFolder, String[] checkedOutFolders, boolean openProject) {
        this.openProject = openProject;
        this.checkedOutFolders = checkedOutFolders;
        this.workingFolder = workingFolder;
    }

    public void scanForProjects(SvnProgressSupport support) {
        List<Object> checkedOutProjects = new LinkedList();
        File normalizedWorkingFolder = FileUtil.normalizeFile((File)this.workingFolder);
        SvnUtils.refreshRecursively(normalizedWorkingFolder);
        FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
        if (fo != null) {
            for (int i = 0; i < this.checkedOutFolders.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                String module = this.checkedOutFolders[i];
                if (".".equals(module)) {
                    checkedOutProjects = ProjectUtilities.scanForProjects(fo);
                    break;
                }
                FileObject subfolder = fo.getFileObject(module);
                if (subfolder == null) continue;
                checkedOutProjects.addAll(ProjectUtilities.scanForProjects(subfolder));
            }
        }
        this.panel = new CheckoutCompletedPanel();
        this.panel.openButton.addActionListener(this);
        this.panel.createButton.addActionListener(this);
        this.panel.closeButton.addActionListener(this);
        this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panel.againCheckBox.setVisible(!this.openProject);
        String title = NbBundle.getMessage(CheckoutAction.class, (String)"BK3008");
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.panel, title);
        descriptor.setModal(true);
        this.panel.remove(this.panel.openButton);
        this.panel.remove(this.panel.createButton);
        this.panel.remove(this.panel.closeButton);
        Object[] options = null;
        if (checkedOutProjects.size() > 1) {
            String msg = NbBundle.getMessage(CheckoutAction.class, (String)"BK3009", (Object)new Integer(checkedOutProjects.size()));
            this.panel.jLabel1.setText(msg);
            options = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else if (checkedOutProjects.size() == 1) {
            Project project;
            this.projectToBeOpened = project = (Project)checkedOutProjects.iterator().next();
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            String projectName = projectInformation.getDisplayName();
            String msg = NbBundle.getMessage(CheckoutAction.class, (String)"BK3011", (Object)projectName);
            this.panel.jLabel1.setText(msg);
            this.panel.openButton.setText(NbBundle.getMessage(CheckoutAction.class, (String)"BK3012"));
            options = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else {
            String msg = NbBundle.getMessage(CheckoutAction.class, (String)"BK3010");
            this.panel.jLabel1.setText(msg);
            options = new Object[]{this.panel.createButton, this.panel.closeButton};
        }
        descriptor.setMessageType(1);
        descriptor.setOptions(options);
        descriptor.setClosingOptions(options);
        descriptor.setHelpCtx(new HelpCtx(CheckoutCompletedPanel.class));
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CheckoutAction.class, (String)"ACSD_CheckoutCompleted_Dialog"));
        if (support != null && support.isCanceled()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CheckoutCompleted.this.dialog.setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        this.dialog.setVisible(false);
        if (this.panel.openButton.equals(src)) {
            if (this.projectToBeOpened == null) {
                Action a = CheckoutCompleted.findAction("Actions/Project/org-netbeans-modules-project-ui-OpenProject.instance");
                if (null != a) {
                    a.actionPerformed(e);
                }
            } else {
                if (this.projectToBeOpened == null) {
                    return;
                }
                this.openProject(this.projectToBeOpened);
            }
        } else if (this.panel.createButton.equals(src)) {
            ProjectUtilities.newProjectWizard(this.workingFolder);
        }
    }

    public static Action findAction(String key) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(key);
        if (fo != null && fo.isValid()) {
            try {
                Object instance;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof Action) {
                    Action a = (Action)instance;
                    return a;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void openProject(Project p) {
        Project[] projects = new Project[]{p};
        OpenProjects.getDefault().open(projects, false);
        ContextAwareAction action = (ContextAwareAction)CommonProjectActions.setAsMainProjectAction();
        Lookup ctx = Lookups.singleton((Object)p);
        Action ctxAction = action.createContextAwareInstance(ctx);
        ctxAction.actionPerformed(new ActionEvent(this, 0, ""));
        ProjectUtilities.selectAndExpandProject(p);
    }
}

