/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitPanel;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Commit";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = cache.listFiles(this.getContext(nodes), 6612);
        return files.length > 0;
    }

    public static void commit(String contentTitle, final Context ctx) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] roots = ctx.getFiles();
        if (roots.length == 0) {
            return;
        }
        File[][] split = Utils.splitFlatOthers((File[])roots);
        ArrayList<File> fileList = new ArrayList<File>();
        for (int c = 0; c < split.length; ++c) {
            int i;
            File[] files;
            boolean recursive;
            roots = split[c];
            boolean bl = recursive = c == 1;
            if (recursive) {
                files = cache.listFiles(ctx, 6612);
                for (i = 0; i < files.length; ++i) {
                    for (int r = 0; r < roots.length; ++r) {
                        if (!SvnUtils.isParentOrEqual(roots[r], files[i]) || fileList.contains(files[i])) continue;
                        fileList.add(files[i]);
                    }
                }
                continue;
            }
            files = SvnUtils.flatten(roots, 6612);
            for (i = 0; i < files.length; ++i) {
                if (fileList.contains(files[i])) continue;
                fileList.add(files[i]);
            }
        }
        if (fileList.size() == 0) {
            return;
        }
        final CommitPanel panel = new CommitPanel();
        final CommitTable data = new CommitTable(panel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        panel.setCommitTable(data);
        ArrayList<SvnFileNode> nodesList = new ArrayList<SvnFileNode>(fileList.size());
        for (File file : fileList) {
            SvnFileNode node = new SvnFileNode(file);
            nodesList.add(node);
        }
        SvnFileNode[] nodes = nodesList.toArray(new SvnFileNode[fileList.size()]);
        data.setNodes(nodes);
        JComponent component = data.getComponent();
        panel.filesPanel.setLayout(new BorderLayout());
        panel.filesPanel.add((Component)component, "Center");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)contentTitle));
        dd.setModal(true);
        final JButton commitButton = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        commitButton.setEnabled(false);
        dd.setOptions(new Object[]{commitButton, NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel")});
        dd.setHelpCtx(new HelpCtx(CommitAction.class));
        panel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                CommitAction.refreshCommitDialog(panel, data, commitButton);
            }
        });
        data.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                CommitAction.refreshCommitDialog(panel, data, commitButton);
            }
        });
        commitButton.setEnabled(CommitAction.containsCommitable(data));
        panel.putClientProperty("contentTitle", contentTitle);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(SvnModuleConfig.getDefault().getPreferences(), "svn.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        if (dd.getValue() == commitButton) {
            final Map<SvnFileNode, CommitOptions> commitFiles = data.getCommitFiles();
            final String message = panel.messageTextArea.getText();
            Utils.insert((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)message, (int)20);
            SVNUrl repository = null;
            try {
                repository = CommitAction.getSvnUrl(ctx);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            }
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
            SvnProgressSupport support = new SvnProgressSupport(){

                public void perform() {
                    CommitAction.performCommit(message, commitFiles, ctx, this);
                }
            };
            support.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    private static boolean containsCommitable(CommitTable data) {
        Map<SvnFileNode, CommitOptions> map = data.getCommitFiles();
        for (CommitOptions co : map.values()) {
            if (co == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel panel, CommitTable table, JButton commit) {
        String errorLabel;
        String msg;
        ResourceBundle loc = NbBundle.getBundle(CommitAction.class);
        Map<SvnFileNode, CommitOptions> files = table.getCommitFiles();
        HashSet<String> stickyTags = new HashSet<String>();
        boolean conflicts = false;
        boolean enabled = commit.isEnabled();
        for (SvnFileNode fileNode : files.keySet()) {
            CommitOptions options = files.get(fileNode);
            if (options == CommitOptions.EXCLUDE) continue;
            stickyTags.add(SvnUtils.getCopy(fileNode.getFile()));
            int status = fileNode.getInformation().getStatus();
            if ((status & 0x6A0) == 0 && status != 64) continue;
            enabled = false;
            msg = status == 64 ? loc.getString("MSG_CommitForm_ErrorConflicts") : loc.getString("MSG_CommitForm_ErrorRemoteChanges");
            panel.setErrorLabel("<html><font color=\"#002080\">" + msg + "</font></html>");
            conflicts = true;
        }
        if (stickyTags.size() > 1) {
            table.setColumns(new String[]{"name", "branch", "status", "action", "path"});
        } else {
            table.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String contentTitle = (String)panel.getClientProperty("contentTitle");
        DialogDescriptor dd = (DialogDescriptor)panel.getClientProperty("DialogDescriptor");
        if (stickyTags.size() <= 1) {
            String stickyTag;
            String string = stickyTag = stickyTags.size() == 0 ? null : (String)stickyTags.iterator().next();
            if (stickyTag == null) {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title"), contentTitle));
                errorLabel = "";
            } else {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branch"), contentTitle, stickyTag));
                msg = MessageFormat.format(loc.getString("MSG_CommitForm_InfoBranch"), stickyTag);
                errorLabel = "<html><font color=\"#002080\">" + msg + "</font></html>";
            }
        } else {
            dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branches"), contentTitle));
            String msg2 = loc.getString("MSG_CommitForm_ErrorMultipleBranches");
            errorLabel = "<html><font color=\"#CC0000\">" + msg2 + "</font></html>";
        }
        if (!conflicts) {
            panel.setErrorLabel(errorLabel);
            enabled = true;
        }
        commit.setEnabled(enabled && CommitAction.containsCommitable(table));
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        CommitAction.commit(this.getContextDisplayName(nodes), ctx);
    }

    public static void performCommit(String message, Map<SvnFileNode, CommitOptions> commitFiles, Context ctx, SvnProgressSupport support) {
        CommitAction.performCommit(message, commitFiles, ctx, support, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void performCommit(String message, Map<SvnFileNode, CommitOptions> commitFiles, Context ctx, SvnProgressSupport support, boolean rootUpdate) {
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(ctx, support);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            support.setDisplayName(NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
            ArrayList<SvnFileNode> addCandidates = new ArrayList<SvnFileNode>();
            ArrayList<SvnFileNode> removeCandidates = new ArrayList<SvnFileNode>();
            LinkedHashSet<File> commitCandidates = new LinkedHashSet<File>();
            HashSet<File> binnaryCandidates = new HashSet<File>();
            Iterator<SvnFileNode> it = commitFiles.keySet().iterator();
            while (it.hasNext()) {
                File file;
                Iterator<File> dit;
                List<File> l;
                if (support.isCanceled()) {
                    return;
                }
                SvnFileNode node = it.next();
                CommitOptions option = commitFiles.get(node);
                if (CommitOptions.ADD_BINARY == option) {
                    l = CommitAction.listUnmanagedParents(node);
                    dit = l.iterator();
                    while (dit.hasNext()) {
                        if (support.isCanceled()) {
                            return;
                        }
                        file = dit.next();
                        addCandidates.add(new SvnFileNode(file));
                        commitCandidates.add(file);
                    }
                    if (support.isCanceled()) {
                        return;
                    }
                    binnaryCandidates.add(node.getFile());
                    addCandidates.add(node);
                    commitCandidates.add(node.getFile());
                    continue;
                }
                if (CommitOptions.ADD_TEXT == option || CommitOptions.ADD_DIRECTORY == option) {
                    l = CommitAction.listUnmanagedParents(node);
                    dit = l.iterator();
                    while (dit.hasNext()) {
                        if (support.isCanceled()) {
                            return;
                        }
                        file = dit.next();
                        addCandidates.add(new SvnFileNode(file));
                        commitCandidates.add(file);
                    }
                    if (support.isCanceled()) {
                        return;
                    }
                    addCandidates.add(node);
                    commitCandidates.add(node.getFile());
                    continue;
                }
                if (CommitOptions.COMMIT_REMOVE == option) {
                    removeCandidates.add(node);
                    commitCandidates.add(node.getFile());
                    continue;
                }
                if (CommitOptions.COMMIT != option) continue;
                commitCandidates.add(node.getFile());
            }
            ArrayList<File> addFiles = new ArrayList<File>();
            ArrayList<File> addDirs = new ArrayList<File>();
            it = addCandidates.iterator();
            while (it.hasNext()) {
                if (support.isCanceled()) {
                    return;
                }
                SvnFileNode svnFileNode = it.next();
                File file = svnFileNode.getFile();
                if (file.isDirectory()) {
                    addDirs.add(file);
                    continue;
                }
                if (!file.isFile()) continue;
                addFiles.add(file);
            }
            if (support.isCanceled()) {
                return;
            }
            Iterator itFiles = addDirs.iterator();
            ArrayList<File> dirsToAdd = new ArrayList<File>();
            while (itFiles.hasNext()) {
                File dir = (File)itFiles.next();
                if (dirsToAdd.contains(dir)) continue;
                dirsToAdd.add(dir);
            }
            if (dirsToAdd.size() > 0) {
                client.addFile(dirsToAdd.toArray(new File[dirsToAdd.size()]), false);
            }
            if (support.isCanceled()) {
                return;
            }
            if (addFiles.size() > 0) {
                client.addFile(addFiles.toArray(new File[addFiles.size()]), false);
            }
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            ArrayList managedTrees = new ArrayList();
            for (File file : commitCandidates) {
                if (binnaryCandidates.contains(file)) {
                    ISVNProperty prop = client.propertyGet(file, "svn:mime-type");
                    if (prop != null) {
                        String s = prop.getValue();
                        if (s == null || s.startsWith("text/")) {
                            client.propertySet(file, "svn:mime-type", "application/octet-stream", false);
                        }
                    } else {
                        client.propertySet(file, "svn:mime-type", "application/octet-stream", false);
                    }
                }
                List<File> managedTreesList = null;
                for (List list : managedTrees) {
                    FileInformation status;
                    File managedTreeFile = (File)list.get(0);
                    File base = SVNBaseDir.getRootDir((File[])new File[]{file, managedTreeFile});
                    if (base == null || ((status = cache.getStatus(base)).getStatus() & 0xFFFFFFFE) == 0) continue;
                    managedTreesList = list;
                    break;
                }
                if (managedTreesList == null) {
                    managedTreesList = new ArrayList<File>();
                    managedTrees.add(managedTreesList);
                }
                managedTreesList.add(file);
            }
            for (List list : managedTrees) {
                File[] files = list.toArray(new File[list.size()]);
                client.commit(files, message, false);
                if (rootUpdate) {
                    void var21_31;
                    int n;
                    File[] rootFiles = ctx.getRootFiles();
                    boolean bl = false;
                    while (n < rootFiles.length) {
                        client.update(rootFiles[n], SVNRevision.HEAD, false);
                        ++n;
                    }
                    n = 0;
                    while (var21_31 < rootFiles.length) {
                        cache.refresh(rootFiles[var21_31], FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                        ++var21_31;
                    }
                }
                for (int i = 0; i < files.length; ++i) {
                    cache.refresh(files[i], FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
                if (!support.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }

    private static List<File> listUnmanagedParents(SvnFileNode node) {
        ArrayList<File> unmanaged = new ArrayList<File>();
        File file = node.getFile();
        File parent = file.getParentFile();
        while (!new File(parent, ".svn/entries").canRead() && !new File(parent, "_svn/entries").canRead()) {
            unmanaged.add(0, parent);
            if ((parent = parent.getParentFile()) != null) continue;
        }
        ArrayList<File> ret = new ArrayList<File>();
        for (File un : unmanaged) {
            ret.add(un);
        }
        return ret;
    }
}

