/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ConflictResolvedAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "resolve";
    }

    protected int getFileEnabledStatus() {
        return 64;
    }

    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    protected void performContextAction(Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        final File[] files = ctx.getFiles();
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

            public void perform() {
                SvnClient client = null;
                try {
                    client = Subversion.getInstance().getClient(ctx, (SvnProgressSupport)this);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
                if (client == null) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (this.isCanceled()) {
                        return;
                    }
                    File file = files[i];
                    try {
                        ConflictResolvedAction.perform(file, client);
                        continue;
                    }
                    catch (SVNClientException ex) {
                        this.annotate(ex);
                    }
                }
            }
        };
        support.start(this.createRequestProcessor(nodes));
    }

    public static void perform(File file) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(file);
        ConflictResolvedAction.perform(file, client);
    }

    private static void perform(File file, SvnClient client) throws SVNClientException {
        FileObject folder;
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        client.resolved(file);
        cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        File parent = file.getParentFile();
        if (parent != null && (folder = FileUtil.toFileObject((File)parent)) != null) {
            folder.refresh();
        }
    }
}

