/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.Dialog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CopyDialog {
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panel;
    private Map<String, JComboBox> urlComboBoxes;

    public CopyDialog(JPanel panel, String title, String okLabel) {
        this.panel = panel;
        this.dialogDescriptor = new DialogDescriptor((Object)panel, title);
        this.okButton = new JButton(okLabel);
        this.okButton.getAccessibleContext().setAccessibleDescription(okLabel);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Copy_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Copy_Cancel"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        this.dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Title"));
    }

    protected void resetUrlComboBoxes() {
        this.getUrlComboBoxes().clear();
    }

    protected void setupUrlComboBox(JComboBox cbo, String key) {
        if (cbo == null) {
            return;
        }
        List recentFolders = Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)key);
        DefaultComboBoxModel rootsModel = new DefaultComboBoxModel(new Vector(recentFolders));
        cbo.setModel(rootsModel);
        this.getUrlComboBoxes().put(key, cbo);
    }

    private Map<String, JComboBox> getUrlComboBoxes() {
        if (this.urlComboBoxes == null) {
            this.urlComboBoxes = new HashMap<String, JComboBox>();
        }
        return this.urlComboBoxes;
    }

    protected JPanel getPanel() {
        return this.panel;
    }

    public boolean showDialog() {
        boolean ret;
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.setVisible(true);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Title"));
        boolean bl = ret = this.dialogDescriptor.getValue() == this.okButton;
        if (ret) {
            this.storeValidValues();
        }
        return ret;
    }

    private void storeValidValues() {
        for (String key : this.urlComboBoxes.keySet()) {
            JComboBox cbo = this.urlComboBoxes.get(key);
            Object item = cbo.getEditor().getItem();
            if (item == null || item.equals("")) continue;
            Utils.insert((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)key, (String)((String)item), (int)8);
        }
    }

    protected JButton getOKButton() {
        return this.okButton;
    }
}

