/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.MergeOneFolderPanel;
import org.netbeans.modules.subversion.ui.copy.MergePanel;
import org.netbeans.modules.subversion.ui.copy.MergeSinceOriginPanel;
import org.netbeans.modules.subversion.ui.copy.MergeTwoFoldersPanel;
import org.netbeans.modules.subversion.ui.copy.OneFolderPreviewPanel;
import org.netbeans.modules.subversion.ui.copy.SinceOriginPreviewPanel;
import org.netbeans.modules.subversion.ui.copy.TwoFoldersPreviewPanel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Merge
extends CopyDialog
implements ItemListener {
    private String MERGE_START_URL_HISTORY_KEY = Merge.class.getName() + "_merge_from";
    private String MERGE_END_URL_HISTORY_KEY = Merge.class.getName() + "_merge_after";

    public Merge(RepositoryFile repositoryRoot, File root) {
        super(new MergePanel(), NbBundle.getMessage(Merge.class, (String)"CTL_Merge_Prompt", (Object)root.getName()), NbBundle.getMessage(Merge.class, (String)"CTL_Merge_Title"));
        MergePanel panel = this.getMergePanel();
        panel.typeComboBox.setModel(new DefaultComboBoxModel<MergeType>(new MergeType[]{new MergeOneFolderType(repositoryRoot, root), new MergeTwoFoldersType(repositoryRoot, root), new MergeSinceOriginType(repositoryRoot, root)}));
        panel.typeComboBox.setRenderer(this.createTypeRenderer());
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Merge.class, (String)"CTL_Merge_Title"));
        panel.typeComboBox.addItemListener(this);
        this.mergeTypeSelected((MergeType)panel.typeComboBox.getSelectedItem());
    }

    SVNUrl getMergeStartUrl() {
        return this.getSelectedType().getMergeStartUrl();
    }

    SVNUrl getMergeEndUrl() {
        return this.getSelectedType().getMergeEndUrl();
    }

    SVNRevision getMergeStartRevision() {
        return this.getSelectedType().getMergeStartRevision();
    }

    SVNRevision getMergeEndRevision() {
        return this.getSelectedType().getMergeEndRevision();
    }

    private MergeType getSelectedType() {
        return (MergeType)this.getMergePanel().typeComboBox.getSelectedItem();
    }

    private MergePanel getMergePanel() {
        return (MergePanel)this.getPanel();
    }

    private ListCellRenderer createTypeRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof MergeType) {
                    this.setText(((MergeType)value).getDisplayName());
                }
                return this;
            }
        };
    }

    public void itemStateChanged(ItemEvent e) {
        MergeType type = (MergeType)e.getItem();
        this.mergeTypeSelected(type);
    }

    private void mergeTypeSelected(MergeType type) {
        MergePanel panel = this.getMergePanel();
        panel.typeDescriptionLabel.setText(type.getDescription());
        panel.previewPanel.removeAll();
        panel.previewPanel.setLayout(new BorderLayout());
        panel.previewPanel.add((Component)type.getPreviewPanel(), "Center");
        panel.mergeFieldsPanel.removeAll();
        panel.mergeFieldsPanel.setLayout(new BorderLayout());
        panel.mergeFieldsPanel.add((Component)type.getFieldsPanel(), "Center");
        type.setPreviewLabels();
        panel.repaint();
        this.resetUrlComboBoxes();
        this.setupUrlComboBox(type.getStartUrlComboBox(), this.MERGE_START_URL_HISTORY_KEY);
        this.setupUrlComboBox(type.getEndUrlComboBox(), this.MERGE_END_URL_HISTORY_KEY);
    }

    private class MergeOneFolderType
    extends MergeType {
        private RepositoryPaths mergeEndRepositoryPaths;
        private MergeOneFolderPanel panel;
        private OneFolderPreviewPanel previewPanel;

        public MergeOneFolderType(RepositoryFile repositoryRoot, File root) {
            super(repositoryRoot);
            this.panel = new MergeOneFolderPanel();
            this.previewPanel = new OneFolderPreviewPanel();
            RepositoryPaths mergeStartRepositoryPaths = new RepositoryPaths(repositoryRoot, null, null, this.panel.mergeStartRevisionTextField, this.panel.mergeStartSearchButton);
            this.mergeEndRepositoryPaths = new RepositoryPaths(repositoryRoot, (JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeStartBrowseButton, this.panel.mergeEndRevisionTextField, this.panel.mergeEndSearchButton);
            this.init(mergeStartRepositoryPaths, this.panel.mergeStartRepositoryFolderLabel, this.mergeEndRepositoryPaths, null, root);
            this.previewPanel.localFolderTextField.setText(root.getAbsolutePath());
            ((JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }

        public SVNUrl getMergeStartUrl() {
            return this.getMergeEndUrl();
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolder");
        }

        public String getDescription() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolderDesc");
        }

        public JPanel getFieldsPanel() {
            return this.panel;
        }

        public JPanel getPreviewPanel() {
            return this.previewPanel;
        }

        public JComboBox getStartUrlComboBox() {
            return this.panel.mergeStartUrlComboBox;
        }

        public JComboBox getEndUrlComboBox() {
            return null;
        }

        protected void setPreviewLabels() {
            this.previewPanel.repositoryFolderTextField.setText(this.getRepositoryFile().getRepositoryUrl() + NbBundle.getMessage(Merge.class, (String)"/") + this.panel.mergeStartUrlComboBox.getEditor().getItem().toString());
        }
    }

    private class MergeSinceOriginType
    extends MergeType {
        private MergeSinceOriginPanel panel;
        private RepositoryPaths mergeEndRepositoryPaths;
        private SinceOriginPreviewPanel previewPanel;

        public MergeSinceOriginType(RepositoryFile repositoryRoot, File root) {
            super(repositoryRoot);
            this.panel = new MergeSinceOriginPanel();
            this.previewPanel = new SinceOriginPreviewPanel();
            this.mergeEndRepositoryPaths = new RepositoryPaths(repositoryRoot, (JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeEndBrowseButton, this.panel.mergeEndRevisionTextField, this.panel.mergeEndSearchButton);
            this.init(null, null, this.mergeEndRepositoryPaths, this.panel.mergeEndRepositoryFolderLabel, root);
            this.previewPanel.localFolderTextField.setText(root.getAbsolutePath());
            ((JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolderSinceOrigin");
        }

        public String getDescription() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolderSinceOriginDesc");
        }

        public JPanel getFieldsPanel() {
            return this.panel;
        }

        public JPanel getPreviewPanel() {
            return this.previewPanel;
        }

        public SVNUrl getMergeStartUrl() {
            return null;
        }

        public SVNRevision getMergeStartRevision() {
            return null;
        }

        public SVNUrl getMergeEndUrl() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getFileUrl();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        public SVNRevision getMergeEndRevision() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        RepositoryPaths getMergeStartRepositoryPath() {
            return null;
        }

        RepositoryPaths getMergeEndRepositoryPath() {
            return this.mergeEndRepositoryPaths;
        }

        public JComboBox getStartUrlComboBox() {
            return null;
        }

        public JComboBox getEndUrlComboBox() {
            return this.panel.mergeEndUrlComboBox;
        }

        protected void setPreviewLabels() {
            this.previewPanel.repositoryFolderTextField.setText(this.getRepositoryFile().getRepositoryUrl() + "/" + this.panel.mergeEndUrlComboBox.getEditor().getItem().toString());
        }
    }

    private class MergeTwoFoldersType
    extends MergeType {
        private MergeTwoFoldersPanel panel;
        private TwoFoldersPreviewPanel previewPanel;

        public MergeTwoFoldersType(RepositoryFile repositoryRoot, File root) {
            super(repositoryRoot);
            this.panel = new MergeTwoFoldersPanel();
            this.previewPanel = new TwoFoldersPreviewPanel();
            RepositoryPaths mergeStartRepositoryPaths = new RepositoryPaths(repositoryRoot, (JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeStartBrowseButton, this.panel.mergeStartRevisionTextField, this.panel.mergeStartSearchButton);
            RepositoryPaths mergeEndRepositoryPaths = new RepositoryPaths(repositoryRoot, (JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeEndBrowseButton, this.panel.mergeEndRevisionTextField, this.panel.mergeEndSearchButton);
            this.init(mergeStartRepositoryPaths, this.panel.mergeStartRepositoryFolderLabel, mergeEndRepositoryPaths, this.panel.mergeEndRepositoryFolderLabel, root);
            this.previewPanel.localFolderTextField.setText(root.getAbsolutePath());
            ((JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            ((JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_TwoRepositoryFolders");
        }

        public String getDescription() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_TwoFoldersDesc");
        }

        public JPanel getFieldsPanel() {
            return this.panel;
        }

        public JPanel getPreviewPanel() {
            return this.previewPanel;
        }

        public JComboBox getStartUrlComboBox() {
            return this.panel.mergeStartUrlComboBox;
        }

        public JComboBox getEndUrlComboBox() {
            return this.panel.mergeEndUrlComboBox;
        }

        protected void setPreviewLabels() {
            this.previewPanel.repositoryFolderTextField1.setText(this.getRepositoryFile().getRepositoryUrl() + "/" + this.panel.mergeStartUrlComboBox.getEditor().getItem().toString());
            this.previewPanel.repositoryFolderTextField2.setText(this.getRepositoryFile().getRepositoryUrl() + "/" + this.panel.mergeEndUrlComboBox.getEditor().getItem().toString());
        }
    }

    private abstract class MergeType
    implements DocumentListener,
    PropertyChangeListener {
        private RepositoryPaths mergeStartRepositoryPaths;
        private RepositoryPaths mergeEndRepositoryPaths;
        private RepositoryFile repositoryFile;
        private boolean startPathValid = false;
        private boolean endPathValid = false;

        MergeType(RepositoryFile repositoryFile) {
            this.repositoryFile = repositoryFile;
        }

        protected void init(RepositoryPaths mergeStartRepositoryPaths, JLabel mergeStartRepositoryFolderLabel, RepositoryPaths mergeEndRepositoryPaths, JLabel mergeEndRepositoryFolderLabel, File root) {
            if (mergeStartRepositoryPaths != null) {
                this.mergeStartRepositoryPaths = mergeStartRepositoryPaths;
                this.init(mergeStartRepositoryPaths, mergeStartRepositoryFolderLabel, root);
            } else {
                this.startPathValid = true;
            }
            if (mergeEndRepositoryPaths != null) {
                this.mergeEndRepositoryPaths = mergeEndRepositoryPaths;
                this.init(mergeEndRepositoryPaths, mergeEndRepositoryFolderLabel, root);
            } else {
                this.endPathValid = true;
            }
        }

        private void init(RepositoryPaths paths, JLabel label, File root) {
            int browserMode;
            String browserPurposeMessage;
            if (root.isFile()) {
                if (label != null) {
                    label.setText(NbBundle.getMessage(Merge.class, (String)"CTL_Merge_RepositoryFile"));
                }
                browserPurposeMessage = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageMergeFile");
                browserMode = 7;
            } else {
                browserPurposeMessage = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageMergeFolder");
                browserMode = 2;
            }
            paths.setupBrowserBehavior(browserPurposeMessage, browserMode);
            paths.addPropertyChangeListener(this);
        }

        protected abstract JPanel getFieldsPanel();

        protected abstract JPanel getPreviewPanel();

        protected abstract String getDisplayName();

        protected abstract String getDescription();

        protected abstract JComboBox getStartUrlComboBox();

        protected abstract JComboBox getEndUrlComboBox();

        protected abstract void setPreviewLabels();

        public SVNUrl getMergeStartUrl() {
            try {
                return this.mergeStartRepositoryPaths.getRepositoryFiles()[0].getFileUrl();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        public SVNUrl getMergeEndUrl() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getFileUrl();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        public SVNRevision getMergeStartRevision() {
            try {
                return this.mergeStartRepositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        public SVNRevision getMergeEndRevision() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }

        RepositoryPaths getMergeStartRepositoryPath() {
            return this.mergeStartRepositoryPaths;
        }

        RepositoryPaths getMergeEndRepositoryPath() {
            return this.mergeEndRepositoryPaths;
        }

        public void insertUpdate(DocumentEvent e) {
            this.setPreviewLabels();
        }

        public void removeUpdate(DocumentEvent e) {
            this.setPreviewLabels();
        }

        public void changedUpdate(DocumentEvent e) {
            this.setPreviewLabels();
        }

        protected RepositoryFile getRepositoryFile() {
            return this.repositoryFile;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("valid")) {
                boolean valid = (Boolean)evt.getNewValue();
                if (evt.getSource() == this.getMergeStartRepositoryPath()) {
                    this.startPathValid = valid;
                } else if (evt.getSource() == this.getMergeEndRepositoryPath()) {
                    this.endPathValid = valid;
                }
                Merge.this.getOKButton().setEnabled(this.startPathValid && this.endPathValid);
            }
        }
    }
}

