/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.Merge;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Merge";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        final File root = ctx.getRootFiles()[0];
        try {
            url = SvnUtils.getRepositoryRootUrl(root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        final RepositoryFile repositoryRoot = new RepositoryFile(url, url, SVNRevision.HEAD);
        final Merge merge = new Merge(repositoryRoot, root);
        if (merge.showDialog()) {
            ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

                public void perform() {
                    MergeAction.this.performMerge(merge, repositoryRoot, root, this);
                }
            };
            support.start(this.createRequestProcessor(nodes));
        }
    }

    private void performMerge(Merge merge, RepositoryFile repositoryRoot, File root, SvnProgressSupport support) {
        File[][] split = Utils.splitFlatOthers((File[])new File[]{root});
        boolean recursive = split[0].length <= 0;
        try {
            SVNRevision startRevision;
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(repositoryRoot.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            if (support.isCanceled()) {
                return;
            }
            SVNUrl endUrl = merge.getMergeEndUrl();
            SVNRevision endRevision = merge.getMergeEndRevision();
            SVNUrl startUrl = merge.getMergeStartUrl();
            if (startUrl != null) {
                startRevision = merge.getMergeStartRevision();
            } else {
                startUrl = endUrl;
                ISVNLogMessage[] log = client.getLogMessages(startUrl, (SVNRevision)new SVNRevision.Number(0L), (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, false, 0L);
                startRevision = log[0].getRevision();
            }
            if (support.isCanceled()) {
                return;
            }
            client.merge(startUrl, startRevision, endUrl, endRevision, root, false, recursive);
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

