/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.SwitchTo;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchToAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Switch";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.getContext(nodes).getRoots().size() > 0;
    }

    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        final File root = ctx.getRootFiles()[0];
        try {
            url = SvnUtils.getRepositoryRootUrl(root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryRoot = new RepositoryFile(url, url, SVNRevision.HEAD);
        File[] files = Subversion.getInstance().getStatusCache().listFiles(ctx, 6612);
        boolean hasChanges = files.length > 0;
        final SwitchTo switchTo = new SwitchTo(repositoryRoot, root, hasChanges);
        if (switchTo.showDialog()) {
            ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

                public void perform() {
                    RepositoryFile toRepositoryFile = switchTo.getRepositoryFile();
                    SwitchToAction.performSwitch(toRepositoryFile, root, this);
                }
            };
            support.start(this.createRequestProcessor(nodes));
        }
    }

    static void performSwitch(RepositoryFile toRepositoryFile, File root, SvnProgressSupport support) {
        File[][] split = Utils.splitFlatOthers((File[])new File[]{root});
        boolean recursive = split[0].length <= 0;
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(toRepositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            client.switchToUrl(root, toRepositoryFile.getFileUrl(), toRepositoryFile.getRevision(), recursive);
            SwitchToAction.refreshRecursively(root);
            Subversion.getInstance().refreshAllAnnotations();
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }

    private static void refreshRecursively(File file) {
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        if (!file.isFile()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                SwitchToAction.refreshRecursively(files[i]);
            }
        }
    }
}

