/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType;
    private File remoteFile;

    public DiffStreamSource(File baseFile, String revision, String title) {
        this.baseFile = baseFile;
        this.revision = revision;
        this.title = title;
    }

    public DiffStreamSource(String title) {
        this.baseFile = null;
        this.revision = null;
        this.title = title;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        if (this.baseFile.isDirectory()) {
            return "content/unknown";
        }
        try {
            this.init();
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        if (this.baseFile.isDirectory()) {
            return new StringReader(NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_NoFolderDiff"));
        }
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return new StringReader(NbBundle.getMessage(DiffStreamSource.class, (String)"BK5001", (Object)this.getTitle()));
        }
        return EncodedReaderFactory.getDefault().getReader(this.remoteFile, this.mimeType);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return "LOCAL".equals(this.revision) && this.isPrimary();
    }

    private boolean isPrimary() {
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    synchronized void init() throws IOException {
        if (this.baseFile.isDirectory()) {
            return;
        }
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        this.mimeType = Subversion.getInstance().getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                File tempFolder = Utils.getTempFolder();
                Set allFiles = Utils.getAllDataObjectFiles((File)this.baseFile);
                for (File file : allFiles) {
                    boolean isBase = file.equals(this.baseFile);
                    try {
                        File rf = VersionsCache.getInstance().getFileRevision(file, this.revision);
                        if (rf == null) {
                            this.remoteFile = null;
                            return;
                        }
                        File newRemoteFile = new File(tempFolder, file.getName());
                        newRemoteFile.deleteOnExit();
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(newRemoteFile), (InputStream)new FileInputStream(rf));
                        if (!isBase) continue;
                        this.remoteFile = newRemoteFile;
                    }
                    catch (Exception e) {
                        if (!isBase) continue;
                        throw e;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = Subversion.getInstance().getMimeType(this.remoteFile);
            }
        }
        catch (Exception e) {
            IOException failure = new IOException("Can not load remote file for " + this.baseFile);
            failure.initCause(e);
            throw failure;
        }
    }
}

