/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.diff.DiffStreamSource;
import org.openide.util.NbBundle;

public final class Setup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_PRISTINE = "PRISTINE";
    public static final String REVISION_BASE = "BASE";
    public static final String REVISION_CURRENT = "LOCAL";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String firstRevision;
    private final String secondRevision;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffView view;
    private String title;

    public Setup(File baseFile, int type) {
        String secondTitle;
        String firstTitle;
        this.baseFile = baseFile;
        FileInformation info = Subversion.getInstance().getStatusCache().getStatus(baseFile);
        int status = info.getStatus();
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        switch (type) {
            case 0: 
            case 1: {
                if (Setup.match(status, 4100)) {
                    this.firstRevision = REVISION_BASE;
                    firstTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.firstRevision = null;
                    firstTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.firstRevision = REVISION_BASE;
                    firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                this.firstRevision = REVISION_BASE;
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                break;
            }
            case 2: {
                if (Setup.match(status, 512)) {
                    this.firstRevision = REVISION_HEAD;
                    firstTitle = loc.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(status, 4100)) {
                    this.firstRevision = null;
                    firstTitle = loc.getString("MSG_DiffPanel_NoBaseRevision");
                    break;
                }
                if (Setup.match(status, 1024)) {
                    this.firstRevision = null;
                    firstTitle = loc.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.firstRevision = REVISION_HEAD;
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        switch (type) {
            case 0: 
            case 2: {
                if (Setup.match(status, 64)) {
                    this.secondRevision = REVISION_CURRENT;
                    secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision);
                    break;
                }
                if (Setup.match(status, 4100)) {
                    this.secondRevision = REVISION_CURRENT;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.secondRevision = null;
                    secondTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = REVISION_CURRENT;
                secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalModified"), this.secondRevision);
                break;
            }
            case 1: {
                if (Setup.match(status, 4100)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.secondRevision = REVISION_HEAD;
                    secondTitle = loc.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(status, 1024)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.secondRevision = REVISION_HEAD;
                secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), this.secondRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        this.firstSource = new DiffStreamSource(baseFile, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(baseFile, this.secondRevision, secondTitle);
        this.title = "<html>" + Subversion.getInstance().getAnnotator().annotateNameHtml(baseFile, info);
    }

    public Setup(File baseFile, String firstRevision, String secondRevision) {
        this.baseFile = baseFile;
        this.firstRevision = firstRevision;
        this.secondRevision = secondRevision;
        this.firstSource = new DiffStreamSource(baseFile, firstRevision, firstRevision);
        this.secondSource = new DiffStreamSource(baseFile, secondRevision, secondRevision);
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setView(DiffView view) {
        this.view = view;
    }

    public DiffView getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }
}

