/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.DiffStreamSource;
import org.netbeans.modules.subversion.ui.history.DiffTreeTable;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.RevisionNode;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffResultsView
implements AncestorListener,
PropertyChangeListener,
DiffSetupSource {
    private final SearchHistoryPanel parent;
    private DiffTreeTable treeView;
    private JSplitPane diffView;
    private ShowDiffTask currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    private DiffView currentDiff;
    private int currentDifferenceIndex;
    private int currentIndex;
    private boolean dividerSet;
    private List<RepositoryRevision> results;
    private static final RequestProcessor rp = new RequestProcessor("SubversionDiff", 1, true);
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel parent, List<RepositoryRevision> results) {
        this.parent = parent;
        this.results = results;
        this.treeView = new DiffTreeTable(parent);
        this.treeView.setResults(results);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            final Node[] nodes = (Node[])evt.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodes.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodes.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    RepositoryRevision container1 = (RepositoryRevision)nodes[0].getLookup().lookup(RepositoryRevision.class);
                    RepositoryRevision.Event r1 = (RepositoryRevision.Event)nodes[0].getLookup().lookup(RepositoryRevision.Event.class);
                    try {
                        DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                        if (nodes.length == 1) {
                            if (container1 != null) {
                                DiffResultsView.this.showContainerDiff(container1, DiffResultsView.this.onSelectionshowLastDifference);
                            } else if (r1 != null) {
                                DiffResultsView.this.showRevisionDiff(r1, DiffResultsView.this.onSelectionshowLastDifference);
                            }
                        } else if (nodes.length == 2) {
                            RepositoryRevision.Event r2 = (RepositoryRevision.Event)nodes[1].getLookup().lookup(RepositoryRevision.Event.class);
                            if (r2.getFile() == null || !r2.getFile().equals(r1.getFile())) {
                                throw new Exception();
                            }
                            long revision2 = r1.getLogInfoHeader().getLog().getRevision().getNumber();
                            long revision1 = r2.getLogInfoHeader().getLog().getRevision().getNumber();
                            DiffResultsView.this.showDiff(r1, Long.toString(revision1), Long.toString(revision2), false);
                        }
                    }
                    catch (Exception e) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public Collection getSetups() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            return this.parent.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Node n : nodes) {
            RevisionNode node = (RevisionNode)n;
            if (node.getEvent() != null) {
                events.add(node.getEvent());
                continue;
            }
            revisions.add(node.getContainer());
        }
        return this.parent.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private void showDiffError(String s) {
        this.setBottomComponent((Component)new NoContentPanel(s));
    }

    private void setBottomComponent(Component component) {
        int dl = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiff(RepositoryRevision.Event header, String revision1, String revision2, boolean showLastDifference) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            this.currentTask = new ShowDiffTask(header, revision1, revision2, showLastDifference);
            this.currentShowDiffTask = rp.create((Runnable)this.currentTask);
            this.currentShowDiffTask.schedule(0);
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    private void setDiffIndex(int idx, boolean showLastDifference) {
        this.currentIndex = idx;
        this.onSelectionshowLastDifference = showLastDifference;
        this.treeView.setSelection(idx);
    }

    private void showRevisionDiff(RepositoryRevision.Event rev, boolean showLastDifference) {
        if (rev.getFile() == null) {
            return;
        }
        long revision2 = rev.getLogInfoHeader().getLog().getRevision().getNumber();
        long revision1 = revision2 - 1L;
        this.showDiff(rev, Long.toString(revision1), Long.toString(revision2), showLastDifference);
    }

    private void showContainerDiff(RepositoryRevision container, boolean showLastDifference) {
        File[] roots;
        List<RepositoryRevision.Event> revs = container.getEvents();
        RepositoryRevision.Event newest = null;
        for (File root : roots = this.parent.getRoots()) {
            for (RepositoryRevision.Event evt : revs) {
                if (!root.equals(evt.getFile())) continue;
                newest = evt;
            }
        }
        if (newest == null) {
            newest = revs.get(0);
        }
        if (newest.getFile() == null) {
            return;
        }
        long rev = newest.getLogInfoHeader().getLog().getRevision().getNumber();
        this.showDiff(newest, Long.toString(rev - 1L), Long.toString(rev), showLastDifference);
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(RepositoryRevision.Event revision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(revision);
    }

    void select(RepositoryRevision container) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(container);
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    implements Runnable,
    Cancellable {
        private final RepositoryRevision.Event header;
        private final String revision1;
        private final String revision2;
        private boolean showLastDifference;
        private volatile boolean cancelled;

        public ShowDiffTask(RepositoryRevision.Event header, String revision1, String revision2, boolean showLastDifference) {
            this.header = header;
            this.revision1 = revision1;
            this.revision2 = revision2;
            this.showLastDifference = showLastDifference;
        }

        public void run() {
            final Diff diff = Diff.getDefault();
            final DiffStreamSource s1 = new DiffStreamSource(this.header.getFile(), this.revision1, this.revision1);
            final DiffStreamSource s2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2);
            s1.getMIMEType();
            if (this.cancelled) {
                return;
            }
            s2.getMIMEType();
            if (this.cancelled) {
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.cancelled) {
                            return;
                        }
                        DiffView view = diff.createDiff((StreamSource)s1, (StreamSource)s2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = view;
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getComponent());
                            if (DiffResultsView.this.currentDiff.getDifferenceCount() > 0) {
                                DiffResultsView.this.currentDifferenceIndex = ShowDiffTask.this.showLastDifference ? DiffResultsView.this.currentDiff.getDifferenceCount() - 1 : 0;
                                DiffResultsView.this.currentDiff.setCurrentDifference(DiffResultsView.this.currentDifferenceIndex);
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            });
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

