/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.RevisionNode;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends TreeTableView {
    private RevisionsRootNode rootNode;
    private List results;
    private final SearchHistoryPanel master;

    public DiffTreeTable(SearchHistoryPanel master) {
        this.master = master;
        this.treeTable.setShowHorizontalLines(true);
        this.treeTable.setShowVerticalLines(false);
        this.setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.tree.setCellRenderer(renderer);
    }

    private void setupColumns() {
        Node.Property[] columns = new Node.Property[4];
        ResourceBundle loc = NbBundle.getBundle(DiffTreeTable.class);
        columns[0] = new ColumnDescriptor<String>("name", String.class, "", "");
        columns[0].setValue("TreeColumnTTV", (Object)Boolean.TRUE);
        columns[1] = new ColumnDescriptor<String>("date", String.class, loc.getString("LBL_DiffTree_Column_Time"), loc.getString("LBL_DiffTree_Column_Time_Desc"));
        columns[2] = new ColumnDescriptor<String>("username", String.class, loc.getString("LBL_DiffTree_Column_Username"), loc.getString("LBL_DiffTree_Column_Username_Desc"));
        columns[3] = new ColumnDescriptor<String>("message", String.class, loc.getString("LBL_DiffTree_Column_Message"), loc.getString("LBL_DiffTree_Column_Message_Desc"));
        this.setProperties(columns);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int width = DiffTreeTable.this.getWidth();
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(width * 25 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(width * 15 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(width * 50 / 100);
            }
        });
    }

    void setSelection(int idx) {
        this.treeTable.getSelectionModel().setValueIsAdjusting(false);
        this.treeTable.scrollRectToVisible(this.treeTable.getCellRect(idx, 1, true));
        this.treeTable.getSelectionModel().setSelectionInterval(idx, idx);
    }

    void setSelection(RepositoryRevision container) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, container);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void setSelection(RepositoryRevision.Event revision) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, revision);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Node getNode(Node node, Object obj) {
        Object object = node.getLookup().lookup(obj.getClass());
        if (obj.equals(object)) {
            return node;
        }
        Enumeration children = node.getChildren().nodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Node result = this.getNode(child, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int[] getSelection() {
        return this.treeTable.getSelectedRows();
    }

    public int getRowCount() {
        return this.treeTable.getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        em.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List results) {
        this.results = results;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        if (em != null) {
            em.setRootContext((Node)this.rootNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object key) {
            RevisionNode node = key instanceof RepositoryRevision ? new RevisionNode((RepositoryRevision)key, DiffTreeTable.this.master) : new RevisionNode((RepositoryRevision.Event)key, DiffTreeTable.this.master);
            return new Node[]{node};
        }
    }
}

