/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepositoryRevision {
    private ISVNLogMessage message;
    private SVNUrl repositoryRootUrl;
    private final List<Event> events = new ArrayList<Event>(1);

    public RepositoryRevision(ISVNLogMessage message, SVNUrl rootUrl) {
        this.message = message;
        this.repositoryRootUrl = rootUrl;
        this.initEvents();
    }

    public SVNUrl getRepositoryRootUrl() {
        return this.repositoryRootUrl;
    }

    private void initEvents() {
        ISVNLogMessageChangePath[] paths = this.message.getChangedPaths();
        if (paths == null) {
            return;
        }
        for (ISVNLogMessageChangePath path : paths) {
            this.events.add(new Event(path));
        }
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public ISVNLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getLog().getRevision().getNumber());
        text.append("\t");
        text.append(this.getLog().getDate());
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getMessage());
        return text.toString();
    }

    public class Event {
        private File file;
        private ISVNLogMessageChangePath changedPath;
        private String name;
        private String path;

        public Event(ISVNLogMessageChangePath changedPath) {
            this.changedPath = changedPath;
            this.name = changedPath.getPath().substring(changedPath.getPath().lastIndexOf(47) + 1);
            this.path = changedPath.getPath().substring(0, changedPath.getPath().lastIndexOf(47));
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public ISVNLogMessageChangePath getChangedPath() {
            return this.changedPath;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            text.append("\t");
            text.append(this.getPath());
            return text.toString();
        }
    }
}

