/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.RevisionNodeChildren;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.history.SummaryView;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_MESSAGE = "message";
    private RepositoryRevision.Event event;
    private RepositoryRevision container;
    private String path;

    public RevisionNode(RepositoryRevision container, SearchHistoryPanel master) {
        super((Children)new RevisionNodeChildren(container, master), Lookups.fixed((Object[])new Object[]{master, container}));
        this.container = container;
        this.event = null;
        this.path = null;
        this.setName(container.getLog().getRevision().getNumber() + NbBundle.getMessage(RevisionNode.class, (String)"LBL_NumberOfChangedPaths", (Object)container.getLog().getChangedPaths().length));
        this.initProperties();
    }

    public RevisionNode(RepositoryRevision.Event revision, SearchHistoryPanel master) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{master, revision}));
        this.path = revision.getChangedPath().getPath();
        this.event = revision;
        this.setName(revision.getName());
        this.initProperties();
    }

    RepositoryRevision.Event getRevision() {
        return this.event;
    }

    RepositoryRevision getContainer() {
        return this.container;
    }

    RepositoryRevision.Event getEvent() {
        return this.event;
    }

    public String getShortDescription() {
        return this.path;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return null;
        }
        if (this.event == null) {
            return new Action[]{SystemAction.get(RevertModificationsAction.class)};
        }
        return new Action[]{new RollbackAction(), SystemAction.get(RevertModificationsAction.class)};
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new UsernameProperty());
        ps.put((Node.Property)new MessageProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CommitNodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected CommitNodeProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor((String)this.getValue());
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, String.class, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return DateFormat.getDateTimeInstance().format(RevisionNode.this.container.getLog().getDate());
            }
            return "";
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, String.class, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return RevisionNode.this.container.getLog().getMessage();
            }
            return "";
        }
    }

    private static class RevertModificationsAction
    extends NodeAction {
        private RevertModificationsAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
            HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
            for (Node n : activatedNodes) {
                RevisionNode node = (RevisionNode)n;
                if (node.event != null) {
                    events.add(node.event);
                    continue;
                }
                revisions.add(node.container);
            }
            SearchHistoryPanel master = (SearchHistoryPanel)activatedNodes[0].getLookup().lookup(SearchHistoryPanel.class);
            SummaryView.revert(master, revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_RollbackChange");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RevertModificationsAction.class);
        }
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(String value) {
            this.setValue(value);
        }

        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            renderer.setText((String)this.getValue());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private class RollbackAction
    extends AbstractAction {
        public RollbackAction() {
            this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_RollbackTo", (Object)RevisionNode.this.event.getLogInfoHeader().getLog().getRevision().getNumber()));
        }

        public void actionPerformed(ActionEvent e) {
            SummaryView.rollback(RevisionNode.this.event);
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, String.class, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return RevisionNode.this.container.getLog().getAuthor();
            }
            return "";
        }
    }
}

