/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTableModel;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesNode;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

public class PropertiesTable
implements AncestorListener,
TableModelListener {
    static final String[] PROPERTIES_COLUMNS = new String[]{"name", "value"};
    private PropertiesTableModel tableModel;
    private JTable table;
    private TableSorter sorter;
    private JComponent component;
    private String[] columns;
    private String[] sortByColumns;

    public PropertiesTable(String[] columns, String[] sortByColumns) {
        this.init(columns, null);
        this.sortByColumns = sortByColumns;
        this.setSortingStatus();
    }

    public PropertiesTable(String[] columns, TableSorter sorter) {
        this.init(columns, sorter);
    }

    private void init(String[] columns, TableSorter sorter) {
        this.tableModel = new PropertiesTableModel(columns);
        this.tableModel.addTableModelListener(this);
        if (sorter == null) {
            sorter = new TableSorter((TableModel)this.tableModel);
        }
        this.sorter = sorter;
        this.table = new JTable((TableModel)this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new PropertiesTableCellRenderer());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight());
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 30);
        this.component.setPreferredSize(new Dimension(340, 150));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesTable.class, (String)"ACSD_PropertiesTable"));
        this.setColumns(columns);
    }

    public void setColumns(String[] clmns) {
        if (Arrays.equals(this.columns, clmns)) {
            return;
        }
        this.columns = clmns;
        this.tableModel.setColumns(clmns);
        this.setDefaultColumnSize();
    }

    public JTable getTable() {
        return this.table;
    }

    private void setDefaultColumnSize() {
        int width = this.table.getWidth();
        TableColumnModel columnModel = this.table.getColumnModel();
        if (this.columns == null || columnModel == null) {
            return;
        }
        if (columnModel.getColumnCount() != this.columns.length) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            this.sorter.setColumnComparator(i, null);
            if (col.equals("name")) {
                columnModel.getColumn(i).setPreferredWidth(width * 20 / 100);
                continue;
            }
            if (!col.equals("value")) continue;
            columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
        }
    }

    private void setSortingStatus() {
        block0: for (int i = 0; i < this.sortByColumns.length; ++i) {
            String sortByColumn = this.sortByColumns[i];
            for (int j = 0; j < this.columns.length; ++j) {
                String column = this.columns[j];
                if (!column.equals(sortByColumn)) continue;
                this.sorter.setSortingStatus(j, column.equals(sortByColumn) ? 1 : 0);
                continue block0;
            }
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    public int getModelIndex(int viewIndex) {
        return this.sorter.modelIndex(viewIndex);
    }

    public int[] getSelectedItems() {
        return this.table.getSelectedRows();
    }

    public SvnPropertiesNode[] getNodes() {
        return this.tableModel.getNodes();
    }

    public void setNodes(SvnPropertiesNode[] nodes) {
        this.tableModel.setNodes(nodes);
    }

    JComponent getComponent() {
        return this.component;
    }

    public void ancestorAdded(AncestorEvent arg0) {
        this.setDefaultColumnSize();
    }

    public void ancestorRemoved(AncestorEvent arg0) {
    }

    public void ancestorMoved(AncestorEvent arg0) {
    }

    public void tableChanged(TableModelEvent event) {
        this.table.repaint();
    }

    public class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Component renderer = super.getTableCellRendererComponent(table, value, hasFocus, hasFocus, rowIndex, columnIndex);
            if (renderer instanceof JComponent) {
                String strValue = PropertiesTable.this.tableModel.getNode(PropertiesTable.this.sorter.modelIndex(rowIndex)).getValue();
                ((JComponent)renderer).setToolTipText(strValue);
            }
            this.setToolTipText(value.toString());
            return renderer;
        }
    }
}

