/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnProperties;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SvnPropertiesAction
extends ContextAction {
    protected boolean enable(Node[] nodes) {
        return this.getContext(nodes).getRootFiles().length == 1;
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    public String getName() {
        return NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesAction");
    }

    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Properties";
    }

    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        String ctxDisplayName = this.getContextDisplayName(nodes);
        File[] roots = ctx.getRootFiles();
        try {
            SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(roots[0]);
            SvnClient client = Subversion.getInstance().getClient(repositoryUrl);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        PropertiesPanel panel = new PropertiesPanel();
        PropertiesTable propTable = new PropertiesTable(PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        panel.setPropertiesTable(propTable);
        JComponent component = propTable.getComponent();
        panel.propsPanel.setLayout(new BorderLayout());
        panel.propsPanel.add((Component)component, "Center");
        SvnProperties svnProperties = new SvnProperties(panel, propTable, roots[0]);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesDialog_Title", (Object)ctxDisplayName));
        dd.setModal(true);
        dd.setOptions(new Object[]{NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_Properties_Action_Cancel")});
        dd.setHelpCtx(new HelpCtx(SvnPropertiesAction.class));
        panel.putClientProperty("contentTitle", ctxDisplayName);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.pack();
        dialog.setVisible(true);
    }
}

