/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.repository.RepositoryDialogPanel;
import org.netbeans.modules.subversion.ui.repository.RepositoryPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements ActionListener,
DocumentListener,
FocusListener,
ItemListener {
    public static final int FLAG_URL_EDITABLE = 2;
    public static final int FLAG_URL_ENABLED = 4;
    public static final int FLAG_ACCEPT_REVISION = 8;
    public static final int FLAG_SHOW_REMOVE = 16;
    public static final int FLAG_SHOW_HINTS = 32;
    public static final int FLAG_SHOW_PROXY = 64;
    private static final String LOCAL_URL_HELP = "file:///repository_path[@REV]";
    private static final String HTTP_URL_HELP = "http://hostname/repository_path[@REV]";
    private static final String HTTPS_URL_HELP = "https://hostname/repository_path[@REV]";
    private static final String SVN_URL_HELP = "svn://hostname/repository_path[@REV]";
    private static final String SVN_SSH_URL_HELP = "svn+{0}://hostname/repository_path[@REV]";
    private RepositoryPanel repositoryPanel;
    private boolean valid = true;
    private List<PropertyChangeListener> listeners;
    private RepositoryConnection editedRC;
    public static final String PROP_VALID = "valid";
    private String message;
    private int modeMask;

    public Repository(String titleLabel) {
        this(0, titleLabel);
    }

    public Repository(int modeMask, String titleLabel) {
        this.modeMask = modeMask;
        this.initPanel();
        this.refreshUrlHistory();
        this.repositoryPanel.titleLabel.setText(titleLabel);
        this.repositoryPanel.urlComboBox.setEditable(this.isSet(2));
        this.repositoryPanel.urlComboBox.setEnabled(this.isSet(4));
        this.repositoryPanel.tunnelHelpLabel.setVisible(this.isSet(32));
        this.repositoryPanel.tipLabel.setVisible(this.isSet(32));
        this.repositoryPanel.removeButton.setVisible(this.isSet(16));
    }

    public void selectUrl(SVNUrl url, boolean force) {
        DefaultComboBoxModel dcbm = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int idx = dcbm.getIndexOf(url.toString());
        if (idx > -1) {
            dcbm.setSelectedItem(url.toString());
        } else if (force) {
            RepositoryConnection rc = new RepositoryConnection(url.toString());
            dcbm.addElement(rc);
            dcbm.setSelectedItem(rc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.repositoryPanel.proxySettingsButton) {
            this.onProxyConfiguration();
        } else if (e.getSource() == this.repositoryPanel.removeButton) {
            this.onRemoveClick();
        }
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
    }

    private void initPanel() {
        this.repositoryPanel = new RepositoryPanel();
        this.repositoryPanel.proxySettingsButton.addActionListener(this);
        this.repositoryPanel.removeButton.addActionListener(this);
        this.repositoryPanel.urlComboBox.addActionListener(this);
        this.getUrlComboEditor().getDocument().addDocumentListener(this);
        this.repositoryPanel.userPasswordField.getDocument().addDocumentListener(this);
        this.repositoryPanel.userPasswordField.addFocusListener(this);
        this.repositoryPanel.userTextField.getDocument().addDocumentListener(this);
        this.repositoryPanel.tunnelCommandTextField.getDocument().addDocumentListener(this);
        this.repositoryPanel.urlComboBox.addItemListener(this);
        this.onSelectedRepositoryChange();
    }

    public void refreshUrlHistory() {
        List<RepositoryConnection> recentUrls = SvnModuleConfig.getDefault().getRecentUrls();
        LinkedHashSet<RepositoryConnection> recentRoots = new LinkedHashSet<RepositoryConnection>();
        recentRoots.addAll(recentUrls);
        if (this.repositoryPanel.urlComboBox.isEditable()) {
            recentRoots.add(new RepositoryConnection("file:///"));
            recentRoots.add(new RepositoryConnection("http://"));
            recentRoots.add(new RepositoryConnection("https://"));
            recentRoots.add(new RepositoryConnection("svn://"));
            recentRoots.add(new RepositoryConnection("svn+ssh://"));
        }
        RepositoryModel rootsModel = new RepositoryModel(new Vector(recentRoots));
        this.repositoryPanel.urlComboBox.setModel(rootsModel);
        if (recentRoots.size() > 0) {
            this.repositoryPanel.urlComboBox.setSelectedIndex(0);
            this.refresh(this.getSelectedRC());
        }
        if (this.repositoryPanel.urlComboBox.isEditable()) {
            JTextComponent textEditor = this.getUrlComboEditor();
            textEditor.selectAll();
        }
    }

    public void storeRecentUrls() {
        SvnModuleConfig.getDefault().setRecentUrls(this.getRecentUrls());
    }

    private List<RepositoryConnection> getRecentUrls() {
        ComboBoxModel model = this.repositoryPanel.urlComboBox.getModel();
        ArrayList<RepositoryConnection> ret = new ArrayList<RepositoryConnection>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            ret.add((RepositoryConnection)model.getElementAt(i));
        }
        return ret;
    }

    private JTextComponent getUrlComboEditor() {
        Component editor = this.repositoryPanel.urlComboBox.getEditor().getEditorComponent();
        JTextComponent textEditor = (JTextComponent)editor;
        return textEditor;
    }

    public void setEditable(boolean editable) {
        this.repositoryPanel.urlComboBox.setEditable(editable);
        this.repositoryPanel.userPasswordField.setEditable(editable);
        this.repositoryPanel.userTextField.setEditable(editable);
        this.repositoryPanel.proxySettingsButton.setEnabled(editable);
    }

    public void storeConfigValues() {
        RepositoryConnection rc = this.getSelectedRC();
        if (rc == null) {
            return;
        }
        try {
            SVNUrl repositoryUrl = rc.getSvnUrl();
            if (repositoryUrl.getProtocol().startsWith("svn+")) {
                SvnConfigFiles.getInstance().setExternalCommand(this.getTunnelName(repositoryUrl.getProtocol()), this.repositoryPanel.tunnelCommandTextField.getText());
            }
        }
        catch (MalformedURLException mue) {
            ErrorManager.getDefault().notify(1, (Throwable)mue);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void textChanged(final DocumentEvent e) {
        Runnable awt = new Runnable(){

            public void run() {
                if (e.getDocument() == ((Repository)Repository.this).repositoryPanel.userTextField.getDocument()) {
                    Repository.this.onUsernameChange();
                } else if (e.getDocument() == ((Repository)Repository.this).repositoryPanel.userPasswordField.getDocument()) {
                    Repository.this.onPasswordChange();
                } else if (e.getDocument() == ((JTextComponent)((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getEditorComponent()).getDocument()) {
                    Repository.this.onSelectedRepositoryChange();
                } else if (e.getDocument() == ((Repository)Repository.this).repositoryPanel.tunnelCommandTextField.getDocument()) {
                    Repository.this.onTunnelCommandChange();
                }
                Repository.this.validateSvnUrl();
            }
        };
        SwingUtilities.invokeLater(awt);
    }

    private void validateSvnUrl() {
        boolean valid = true;
        RepositoryConnection rc = null;
        try {
            rc = this.getSelectedRC();
            rc.getSvnUrl();
            if (!this.isSet(8) && !rc.getSvnRevision().equals((Object)SVNRevision.HEAD)) {
                this.message = NbBundle.getMessage(Repository.class, (String)"MSG_Repository_OnlyHEADRevision");
                valid = false;
            } else {
                rc.getSvnRevision();
            }
        }
        catch (Exception ex) {
            this.message = ex.getLocalizedMessage();
            valid = false;
        }
        if (valid) {
            boolean bl = valid = rc != null && !rc.getUrl().equals("");
            if (rc.getUrl().startsWith("svn+") && this.repositoryPanel.tunnelCommandTextField.getText().trim().equals("")) {
                valid = false;
            }
        }
        this.setValid(valid, this.message);
        this.repositoryPanel.proxySettingsButton.setEnabled(valid);
        this.repositoryPanel.userPasswordField.setEnabled(valid);
        this.repositoryPanel.userTextField.setEnabled(valid);
        this.repositoryPanel.removeButton.setEnabled(rc != null && rc.getUrl().length() > 0);
    }

    private void onSelectedRepositoryChange() {
        this.setValid(true, "");
        String urlString = "";
        try {
            urlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            return;
        }
        if (urlString != null) {
            RepositoryConnection editedrc = this.getEditedRC();
            editedrc.setUrl(urlString);
            DefaultComboBoxModel dcbm = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
            int idx = dcbm.getIndexOf(editedrc);
            if (idx > -1) {
                this.refresh((RepositoryConnection)dcbm.getElementAt(idx));
            }
            if (urlString.startsWith("svn+")) {
                String tunnelName = this.getTunnelName(urlString).trim();
                if (this.repositoryPanel.tunnelCommandTextField.getText().trim().equals("") && tunnelName != null && !tunnelName.equals("")) {
                    this.repositoryPanel.tunnelCommandTextField.setText(SvnConfigFiles.getInstance().getExternalCommand(tunnelName));
                }
            }
            editedrc.setUsername(this.repositoryPanel.userTextField.getText());
            editedrc.setPassword(new String(this.repositoryPanel.userPasswordField.getPassword()));
            editedrc.setExternalCommand(this.repositoryPanel.tunnelCommandTextField.getText());
        }
        this.message = "";
        this.updateVisibility();
    }

    private RepositoryConnection getEditedRC() {
        if (this.editedRC == null) {
            this.editedRC = new RepositoryConnection("");
        }
        return this.editedRC;
    }

    private void updateVisibility() {
        String selectedUrlString;
        try {
            selectedUrlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            return;
        }
        boolean authFields = false;
        boolean proxyFields = false;
        boolean sshFields = false;
        if (selectedUrlString.startsWith("http:")) {
            this.repositoryPanel.tipLabel.setText(HTTP_URL_HELP);
            authFields = true;
            proxyFields = true;
        } else if (selectedUrlString.startsWith("https:")) {
            this.repositoryPanel.tipLabel.setText(HTTPS_URL_HELP);
            authFields = true;
            proxyFields = true;
        } else if (selectedUrlString.startsWith("svn:")) {
            this.repositoryPanel.tipLabel.setText(SVN_URL_HELP);
            authFields = true;
            proxyFields = true;
        } else if (selectedUrlString.startsWith("svn+")) {
            this.repositoryPanel.tipLabel.setText(this.getSVNTunnelTip(selectedUrlString));
            sshFields = true;
        } else if (selectedUrlString.startsWith("file:")) {
            this.repositoryPanel.tipLabel.setText(LOCAL_URL_HELP);
        } else {
            this.repositoryPanel.tipLabel.setText(NbBundle.getMessage(Repository.class, (String)"MSG_Repository_Url_Help", (Object[])new Object[]{LOCAL_URL_HELP, HTTP_URL_HELP, HTTPS_URL_HELP, SVN_URL_HELP, SVN_SSH_URL_HELP}));
        }
        this.repositoryPanel.userPasswordField.setVisible(authFields);
        this.repositoryPanel.passwordLabel.setVisible(authFields);
        this.repositoryPanel.userTextField.setVisible(authFields);
        this.repositoryPanel.leaveBlankLabel.setVisible(authFields);
        this.repositoryPanel.userLabel.setVisible(authFields);
        this.repositoryPanel.proxySettingsButton.setVisible(proxyFields && (this.modeMask & 0x40) != 0);
        this.repositoryPanel.tunnelCommandTextField.setVisible(sshFields);
        this.repositoryPanel.tunnelCommandLabel.setVisible(sshFields);
        this.repositoryPanel.tunnelLabel.setVisible(sshFields);
        this.repositoryPanel.tunnelHelpLabel.setVisible(sshFields);
    }

    private String getSVNTunnelTip(String urlString) {
        String tunnelName = this.getTunnelName(urlString);
        return MessageFormat.format(SVN_SSH_URL_HELP, tunnelName).trim();
    }

    private String getTunnelName(String urlString) {
        int idx = urlString.indexOf(":", 4);
        if (idx < 0) {
            idx = urlString.length();
        }
        return urlString.substring(4, idx);
    }

    private String getUrlString() throws InterruptedException {
        if (!this.repositoryPanel.urlComboBox.isEditable()) {
            Object selection = this.repositoryPanel.urlComboBox.getSelectedItem();
            if (selection != null) {
                return selection.toString().trim();
            }
            return "";
        }
        final String[] svnUrl = new String[1];
        try {
            Runnable awt = new Runnable(){

                public void run() {
                    svnUrl[0] = ((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getItem().toString().trim();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                awt.run();
            } else {
                SwingUtilities.invokeAndWait(awt);
            }
            return svnUrl[0].trim();
        }
        catch (InvocationTargetException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify((Throwable)e);
            return null;
        }
    }

    public RepositoryConnection getSelectedRC() {
        String urlString;
        try {
            urlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
        DefaultComboBoxModel dcbm = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int idx = dcbm.getIndexOf(urlString);
        if (idx > -1) {
            return (RepositoryConnection)dcbm.getElementAt(idx);
        }
        return this.getEditedRC();
    }

    private void onUsernameChange() {
        RepositoryConnection rc = this.getSelectedRC();
        if (rc != null) {
            rc.setUsername(this.repositoryPanel.userTextField.getText());
        }
        this.setValid(true, "");
    }

    private void onPasswordChange() {
        RepositoryConnection rc = this.getSelectedRC();
        if (rc != null) {
            rc.setPassword(new String(this.repositoryPanel.userPasswordField.getPassword()));
        }
        this.setValid(true, "");
    }

    private void onTunnelCommandChange() {
        RepositoryConnection rc = this.getSelectedRC();
        if (rc != null) {
            rc.setExternalCommand(this.repositoryPanel.tunnelCommandTextField.getText());
        }
    }

    private void onRemoveClick() {
        RepositoryConnection rc = this.getSelectedRC();
        if (rc != null) {
            this.remove(rc);
        }
    }

    public RepositoryPanel getPanel() {
        return this.repositoryPanel;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void setValid(boolean valid, String message) {
        boolean oldValue = this.valid;
        this.message = message;
        this.valid = valid;
        this.fireValidPropertyChanged(oldValue, valid);
    }

    private void fireValidPropertyChanged(boolean oldValue, boolean valid) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(new PropertyChangeEvent(this, PROP_VALID, new Boolean(oldValue), new Boolean(valid)));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.repositoryPanel.userPasswordField) {
            this.repositoryPanel.userPasswordField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void remove(RepositoryConnection toRemove) {
        RepositoryModel model = (RepositoryModel)this.repositoryPanel.urlComboBox.getModel();
        model.removeElement(toRemove);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            RepositoryConnection rc = (RepositoryConnection)evt.getItem();
            this.refresh(rc);
            this.updateVisibility();
            this.editedRC = new RepositoryConnection(rc);
        }
    }

    private void refresh(RepositoryConnection rc) {
        this.repositoryPanel.userTextField.setText(rc.getUsername());
        this.repositoryPanel.userPasswordField.setText(rc.getPassword());
        this.repositoryPanel.tunnelCommandTextField.setText(rc.getExternalCommand());
    }

    public boolean show(String title, HelpCtx helpCtx) {
        RepositoryDialogPanel corectPanel = new RepositoryDialogPanel();
        corectPanel.panel.setLayout(new BorderLayout());
        corectPanel.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)corectPanel, title);
        this.showDialog(dialogDescriptor, helpCtx);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Object show(String title, HelpCtx helpCtx, Object[] options) {
        RepositoryDialogPanel corectPanel = new RepositoryDialogPanel();
        corectPanel.panel.setLayout(new BorderLayout());
        corectPanel.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)corectPanel, title);
        if (options != null) {
            dialogDescriptor.setOptions(options);
        }
        this.showDialog(dialogDescriptor, helpCtx);
        return dialogDescriptor.getValue();
    }

    private void showDialog(DialogDescriptor dialogDescriptor, HelpCtx helpCtx) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(helpCtx);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private boolean isSet(int flag) {
        return (this.modeMask & flag) != 0;
    }

    public class RepositoryModel
    extends DefaultComboBoxModel {
        public RepositoryModel(Vector v) {
            super(v);
        }

        public void setSelectedItem(Object obj) {
            if (obj instanceof String) {
                int idx = this.getIndexOf(obj);
                obj = idx > -1 ? this.getElementAt(idx) : this.createNewRepositoryConnection((String)obj);
            }
            super.setSelectedItem(obj);
        }

        public int getIndexOf(Object obj) {
            if (obj instanceof String) {
                obj = this.createNewRepositoryConnection((String)obj);
            }
            return super.getIndexOf(obj);
        }

        public void addElement(Object obj) {
            if (obj instanceof String) {
                obj = this.createNewRepositoryConnection((String)obj);
            }
            super.addElement(obj);
        }

        public void insertElementAt(Object obj, int index) {
            if (obj instanceof String) {
                String str = (String)obj;
                RepositoryConnection rc = null;
                try {
                    rc = (RepositoryConnection)this.getElementAt(index);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                if (rc != null) {
                    rc.setUrl(str);
                    obj = rc;
                }
                obj = this.createNewRepositoryConnection(str);
            }
            super.insertElementAt(obj, index);
        }

        public void removeElement(Object obj) {
            int index = this.getIndexOf(obj);
            if (index != -1) {
                this.removeElementAt(index);
            }
        }

        private RepositoryConnection createNewRepositoryConnection(String url) {
            Repository.this.editedRC.setUrl(url);
            return new RepositoryConnection(Repository.this.editedRC);
        }
    }
}

