/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.search.SvnSearchPanel;
import org.netbeans.modules.subversion.ui.search.SvnSearchView;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnSearch
implements ActionListener,
DocumentListener {
    private static final String DATE_FROM = "svnSearch.dateFrom";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final SvnSearchPanel panel;
    private RepositoryFile repositoryRoot;
    private SvnSearchView searchView;
    private SvnProgressSupport support;
    private NoContentPanel noContentPanel;

    public SvnSearch(RepositoryFile repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
        this.panel = new SvnSearchPanel();
        this.panel.listButton.addActionListener(this);
        this.panel.dateFromTextField.getDocument().addDocumentListener(this);
        String date = DATE_FORMAT.format(new Date(System.currentTimeMillis() - 604800000L));
        this.panel.dateFromTextField.setText(SvnModuleConfig.getDefault().getPreferences().get(DATE_FROM, date));
        this.searchView = new SvnSearchView();
        this.panel.listPanel.setLayout(new BorderLayout());
        this.panel.listPanel.add(this.searchView.getComponent());
        this.noContentPanel = new NoContentPanel();
        this.panel.noContentPanel.setLayout(new BorderLayout());
        this.panel.noContentPanel.add((Component)this.noContentPanel);
        this.noContentPanel.setLabel(NbBundle.getMessage(SvnSearch.class, (String)"LBL_NoResults_SearchNotPerformed"));
        this.panel.listPanel.setVisible(false);
        this.panel.noContentPanel.setVisible(true);
    }

    public void cancel() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listLogEntries() {
        this.noContentPanel.setLabel(NbBundle.getMessage(SvnSearch.class, (String)"LBL_NoResults_SearchInProgress"));
        this.panel.listPanel.setVisible(false);
        this.panel.noContentPanel.setVisible(true);
        final SVNRevision revisionFrom = this.getRevisionFrom();
        if (revisionFrom instanceof SVNRevision.DateSpec) {
            SvnModuleConfig.getDefault().getPreferences().put(DATE_FROM, this.panel.dateFromTextField.getText().trim());
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(this.repositoryRoot.getRepositoryUrl());
        try {
            this.support = new SvnProgressSupport(){

                protected void perform() {
                    ISVNLogMessage[] lm;
                    try {
                        SvnClient client = Subversion.getInstance().getClient(SvnSearch.this.repositoryRoot.getRepositoryUrl(), (SvnProgressSupport)this);
                        lm = client.getLogMessages(SvnSearch.this.repositoryRoot.getRepositoryUrl(), SVNRevision.HEAD, revisionFrom);
                    }
                    catch (SVNClientException ex) {
                        AbstractNode errorNode = new AbstractNode(Children.LEAF);
                        errorNode.setDisplayName(NbBundle.getMessage(SvnSearch.class, (String)"LBL_Error"));
                        errorNode.setShortDescription(ex.getLocalizedMessage());
                        return;
                    }
                    if (this.isCanceled()) {
                        return;
                    }
                    ArrayList<ISVNLogMessage> msgList = new ArrayList<ISVNLogMessage>(lm.length);
                    if (revisionFrom instanceof SVNRevision.DateSpec) {
                        long timeFrom = ((SVNRevision.DateSpec)revisionFrom).getDate().getTime();
                        for (int i = 0; i < lm.length; ++i) {
                            if (lm[i].getDate().getTime() < timeFrom) continue;
                            msgList.add(lm[i]);
                        }
                        lm = msgList.toArray(new ISVNLogMessage[msgList.size()]);
                    }
                    final ISVNLogMessage[] msgRet = lm;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ((SvnSearch)SvnSearch.this).panel.listPanel.setVisible(true);
                            ((SvnSearch)SvnSearch.this).panel.noContentPanel.setVisible(false);
                            SvnSearch.this.searchView.setResults(msgRet);
                        }
                    });
                }
            };
            this.support.start(rp, this.repositoryRoot.getRepositoryUrl(), NbBundle.getMessage(SvnSearch.class, (String)"LBL_Search_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    public JPanel getSearchPanel() {
        return this.panel;
    }

    public SVNRevision getSelectedRevision() {
        return this.searchView.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.searchView.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.searchView.removeListSelectionListener(listener);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.listButton) {
            this.listLogEntries();
        }
    }

    private SVNRevision getRevisionFrom() {
        String value = this.panel.dateFromTextField.getText().trim();
        if (value.equals("")) {
            return new SVNRevision.Number(1L);
        }
        try {
            return new SVNRevision.DateSpec(DATE_FORMAT.parse(value));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        boolean isValid = false;
        String dateString = this.panel.dateFromTextField.getText();
        if (dateString.equals("")) {
            isValid = true;
        } else {
            try {
                DATE_FORMAT.parse(this.panel.dateFromTextField.getText());
                isValid = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.panel.listButton.setEnabled(isValid);
    }
}

