/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.openide.ErrorManager;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

class SvnSearchView
implements ComponentListener {
    private JList resultsList;
    private ISVNLogMessage[] lm;
    private AttributeSet searchHiliteAttrs;
    private JScrollPane pane;

    public SvnSearchView() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.resultsList = new JList(new SvnSearchListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.setCellRenderer(new SvnSearchListCellRenderer());
        this.resultsList.addComponentListener(this);
        this.pane = new JScrollPane(this.resultsList, 22, 31);
    }

    JComponent getComponent() {
        return this.pane;
    }

    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SvnSearchListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void setResults(ISVNLogMessage[] lm) {
        this.lm = lm;
        this.resultsList.setModel(new SvnSearchListModel());
    }

    SVNRevision getSelectedValue() {
        Object selection = this.resultsList.getSelectedValue();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof ISVNLogMessage)) {
            return null;
        }
        ISVNLogMessage message = (ISVNLogMessage)selection;
        return message.getRevision();
    }

    void addListSelectionListener(ListSelectionListener listener) {
        this.resultsList.addListSelectionListener(listener);
    }

    void removeListSelectionListener(ListSelectionListener listener) {
        this.resultsList.removeListSelectionListener(listener);
    }

    private class SvnSearchListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style boldStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private DateFormat defaultFormat;
        private int index;

        public SvnSearchListCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.boldStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.boldStyle, true);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            StyleConstants.setBackground(this.hiliteStyle, (Color)SvnSearchView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background));
            StyleConstants.setForeground(this.hiliteStyle, (Color)SvnSearchView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground));
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.textPane.setBorder(null);
        }

        public Color darker(Color c) {
            return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ISVNLogMessage) {
                int width;
                Style style;
                ISVNLogMessage message = (ISVNLogMessage)value;
                StyledDocument sd = this.textPane.getStyledDocument();
                if (isSelected) {
                    this.textPane.setBackground(UIManager.getColor("List.selectionBackground"));
                    style = this.selectedStyle;
                } else {
                    Color c = UIManager.getColor("List.background");
                    this.textPane.setBackground((index & 1) == 0 ? c : this.darker(c));
                    style = this.normalStyle;
                }
                try {
                    sd.remove(0, sd.getLength());
                    sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                    sd.insertString(0, message.getRevision().toString(), null);
                    sd.setCharacterAttributes(0, sd.getLength(), this.boldStyle, false);
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + message.getAuthor(), null);
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + this.defaultFormat.format(message.getDate()), null);
                    sd.insertString(sd.getLength(), "\n" + message.getMessage(), null);
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (message.getMessage() != null && (width = SvnSearchView.this.resultsList.getWidth()) > 0) {
                    FontMetrics fm = list.getFontMetrics(list.getFont());
                    Rectangle2D rect = fm.getStringBounds(message.getMessage(), this.textPane.getGraphics());
                    int nlc = -1;
                    int i = 0;
                    while (i != -1) {
                        i = message.getMessage().indexOf(10, i + 1);
                        ++nlc;
                    }
                    int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                    int ph = fm.getHeight() * (lines + nlc + 1) + 0;
                    this.textPane.setPreferredSize(new Dimension(width - 50, ph));
                }
            }
            return this;
        }
    }

    private class SvnSearchListModel
    extends AbstractListModel {
        private SvnSearchListModel() {
        }

        public int getSize() {
            if (SvnSearchView.this.lm == null) {
                return 0;
            }
            return SvnSearchView.this.lm.length;
        }

        public Object getElementAt(int index) {
            return SvnSearchView.this.lm[index];
        }
    }
}

