/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class StatusAction
extends ContextAction {
    private static final int enabledForStatus = -2;

    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ShowChanges";
    }

    protected int getFileEnabledStatus() {
        return -2;
    }

    public void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = SvnUtils.getCurrentContext(nodes);
        SvnVersioningTopComponent stc = SvnVersioningTopComponent.getInstance();
        stc.setContentTitle(this.getContextDisplayName(nodes));
        stc.setContext(ctx);
        stc.open();
        stc.requestActive();
        stc.performRefreshAction();
    }

    public static void executeStatus(Context context, SvnProgressSupport support) {
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(context, support);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            Subversion.getInstance().getStatusCache().refreshCached(context);
            File[] roots = context.getRootFiles();
            for (int i = 0; i < roots.length; ++i) {
                if (support.isCanceled()) {
                    return;
                }
                File root = roots[i];
                ISVNStatus[] statuses = client.getStatus(root, true, false, true);
                if (support.isCanceled()) {
                    return;
                }
                for (int s = 0; s < statuses.length; ++s) {
                    if (support.isCanceled()) {
                        return;
                    }
                    ISVNStatus status = statuses[s];
                    FileStatusCache cache = Subversion.getInstance().getStatusCache();
                    File file = status.getFile();
                    SVNStatusKind kind = status.getRepositoryTextStatus();
                    cache.refresh(file, status);
                }
            }
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

