/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.commit.ConflictResolvedAction;
import org.netbeans.modules.subversion.ui.commit.DeleteLocalAction;
import org.netbeans.modules.subversion.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.status.OpenInEditorAction;
import org.netbeans.modules.subversion.ui.status.SyncFileNode;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class SyncTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private SyncFileNode[] nodes = new SyncFileNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return 0;
            }
        }
    };

    public SyncTable() {
        ResourceBundle loc = NbBundle.getBundle(SyncTable.class);
        columnLabels.put("branch", new String[]{loc.getString("CTL_VersioningView_Column_Branch_Title"), loc.getString("CTL_VersioningView_Column_Branch_Desc")});
        columnLabels.put("name", new String[]{loc.getString("CTL_VersioningView_Column_File_Title"), loc.getString("CTL_VersioningView_Column_File_Desc")});
        columnLabels.put("status", new String[]{loc.getString("CTL_VersioningView_Column_Status_Title"), loc.getString("CTL_VersioningView_Column_Status_Desc")});
        columnLabels.put("path", new String[]{loc.getString("CTL_VersioningView_Column_Path_Title"), loc.getString("CTL_VersioningView_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SyncTable.class, (String)"ACSN_VersioningTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SyncTable.class, (String)"ACSD_VersioningTable"));
        this.setColumns(new String[]{"name", "status", "path"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SyncTable.this.showPopup(Utils.getPositionForPopup((JTable)SyncTable.this.table));
            }
        });
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block5: {
                    int width;
                    block4: {
                        width = SyncTable.this.table.getWidth();
                        if (SyncTable.this.tableColumns.length != 3) break block4;
                        for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                            if ("path".equals(SyncTable.this.tableColumns[i])) {
                                SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                                continue;
                            }
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                        }
                        break block5;
                    }
                    if (SyncTable.this.tableColumns.length != 4) break block5;
                    for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                        if ("path".equals(SyncTable.this.tableColumns[i])) {
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 55 / 100);
                            continue;
                        }
                        SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 15 / 100);
                    }
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public SyncFileNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        SyncFileNode[] ret = new SyncFileNode[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return ret;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, String.class, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    void setTableModel(SyncFileNode[] nodes) {
        this.nodes = nodes;
        this.tableModel.setNodes((Node[])nodes);
    }

    void focus() {
        this.table.requestFocus();
    }

    private void showPopup(final MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPopupMenu menu = SyncTable.this.getPopup();
                menu.show(SyncTable.this.table, e.getX(), e.getY());
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        menu.show(this.table, p.x, p.y);
    }

    private JPopupMenu getPopup() {
        SystemActionBridge revertAction;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(new OpenInEditorAction());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(DiffAction.class), this.actionString("CTL_PopupMenuItem_Diff")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(UpdateAction.class), this.actionString("CTL_PopupMenuItem_Update")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(CommitAction.class), this.actionString("CTL_PopupMenuItem_Commit")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(ConflictResolvedAction.class), NbBundle.getMessage(SyncTable.class, (String)"CTL_PopupMenuItem_ConflictResolved")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(BlameAction.class), ((BlameAction)SystemAction.get(BlameAction.class)).visible(null) ? this.actionString("CTL_PopupMenuItem_HideBlame") : this.actionString("CTL_PopupMenuItem_Blame")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(SearchHistoryAction.class), this.actionString("CTL_PopupMenuItem_SearchHistory")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.add(new JSeparator());
        ExcludeFromCommitAction exclude = (ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class);
        String label = exclude.getActionStatus(null) == 2 ? NbBundle.getMessage(SyncTable.class, (String)"CTL_PopupMenuItem_IncludeInCommit") : NbBundle.getMessage(SyncTable.class, (String)"CTL_PopupMenuItem_ExcludeFromCommit");
        item = menu.add((Action)new SystemActionBridge((Action)((Object)exclude), label));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        boolean allLocallyNew = true;
        boolean allLocallyDeleted = true;
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = SvnUtils.getCurrentContext(null).getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInformation info = cache.getStatus(file);
            if ((info.getStatus() & 0x1004) == 0) {
                allLocallyNew = false;
            }
            if (info.getStatus() == 2048 || info.getStatus() == 256) continue;
            allLocallyDeleted = false;
        }
        if (allLocallyNew) {
            SystemAction systemAction = SystemAction.get(DeleteLocalAction.class);
            revertAction = new SystemActionBridge((Action)systemAction, this.actionString("CTL_PopupMenuItem_Delete"));
        } else {
            revertAction = allLocallyDeleted ? new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_RevertDelete")) : new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_GetClean"));
        }
        item = menu.add((Action)revertAction);
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        SystemActionBridge ignoreAction = new SystemActionBridge((Action)SystemAction.get(IgnoreAction.class), ((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(files) == 2 ? this.actionString("CTL_PopupMenuItem_Unignore") : this.actionString("CTL_PopupMenuItem_Ignore"));
        item = menu.add((Action)ignoreAction);
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        return menu;
    }

    private String actionString(String key) {
        ResourceBundle actionsLoc = NbBundle.getBundle(Annotator.class);
        return actionsLoc.getString(key);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Action action = this.nodes[row = this.sorter.modelIndex(row)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        ArrayList<SyncFileNode> selectedNodes = new ArrayList<SyncFileNode>();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        final TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (tc == null) {
            return;
        }
        int min = selectionModel.getMinSelectionIndex();
        if (min != -1) {
            int max = selectionModel.getMaxSelectionIndex();
            for (int i = min; i <= max; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                int idx = this.sorter.modelIndex(i);
                selectedNodes.add(this.nodes[idx]);
            }
        }
        final Node[] nodes = selectedNodes.toArray(new Node[selectedNodes.size()]);
        if (SwingUtilities.isEventDispatchThread()) {
            tc.setActivatedNodes(nodes);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tc.setActivatedNodes(nodes);
                }
            });
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                SyncFileNode node = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(row)];
                if (!isSelected) {
                    value = "<html>" + node.getHtmlDisplayName();
                }
                if (SvnModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    String nodeName = node.getDisplayName();
                    value = isSelected ? "<html><s>" + nodeName + "</s></html>" : "<html><s>" + Subversion.getInstance().getAnnotator().annotateNameHtml(nodeName, node.getFileInformation(), null) + "</s>";
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                String path = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(row)].getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }
}

