/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "ResolveConflicts";
    }

    protected boolean enable(Node[] nodes) {
        Context ctx = SvnUtils.getCurrentContext(nodes);
        return SvnUtils.getModifiedFiles(ctx, 64).length > 0;
    }

    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = cache.listFiles(ctx, 64);
        if (files.length == 0) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        } else {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                ResolveConflictsExecutor executor = new ResolveConflictsExecutor(file);
                executor.exec();
            }
        }
    }

    public boolean asynchronous() {
        return false;
    }
}

