/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RevertModificationsAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Revert";
    }

    protected int getFileEnabledStatus() {
        return 7672;
    }

    protected int getDirectoryEnabledStatus() {
        return 7672;
    }

    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        final Context ctx = this.getContext(nodes);
        File root = ctx.getRootFiles()[0];
        try {
            url = SvnUtils.getRepositoryRootUrl(root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(url, url, SVNRevision.HEAD);
        final RevertModifications revertModifications = new RevertModifications(repositoryFile);
        if (!revertModifications.showDialog()) {
            return;
        }
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

            public void perform() {
                RevertModificationsAction.performRevert(ctx, revertModifications, this);
            }
        };
        support.start(this.createRequestProcessor(nodes));
    }

    public static void performRevert(Context ctx, RevertModifications revertModifications, SvnProgressSupport support) {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(ctx, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        File[] files = ctx.getFiles();
        File[][] split = Utils.splitFlatOthers((File[])files);
        for (int c = 0; c < split.length; ++c) {
            boolean recursive;
            if (support.isCanceled()) {
                return;
            }
            files = split[c];
            boolean bl = recursive = c == 1;
            if (!recursive) {
                files = SvnUtils.flatten(files, 6608);
            }
            try {
                RevertModifications.RevisionInterval revisions = revertModifications.getRevisionInterval();
                if (revisions != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (support.isCanceled()) {
                            return;
                        }
                        SVNUrl url = SvnUtils.getRepositoryUrl(files[i]);
                        revisions = RevertModificationsAction.recountStartRevision(client, url, revisions);
                        client.merge(url, revisions.endRevision, url, revisions.startRevision, files[i], false, recursive);
                    }
                    continue;
                }
                if (support.isCanceled()) {
                    return;
                }
                if (files.length <= 0) continue;
                client.revert(files, recursive);
                continue;
            }
            catch (SVNClientException ex) {
                support.annotate(ex);
            }
        }
        if (support.isCanceled()) {
            return;
        }
        if (revertModifications.revertNewFiles()) {
            File[] newfiles = Subversion.getInstance().getStatusCache().listFiles(ctx.getRootFiles(), 4100);
            for (int i = 0; i < newfiles.length; ++i) {
                FileObject fo = FileUtil.toFileObject((File)newfiles[i]);
                try {
                    if (fo == null) continue;
                    fo.delete();
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    private static void refreshRecursively(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                RevertModificationsAction.refreshRecursively(child);
            }
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        cache.refreshCached(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private static void addFileSystem(Set filesystems, File file) {
        FileObject fo;
        while ((fo = FileUtil.toFileObject((File)file)) == null) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        try {
            filesystems.add(fo.getFileSystem());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private static RevertModifications.RevisionInterval recountStartRevision(SvnClient client, SVNUrl repository, RevertModifications.RevisionInterval ret) throws SVNClientException {
        long start;
        if (ret.startRevision.equals((Object)SVNRevision.HEAD)) {
            ISVNInfo info = client.getInfo(repository);
            ret.startRevision = info.getRevision();
        }
        if ((start = Long.parseLong(ret.startRevision.toString())) > 0L) {
            --start;
        }
        ret.startRevision = new SVNRevision.Number(start);
        return ret;
    }
}

