/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public abstract class AbstractStep
implements WizardDescriptor.ValidatingPanel {
    private List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private boolean valid;
    private JComponent panel;
    private volatile boolean underConstruction;
    private String errorMessage;
    private boolean applyStandaloneLayout;

    public void applyStandaloneLayout() {
        this.applyStandaloneLayout = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Component getComponent() {
        if (this.panel == null) {
            try {
                this.underConstruction = true;
                this.panel = this.createComponent();
                HelpCtx.setHelpIDString((JComponent)this.panel, (String)this.getClass().getName());
                if (!this.applyStandaloneLayout) {
                    JTextArea template = new JTextArea();
                    template.setColumns(60);
                    template.setRows(25);
                    this.panel.setPreferredSize(template.getPreferredSize());
                }
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            finally {
                assert (this.panel != null);
                this.underConstruction = false;
                this.fireChange();
            }
        }
        return this.panel;
    }

    protected abstract JComponent createComponent();

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String extErrorMessage) {
        this.setValid(true, extErrorMessage);
    }

    protected final void invalid(String message) {
        this.setValid(false, message);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.isValid() || this.errorMessage != null) {
            throw new WizardValidationException(this.panel, this.errorMessage, this.errorMessage);
        }
    }

    protected abstract void validateBeforeNext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private void setValid(boolean valid, String errorMessage) {
        boolean fire = this.valid != valid;
        boolean bl = errorMessage != null && !errorMessage.equals(this.errorMessage);
        this.valid = valid;
        this.errorMessage = errorMessage;
        if (fire |= bl) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> clone;
        if (this.underConstruction) {
            return;
        }
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            clone = new ArrayList<ChangeListener>(this.listeners);
        }
        Iterator it = clone.iterator();
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener listener = (ChangeListener)it.next();
            listener.stateChanged(event);
        }
    }
}

