/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class InterruptibleInputStream
extends FilterInputStream {
    public InterruptibleInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        this.waitAvailable();
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.waitAvailable();
        return super.read(b, off, len);
    }

    private void waitAvailable() throws IOException {
        while (this.in.available() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }
}

