/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class Statistics {
    private static final Statistics NOP_INSTANCE = new NOP();
    private static final int REMOVED_BATCH_INTERVAL = 10000;
    private long requests = 0L;
    private long memoryHits = 0L;
    private long diskHits = 0L;
    private long threads = 0L;
    private long duplicates = 0L;
    private long maxQueueSize = 0L;
    private long maxMemoryEntries = 0L;
    private long gcCounter = 0L;
    private long newCounter = 0L;
    private int removedInvocaionCounter = 0;
    private long removedInvocationTime = System.currentTimeMillis() - 10000L;
    private Set recentKeys;
    private static volatile int idPool = 1;
    private final int id;
    private final Exception origin = new RuntimeException();
    private PrintWriter out;

    public static Statistics createInstance() {
        if ("none".equalsIgnoreCase(System.getProperty("netbeans.experimental.vcsTurboStatistics", "none"))) {
            return NOP_INSTANCE;
        }
        return new Statistics();
    }

    private Statistics() {
        this.id = idPool++;
    }

    private static boolean logPerformance() {
        return System.getProperty("netbeans.experimental.vcsTurboStatistics", "mini").equalsIgnoreCase("performance");
    }

    public void keyAdded(Object key) {
        if (key != null) {
            this.println("EK+ " + key);
        }
        ++this.newCounter;
        long allocated = this.newCounter - this.gcCounter;
        if (allocated > this.maxMemoryEntries) {
            this.maxMemoryEntries = allocated;
        }
        if (this.recentKeys != null) assert (this.recentKeys.add(key.toString())) : "Key added for the second time: " + key;
    }

    public void keyRemoved(Object key) {
        if (key != null) {
            this.println("EK- " + key);
        }
        ++this.gcCounter;
        if (this.recentKeys != null) {
            this.recentKeys.remove(key.toString());
        }
    }

    public void computeRemoved(Set keys) {
        if (!Statistics.logPerformance()) {
            return;
        }
        if (System.currentTimeMillis() - this.removedInvocationTime > 10000L) {
            return;
        }
        ++this.removedInvocaionCounter;
        Iterator it = keys.iterator();
        HashSet<String> currentKeys = new HashSet<String>(keys.size());
        while (it.hasNext()) {
            String stringKey = it.next().toString();
            currentKeys.add(stringKey);
        }
        if (this.recentKeys != null) {
            this.recentKeys.removeAll(currentKeys);
            int reclaimed = this.recentKeys.size();
            this.gcCounter += (long)reclaimed;
            if (reclaimed > 0) {
                this.println("MSG [" + new Date().toString() + "] reclaimed keys:");
                Iterator itr = this.recentKeys.iterator();
                while (itr.hasNext()) {
                    String next = itr.next().toString();
                    this.println("EK- " + next);
                }
                this.println("MSG EOL reclaimed keys");
            }
        }
        this.removedInvocationTime = System.currentTimeMillis();
        this.recentKeys = currentKeys;
    }

    public void attributeRequest() {
        ++this.requests;
        if (this.requests % 1000L == 0L) {
            this.printCacheStatistics();
        }
    }

    public void memoryHit() {
        ++this.memoryHits;
    }

    public void backgroundThread() {
        ++this.threads;
    }

    public void duplicate() {
        ++this.duplicates;
    }

    public void queueSize(int size) {
        if ((long)size > this.maxQueueSize) {
            this.maxQueueSize = size;
        }
    }

    public void providerHit() {
        ++this.diskHits;
    }

    public void shutdown() {
        this.printCacheStatistics();
        this.out.flush();
        this.out.close();
    }

    private String logPath() {
        return System.getProperty("java.io.tmpdir") + File.separator + "netbeans-versioning-turbo-" + this.id + ".log";
    }

    private void printCacheStatistics() {
        this.println("CS  turbo.requests=" + this.requests);
        this.println("CS  memory.hits=" + this.memoryHits + " " + (float)this.memoryHits / (float)this.requests * 100.0f + "%");
        this.println("CS  provider.hits=" + this.diskHits + " " + (float)this.diskHits / (float)this.requests * 100.0f + "%");
        if (this.removedInvocaionCounter >= 2) {
            this.println("CS  memory.max=" + this.maxMemoryEntries);
            this.println("CS  memory.entries=" + (this.newCounter - this.gcCounter));
            this.println("CS  memory.entiresReclaimingRatio=" + (float)this.gcCounter / (float)this.newCounter * 100.0f + "%");
        } else {
            this.println("MSG No memory utilization data known, use -J-Dnetbeans.experimental.vcsTurboStatistics=performance.");
        }
        this.println("CS  queue.threads=" + this.threads + " queue.duplicates=" + this.duplicates + " queue.maxSize=" + this.maxQueueSize);
        this.println("MSG --");
        this.println("MSG turbo.log.Statistics on " + new Date().toString());
    }

    private synchronized void println(String s) {
        if (this.out == null) {
            String filePath = this.logPath();
            try {
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(filePath), 512));
            }
            catch (IOException e) {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            }
            this.out.println("MSG EK followed by +/- denotes new memory cache entry/releasing it");
            this.out.println("MSG CS describes summary statistics of memory and disk caches");
            this.out.println("MSG the MSG prefix denotes free form messages");
            this.out.println("MSG turbo.Statistics instance serving:\n");
            StackTraceElement[] elements = this.origin.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                this.out.println("MSG " + element.toString());
            }
            this.out.println();
        }
        this.out.println(s);
    }

    private static final class NOP
    extends Statistics {
        private NOP() {
        }

        public void keyAdded(Object key) {
        }

        public void computeRemoved(Set keys) {
        }

        public void attributeRequest() {
        }

        public void memoryHit() {
        }

        public void backgroundThread() {
        }

        public void duplicate() {
        }

        public void queueSize(int size) {
        }

        public void providerHit() {
        }

        public void shutdown() {
        }
    }
}

