/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.CloneableOpenSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final RequestProcessor vcsRequestProcessor = new RequestProcessor("Versioning", 1);
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1);

    private Utils() {
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static void post(Runnable runnable) {
        vcsRequestProcessor.post(runnable);
    }

    public static boolean isAncestorOrEqual(File ancestor, File file) {
        if (VersioningSupport.isFlat((File)ancestor)) {
            return ancestor.equals(file) || ancestor.equals(file.getParentFile()) && !file.isDirectory();
        }
        while (file != null) {
            if (file.equals(ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static boolean shareCommonDataObject(File[] files) {
        if (files == null || files.length < 2) {
            return true;
        }
        DataObject common = Utils.findDataObject(files[0]);
        for (int i = 1; i < files.length; ++i) {
            DataObject dao = Utils.findDataObject(files[i]);
            if (dao == common || dao != null && dao.equals(common)) continue;
            return false;
        }
        return true;
    }

    public static Set<File> getAllDataObjectFiles(File file) {
        HashSet<File> filesToCheckout = new HashSet<File>(2);
        filesToCheckout.add(file);
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                Set fileObjects = dao.files();
                for (FileObject fileObject : fileObjects) {
                    filesToCheckout.add(FileUtil.toFile((FileObject)fileObject));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return filesToCheckout;
    }

    private static DataObject findDataObject(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                return DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static List<String> getStringList(Preferences prefs, String key) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key)) continue;
                int idx = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                retval.add(idx + "." + prefs.get(k, null));
            }
            ArrayList<String> rv = new ArrayList<String>(retval.size());
            rv.addAll(retval);
            for (String s : retval) {
                int pos = s.indexOf(46);
                int index = Integer.parseInt(s.substring(0, pos));
                rv.set(index, s.substring(pos + 1));
            }
            return rv;
        }
        catch (Exception ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
            return new ArrayList<String>(0);
        }
    }

    public static void put(Preferences prefs, String key, List<String> value) {
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key + ".")) continue;
                prefs.remove(k);
            }
            int idx = 0;
            for (String s : value) {
                prefs.put(key + "." + idx++, s);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
        }
    }

    public static void insert(Preferences prefs, String key, String value, int maxLength) {
        List<String> newValues = Utils.getStringList(prefs, key);
        if (newValues.contains(value)) {
            newValues.remove(value);
        }
        newValues.add(0, value);
        if (maxLength > -1 && newValues.size() > maxLength) {
            newValues.subList(maxLength, newValues.size()).clear();
        }
        Utils.put(prefs, key, newValues);
    }

    public static void removeFromArray(Preferences prefs, String key, List<String> values) {
        List<String> newValues = Utils.getStringList(prefs, key);
        newValues.removeAll(values);
        Utils.put(prefs, key, newValues);
    }

    public static void removeFromArray(Preferences prefs, String key, String value) {
        List<String> newValues = Utils.getStringList(prefs, key);
        newValues.remove(value);
        Utils.put(prefs, key, newValues);
    }

    public static File[][] splitFlatOthers(File[] files) {
        HashSet<File> flat = new HashSet<File>(1);
        for (int i = 0; i < files.length; ++i) {
            if (!VersioningSupport.isFlat((File)files[i])) continue;
            flat.add(files[i]);
        }
        if (flat.size() == 0) {
            return new File[][]{new File[0], files};
        }
        HashSet<File> allFiles = new HashSet<File>(Arrays.asList(files));
        allFiles.removeAll(flat);
        return new File[][]{flat.toArray(new File[flat.size()]), allFiles.toArray(new File[allFiles.size()])};
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static File getCommonParent(File a, File b) {
        do {
            if (!a.equals(b)) continue;
            return a;
        } while (!(a.getAbsolutePath().length() > b.getAbsolutePath().length() ? (a = a.getParentFile()) == null : (b = b.getParentFile()) == null));
        return null;
    }

    public static String getStackTrace() {
        Exception e = new Exception();
        e.fillInStackTrace();
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Reader getDocumentReader(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        };
        doc.render(run);
        return new StringReader(str[0]);
    }

    public static Point getPositionForPopup(JTable table) {
        int idx = table.getSelectedRow();
        if (idx == -1) {
            idx = 0;
        }
        Rectangle rect = table.getCellRect(idx, 1, true);
        return rect.getLocation();
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
        }
        return item;
    }

    public static File getTempFolder() {
        File dir;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        dir.deleteOnExit();
        return FileUtil.normalizeFile((File)dir);
    }

    public static String wordWrap(String s, int maxLineLength) {
        int n = s.length() - 1;
        if (maxLineLength < 1 || n < maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int currentWrap = 0;
        while (true) {
            int nextWrap;
            if ((nextWrap = currentWrap + maxLineLength - 1) >= n) break;
            int idx = s.lastIndexOf(32, nextWrap + 1);
            if (idx > currentWrap) {
                sb.append(s.substring(currentWrap, idx).trim());
                currentWrap = idx + 1;
            } else {
                sb.append(s.substring(currentWrap, nextWrap + 1));
                currentWrap = nextWrap + 1;
            }
            sb.append('\n');
        }
        sb.append(s.substring(currentWrap));
        return sb.toString();
    }

    public static String getActionName(Class clazz, String baseName, VCSContext ctx) {
        Set nodes = ctx.getRootFiles();
        int objectCount = nodes.size();
        Node[] activatedNodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return NbBundle.getBundle((Class)clazz).getString(baseName);
        }
        if (objectCount == 1) {
            String name;
            if (projectsOnly) {
                String dispName = ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage((Class)clazz, (String)(baseName + "_Context"), (Object)dispName);
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                name = fo.getNameExt();
            } else {
                DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
                if (dao instanceof DataShadow) {
                    dao = ((DataShadow)dao).getOriginal();
                }
                name = dao != null ? dao.getPrimaryFile().getNameExt() : activatedNodes[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(baseName + "_Context"), name);
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(baseName + "_Projects"), objectCount);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(baseName + "_Context_Multiple"), objectCount);
    }

    public static String getContextDisplayName(VCSContext ctx) {
        Set nodes = ctx.getRootFiles();
        int objectCount = nodes.size();
        Node[] activatedNodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return null;
        }
        if (objectCount == 1) {
            if (projectsOnly) {
                return ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                return fo.getNameExt();
            }
            DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            if (dao instanceof DataShadow) {
                dao = ((DataShadow)dao).getOriginal();
            }
            if (dao != null) {
                return dao.getPrimaryFile().getNameExt();
            }
            return activatedNodes[0].getDisplayName();
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle(Utils.class).getString("MSG_ActionContext_MultipleProjects"), objectCount);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(Utils.class).getString("MSG_ActionContext_MultipleFiles"), objectCount);
    }

    public static void openFile(FileObject fo, String revision) {
        ViewEnv env = new ViewEnv(fo);
        ViewCES ces = new ViewCES(env, fo.getNameExt() + " @ " + revision);
        ces.view();
    }

    private static class ViewCES
    extends CloneableEditorSupport {
        private final String name;

        public ViewCES(CloneableEditorSupport.Env env, String name) {
            super(env);
            this.name = name;
        }

        protected String messageSave() {
            return this.name;
        }

        protected String messageName() {
            return this.name;
        }

        protected String messageToolTip() {
            return this.name;
        }

        protected String messageOpening() {
            return this.name;
        }

        protected String messageOpened() {
            return this.name;
        }
    }

    private static class ViewEnv
    implements CloneableEditorSupport.Env {
        private final FileObject file;

        public ViewEnv(FileObject file) {
            this.file = file;
        }

        public InputStream inputStream() throws IOException {
            return this.file.getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            throw new IOException();
        }

        public Date getTime() {
            return this.file.lastModified();
        }

        public String getMimeType() {
            return this.file.getMIMEType();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
        }

        public boolean isValid() {
            return this.file.isValid();
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
            throw new IOException();
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return null;
        }
    }
}

