/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.properties.FindPanel;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.TableViewSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class FindPerformer
extends AbstractAction
implements PropertyChangeListener {
    private JTable table;
    private String findString;
    private int[] searchValues;
    private boolean highlightSearch = true;
    private boolean matchCaseSearch = false;
    private boolean backwardSearch = false;
    private boolean wrapSearch = true;
    private boolean rowSearch = true;
    private final ActionListener findNextActionListener;
    private final ActionListener findPreviousActionListener;
    private final ActionListener toggleHighlightListener;
    private Set<String> history = new HashSet<String>();
    private TableViewSettings settings;
    private static SoftReference<FindPerformer> softRef;
    private static JDialog findDialog;
    public static final String TABLE_SEARCH_RESULT = "table.search.result";

    private FindPerformer(JTable table) {
        this.findNextActionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                if (FindPerformer.this.searchValues != null) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        FindPerformer.this.backwardSearch = false;
                        FindPerformer.this.performSearch();
                    }
                }
            }
        };
        this.findPreviousActionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                if (FindPerformer.this.searchValues != null) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        FindPerformer.this.backwardSearch = true;
                        FindPerformer.this.performSearch();
                    }
                }
            }
        };
        this.toggleHighlightListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindPerformer.this.highlightSearch = !FindPerformer.this.highlightSearch;
                FindPerformer.this.table.repaint();
            }
        };
        this.table = table;
        this.settings = TableViewSettings.getDefault();
        this.settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.settings));
        this.registerKeyStrokes();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.registerKeyStrokes();
    }

    public static FindPerformer getFindPerformer(JTable table) {
        FindPerformer fp;
        if (softRef != null && (fp = softRef.get()) != null) {
            if (!fp.validateTable(table)) {
                fp.resetTable(table);
                fp.registerKeyStrokes();
            }
            return fp;
        }
        fp = new FindPerformer(table);
        softRef = new SoftReference<FindPerformer>(fp);
        return fp;
    }

    private void resetTable(JTable table) {
        this.table = table;
    }

    private boolean validateTable(JTable table) {
        return this.table != null && this.table.equals(table);
    }

    private synchronized void registerKeyStrokes() {
        int i;
        KeyStroke[] keyStrokes = this.settings.getKeyStrokesFindNext();
        for (i = 0; i < keyStrokes.length; ++i) {
            this.table.registerKeyboardAction(this.findNextActionListener, keyStrokes[i], 2);
        }
        keyStrokes = this.settings.getKeyStrokesFindPrevious();
        for (i = 0; i < keyStrokes.length; ++i) {
            this.table.registerKeyboardAction(this.findPreviousActionListener, keyStrokes[i], 2);
        }
        keyStrokes = this.settings.getKeyStrokesToggleHighlight();
        for (i = 0; i < keyStrokes.length; ++i) {
            this.table.registerKeyboardAction(this.toggleHighlightListener, keyStrokes[i], 2);
        }
    }

    public String getFindString() {
        return this.findString;
    }

    public boolean isHighlightSearch() {
        return this.highlightSearch;
    }

    public void actionPerformed(ActionEvent e) {
        if (findDialog == null) {
            this.createFindDialog();
        } else {
            findDialog.setVisible(true);
            findDialog.requestFocusInWindow();
        }
    }

    private void createFindDialog() {
        JDialog dialog;
        final FindPanel panel = new FindPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getBundle(FindPerformer.class).getString("LBL_Title"), false, (Object[])new JButton[0], null, 0, null, null);
        findDialog = dialog = (JDialog)DialogDisplayer.getDefault().createDialog(dd);
        dialog.getRootPane().setDefaultButton(panel.getButtons()[0]);
        dialog.setFocusable(false);
        dialog.setDefaultCloseOperation(2);
        panel.getButtons()[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindPerformer.this.findString = ((JTextField)panel.getComboBox().getEditor().getEditorComponent()).getText();
                FindPerformer.this.highlightSearch = panel.getHighlightCheck().isSelected();
                FindPerformer.this.matchCaseSearch = panel.getMatchCaseCheck().isSelected();
                FindPerformer.this.backwardSearch = panel.getBackwardCheck().isSelected();
                FindPerformer.this.wrapSearch = panel.getWrapCheck().isSelected();
                FindPerformer.this.rowSearch = panel.getRowCheck().isSelected();
                dialog.dispose();
                if (FindPerformer.this.findString != null && !FindPerformer.this.findString.trim().equals("")) {
                    FindPerformer.this.history.add(FindPerformer.this.findString.intern());
                    FindPerformer.this.performSearch();
                }
                FindPerformer.this.table.repaint();
            }
        });
        panel.getButtons()[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dialog.dispose();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                findDialog = null;
            }
        });
        panel.getHighlightCheck().setSelected(this.highlightSearch);
        panel.getMatchCaseCheck().setSelected(this.matchCaseSearch);
        panel.getBackwardCheck().setSelected(this.backwardSearch);
        panel.getWrapCheck().setSelected(this.wrapSearch);
        panel.getRowCheck().setSelected(this.rowSearch);
        panel.getComboBox().setModel(new DefaultComboBoxModel<Object>(this.history.toArray()));
        if (this.findString != null) {
            panel.getComboBox().setSelectedItem(this.findString);
        }
        dialog.setVisible(true);
        panel.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFindDialog() {
        if (findDialog != null) {
            JDialog jDialog = findDialog;
            synchronized (jDialog) {
                findDialog.setVisible(false);
                findDialog.dispose();
                findDialog = null;
            }
        }
    }

    private void prepareSearch() {
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        if (this.searchValues != null && row == this.searchValues[0] && column == this.searchValues[1]) {
            return;
        }
        if (row != -1 || column != -1) {
            int endOffset;
            int startOffset = endOffset = ((JTextField)((PropertiesTableCellEditor)this.table.getCellEditor(row, column)).getComponent()).getCaretPosition();
            this.searchValues = new int[]{row, column, startOffset, endOffset};
        } else if (this.backwardSearch) {
            int endOffset;
            int lastRow = this.table.getRowCount() - 1;
            int lastColumn = this.table.getColumnCount() - 1;
            int startOffset = endOffset = ((PropertiesTableModel.StringPair)this.table.getValueAt(lastRow, lastColumn)).getValue().length() - 1;
            this.searchValues = new int[]{lastRow, lastColumn, startOffset, endOffset};
        } else {
            this.searchValues = new int[]{0, 0, 0, 0};
        }
    }

    private synchronized void performSearch() {
        this.prepareSearch();
        PropertiesRequestProcessor.getInstance().post(new Runnable(){

            public void run() {
                boolean wrap = false;
                do {
                    final int[] result = FindPerformer.this.search(FindPerformer.this.searchValues[0], FindPerformer.this.searchValues[1], FindPerformer.this.backwardSearch ? FindPerformer.this.searchValues[2] - 1 : FindPerformer.this.searchValues[3]);
                    if (FindPerformer.this.wrapSearch && !wrap && result == null) {
                        if (FindPerformer.this.backwardSearch) {
                            int lastRow = FindPerformer.this.table.getRowCount() - 1;
                            int lastColumn = FindPerformer.this.table.getColumnCount() - 1;
                            FindPerformer.access$002(FindPerformer.this, new int[]{lastRow, lastColumn, ((PropertiesTableModel.StringPair)FindPerformer.this.table.getValueAt(lastRow, lastColumn)).getValue().length() - 1, 0});
                        } else {
                            FindPerformer.access$002(FindPerformer.this, new int[]{0, 0, 0, 0});
                        }
                        wrap = true;
                        continue;
                    }
                    if (result != null) {
                        FindPerformer.access$002(FindPerformer.this, result);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Rectangle cellRect;
                                if (FindPerformer.this.table.getAutoscrolls() && (cellRect = FindPerformer.this.table.getCellRect(result[0], result[1], false)) != null) {
                                    FindPerformer.this.table.scrollRectToVisible(cellRect);
                                }
                                if (FindPerformer.this.table.isEditing()) {
                                    FindPerformer.this.table.getCellEditor().stopCellEditing();
                                }
                                FindPerformer.this.table.getColumnModel().getSelectionModel().setSelectionInterval(result[1], result[1]);
                                FindPerformer.this.table.getSelectionModel().setSelectionInterval(result[0], result[0]);
                                FindPerformer.this.table.editCellAt(result[0], result[1]);
                            }
                        });
                    }
                    FindPerformer.access$002(FindPerformer.this, result);
                    wrap = false;
                } while (wrap);
            }
        });
    }

    private int[] search(int startRow, int startColumn, int startOffset) {
        int i;
        boolean firstIteration = true;
        int n = i = this.rowSearch ? startRow : startColumn;
        while (this.backwardSearch ? i >= 0 : i < (this.rowSearch ? this.table.getRowCount() : this.table.getColumnCount())) {
            int j;
            int n2 = j = this.rowSearch ? startColumn : startRow;
            while (this.backwardSearch ? j >= 0 : j < (this.rowSearch ? this.table.getColumnCount() : this.table.getRowCount())) {
                int column;
                int row = this.rowSearch ? i : j;
                String str = ((PropertiesTableModel.StringPair)this.table.getValueAt(row, column = this.rowSearch ? j : i)).toString();
                if (str != null && str.length() >= this.findString.length()) {
                    int offset;
                    if (!firstIteration) {
                        int n3 = startOffset = this.backwardSearch ? str.length() - this.findString.length() : 0;
                    }
                    if ((offset = this.containsFindString(str, startOffset)) >= 0) {
                        this.table.putClientProperty(TABLE_SEARCH_RESULT, new int[]{row, column, offset, offset + this.findString.length()});
                        return new int[]{row, column, offset, offset + this.findString.length()};
                    }
                    if (firstIteration) {
                        firstIteration = false;
                    }
                }
                j = this.backwardSearch ? j - 1 : j + 1;
            }
            if (this.rowSearch) {
                startColumn = this.backwardSearch ? this.table.getColumnCount() - 1 : 0;
            } else {
                startRow = this.backwardSearch ? this.table.getRowCount() - 1 : 0;
            }
            i = this.backwardSearch ? i - 1 : i + 1;
        }
        return null;
    }

    private int containsFindString(String str, int startOffset) {
        if (startOffset < 0 || startOffset >= str.length()) {
            return -1;
        }
        int i = startOffset;
        while (this.backwardSearch ? i >= 0 : i < str.length() - this.findString.length() + 1) {
            if (this.findString.regionMatches(!this.matchCaseSearch, 0, str, i, this.findString.length())) {
                return i;
            }
            i = this.backwardSearch ? i - 1 : i + 1;
        }
        return -1;
    }

    static /* synthetic */ int[] access$002(FindPerformer x0, int[] x1) {
        x0.searchValues = x1;
        return x1;
    }
}

