/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ToolsAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyNode
extends AbstractNode
implements PropertyChangeListener {
    private PropertiesStructure propStructure;
    private String itemKey;
    static final long serialVersionUID = -7882925922830244768L;

    public KeyNode(PropertiesStructure propStructure, String itemKey) {
        super(Children.LEAF);
        this.propStructure = propStructure;
        this.itemKey = itemKey;
        super.setName(itemKey);
        this.setActions(new SystemAction[]{SystemAction.get(EditAction.class), SystemAction.get(OpenAction.class), SystemAction.get(FileSystemAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)});
        this.setIconBaseWithExtension("org/netbeans/modules/properties/propertiesKey.gif");
        this.updateShortDescription();
        PropertiesDataObject pdo = (PropertiesDataObject)propStructure.getParent().getEntry().getDataObject();
        CookieSet cookieSet = this.getCookieSet();
        PropertiesOpen propertiesOpen = pdo.getOpenSupport();
        ((Object)((Object)propertiesOpen)).getClass();
        cookieSet.add((Node.Cookie)new PropertiesOpen.PropertiesOpenAt(propertiesOpen, propStructure.getParent().getEntry(), itemKey));
        CookieSet cookieSet2 = this.getCookieSet();
        PropertiesEditorSupport propertiesEditorSupport = propStructure.getParent().getEntry().getPropertiesEditor();
        propertiesEditorSupport.getClass();
        cookieSet2.add((Node.Cookie)new PropertiesEditorSupport.PropertiesEditAt(propertiesEditorSupport, itemKey));
        Element.ItemElem item = this.getItem();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)item);
        item.addPropertyChangeListener(pcl);
    }

    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    public Element.ItemElem getItem() {
        return this.propStructure.getItem(this.itemKey);
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.propStructure.deleteItem(this.itemKey);
        super.destroy();
    }

    public final boolean canCopy() {
        return true;
    }

    public final boolean canCut() {
        return true;
    }

    public final boolean canRename() {
        return true;
    }

    public void setName(String name) {
        if (name.equals(this.itemKey)) {
            return;
        }
        String oldKey = this.itemKey;
        this.itemKey = name;
        if (!this.propStructure.renameItem(oldKey, name)) {
            this.itemKey = oldKey;
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getBundle(KeyNode.class).getString("MSG_CannotRenameKey"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        this.updateCookieNames();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set sheetSet = sheet.get("properties");
        PropertySupport.ReadWrite property = new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getBundle(KeyNode.class).getString("PROP_item_key"), NbBundle.getBundle(KeyNode.class).getString("HINT_item_key")){

            public String getValue() {
                return KeyNode.this.itemKey;
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                KeyNode.this.setName(val);
            }
        };
        property.setName("key");
        sheetSet.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<String>("value", String.class, NbBundle.getBundle(KeyNode.class).getString("PROP_item_value"), NbBundle.getBundle(KeyNode.class).getString("HINT_item_value")){

            public String getValue() {
                return KeyNode.this.getItem().getValue();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                KeyNode.this.getItem().setValue(val);
            }
        };
        property.setName("value");
        sheetSet.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<String>("comment", String.class, NbBundle.getBundle(KeyNode.class).getString("PROP_item_comment"), NbBundle.getBundle(KeyNode.class).getString("HINT_item_comment")){

            public String getValue() {
                return KeyNode.this.getItem().getComment();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                KeyNode.this.getItem().setComment(val);
            }
        };
        property.setName("comment");
        sheetSet.put((Node.Property)property);
        return sheet;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz.isInstance(this.getItem())) {
            return (T)this.getItem();
        }
        if (clazz.equals(SaveCookie.class)) {
            return this.propStructure.getParent().getEntry().getCookie(clazz);
        }
        return (T)super.getCookie(clazz);
    }

    private void updateShortDescription() {
        String description;
        Element.ItemElem item = this.getItem();
        if (item != null) {
            String comment = item.getComment();
            if (comment != null) {
                int displayLenght = Math.min(comment.length(), 72);
                description = comment.substring(0, displayLenght);
                if (displayLenght < comment.length()) {
                    description = description + "...";
                }
            } else {
                description = item.getKey() + "=" + item.getValue();
            }
        } else {
            description = this.itemKey;
        }
        this.setShortDescription(description);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new PropertyPanel(this.getItem());
    }

    private void updateCookieNames() {
        EditCookie editor;
        OpenCookie opener = this.getCookie(OpenCookie.class);
        if (opener instanceof PropertiesOpen.PropertiesOpenAt) {
            ((PropertiesOpen.PropertiesOpenAt)opener).setKey(this.itemKey);
        }
        if ((editor = this.getCookie(EditCookie.class)) instanceof PropertiesEditorSupport.PropertiesEditAt) {
            ((PropertiesEditorSupport.PropertiesEditAt)editor).setKey(this.itemKey);
        }
    }

    private void setActions(SystemAction[] actions) {
        this.systemActions = actions;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("comment".equals(evt.getPropertyName())) {
            this.updateShortDescription();
        } else if ("value".equals(evt.getPropertyName())) {
            this.updateShortDescription();
        }
    }
}

