/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.properties.BundleNodeCustomizer;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDataNode
extends DataNode {
    private final transient PropertyChangeListener dataObjectListener;

    public PropertiesDataNode(DataObject dataObject, Children children) {
        super(dataObject, children);
        this.setIconBaseWithExtension("org/netbeans/modules/properties/propertiesObject.png");
        this.dataObjectListener = new NameUpdater();
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dataObjectListener, (Object)dataObject));
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewLocaleType()};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new BundleNodeCustomizer((PropertiesDataObject)this.getDataObject());
    }

    public void createPasteTypes(Transferable transferable, List<PasteType> types) {
        PropertiesFileEntry entry;
        super.createPasteTypes(transferable, types);
        int mode = 1;
        Node node = NodeTransfer.node((Transferable)transferable, (int)mode);
        if (node == null || !(node instanceof PropertiesLocaleNode)) {
            mode = 6;
            node = NodeTransfer.node((Transferable)transferable, (int)mode);
            if (node == null || !(node instanceof PropertiesLocaleNode)) {
                return;
            }
            entry = (PropertiesFileEntry)((PropertiesLocaleNode)node).getFileEntry();
            if (((PropertiesDataObject)this.getDataObject()).files().contains(entry.getFile())) {
                return;
            }
        }
        entry = (PropertiesFileEntry)((PropertiesLocaleNode)node).getFileEntry();
        types.add(new EntryPasteType(entry, mode));
    }

    private class EntryPasteType
    extends PasteType {
        private PropertiesFileEntry entry;
        private int flag;

        public EntryPasteType(PropertiesFileEntry entry, int flag) {
            this.entry = entry;
            this.flag = flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transferable paste() throws IOException {
            DataFolder dataFolder = PropertiesDataNode.this.getDataObject().getFolder();
            if (dataFolder == null) {
                return null;
            }
            FileObject folder = dataFolder.getPrimaryFile();
            String newName = PropertiesDataNode.this.getDataObject().getPrimaryFile().getName() + Util.getLocaleSuffix((MultiDataObject.Entry)this.entry);
            int entryIndex = ((PropertiesDataObject)PropertiesDataNode.this.getDataObject()).getBundleStructure().getEntryIndexByFileName(newName);
            if (entryIndex != -1) {
                newName = FileUtil.findFreeFileName((FileObject)folder, (String)newName, (String)this.entry.getFile().getExt());
            }
            if (this.flag == 1) {
                FileObject fileObject = this.entry.getFile();
                fileObject.copy(folder, newName, fileObject.getExt());
            } else if (this.flag == 6) {
                FileObject fileObject = this.entry.getFile();
                FileLock lock = this.entry.takeLock();
                ((PropertiesDataObject)this.entry.getDataObject()).removeSecondaryEntry2((MultiDataObject.Entry)this.entry);
                try {
                    FileObject fo2 = fileObject.move(lock, folder, newName, fileObject.getExt());
                    try {
                        DataObject.find((FileObject)fo2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            return null;
        }
    }

    final class NameUpdater
    implements PropertyChangeListener {
        NameUpdater() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("files".equals(e.getPropertyName())) {
                ((PropertiesDataObject)PropertiesDataNode.this.getDataObject()).fireNameChange();
            }
        }
    }

    private class NewLocaleType
    extends NewType {
        private NewLocaleType() {
        }

        public String getName() {
            return NbBundle.getBundle(PropertiesDataNode.class).getString("LAB_NewLocaleAction");
        }

        public void create() throws IOException {
            final PropertiesDataObject propertiesDataObject = (PropertiesDataObject)PropertiesDataNode.this.getCookie(DataObject.class);
            final Dialog[] dialog = new Dialog[1];
            final LocalePanel panel = new LocalePanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getBundle(PropertiesDataNode.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                        Util.createLocaleFile(propertiesDataObject, panel.getLocale().toString(), true);
                    }
                    dialog[0].setVisible(false);
                    dialog[0].dispose();
                }
            });
            dialog[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog[0].setVisible(true);
        }
    }
}

