/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataLoader;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = 4795737295255253334L;
    private transient BundleStructure bundleStructure;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();
    private transient String pasteSuffix;
    private Lookup lookup;

    public PropertiesDataObject(FileObject primaryFile, PropertiesDataLoader loader) throws DataObjectExistsException {
        super(primaryFile, (MultiFileLoader)loader);
        this.initialize();
    }

    PropertiesEncoding getEncoding() {
        return ((PropertiesDataLoader)this.getLoader()).getEncoding();
    }

    private Lookup getSuperLookup() {
        return super.getLookup();
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)((Object)this.getEncoding())), Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

                public Lookup getLookup() {
                    return PropertiesDataObject.this.getSuperLookup();
                }
            })});
        }
        return this.lookup;
    }

    private void initialize() {
        this.bundleStructure = null;
        Class[] arr = new Class[]{PropertiesOpen.class, PropertiesEditorSupport.class};
        this.getCookieSet().add(arr, (CookieSet.Factory)this);
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return (T)((Object)this.getOpenSupport());
        }
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return (T)((PropertiesFileEntry)this.getPrimaryEntry()).getPropertiesEditor();
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataObject handleCopy(DataFolder df) throws IOException {
        try {
            this.pasteSuffix = this.createPasteSuffix(df);
            DataObject dataObject = super.handleCopy(df);
            return dataObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder df) throws IOException {
        try {
            this.pasteSuffix = this.createPasteSuffix(df);
            FileObject fileObject = super.handleMove(df);
            return fileObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    String getPasteSuffix() {
        return this.pasteSuffix;
    }

    void removeSecondaryEntry2(MultiDataObject.Entry fe) {
        this.removeSecondaryEntry(fe);
    }

    private String createPasteSuffix(DataFolder folder) {
        String basicName = this.getPrimaryFile().getName();
        DataObject[] children = folder.getChildren();
        int i = 0;
        while (true) {
            String newName = i == 0 ? basicName : basicName + i;
            boolean exist = false;
            for (int j = 0; j < children.length; ++j) {
                if (!(children[j] instanceof PropertiesDataObject) || !newName.equals(children[j].getName())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                if (i == 0) {
                    return "";
                }
                return "" + i;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesOpen getOpenSupport() {
        Object object = this.OPEN_SUPPORT_LOCK;
        synchronized (object) {
            if (this.openSupport == null) {
                this.openSupport = new PropertiesOpen(this);
            }
            return this.openSupport;
        }
    }

    void updateModificationStatus() {
        boolean modif = false;
        if (((PresentableFileEntry)this.getPrimaryEntry()).isModified()) {
            modif = true;
        } else {
            Iterator it = this.secondaryEntries().iterator();
            while (it.hasNext()) {
                if (!((PresentableFileEntry)((Object)it.next())).isModified()) continue;
                modif = true;
                break;
            }
        }
        super.setModified(modif);
    }

    protected Node createNodeDelegate() {
        PropertiesChildren pc = new PropertiesChildren();
        PropertiesDataNode dn = new PropertiesDataNode((DataObject)this, (Children)pc);
        return dn;
    }

    public BundleStructure getBundleStructure() {
        if (this.bundleStructure == null) {
            this.bundleStructure = new BundleStructure(this);
        }
        return this.bundleStructure;
    }

    public static Comparator<String> getSecondaryFilesComparator() {
        return new KeyComparator();
    }

    void fireNameChange() {
        this.firePropertyChange("name", null, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesChildren
    extends Children.Keys<String> {
        private PropertyChangeListener propertyListener = null;

        PropertiesChildren() {
        }

        protected void mySetKeys() {
            TreeSet<String> newKeys = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            newKeys.add(PropertiesDataObject.this.getPrimaryEntry().getFile().getName());
            for (MultiDataObject.Entry entry : PropertiesDataObject.this.secondaryEntries()) {
                newKeys.add(entry.getFile().getName());
            }
            this.setKeys(newKeys);
        }

        protected void addNotify() {
            this.mySetKeys();
            if (this.propertyListener == null) {
                this.propertyListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("files".equals(evt.getPropertyName())) {
                            PropertiesChildren.this.mySetKeys();
                        }
                    }
                };
                PropertiesDataObject.this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)((Object)PropertiesDataObject.this)));
            }
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(String entryName) {
            if (entryName == null) {
                return null;
            }
            PropertiesFileEntry entry2 = (PropertiesFileEntry)PropertiesDataObject.this.getPrimaryEntry();
            if (entryName.equals(entry2.getFile().getName())) {
                return new Node[]{entry2.getNodeDelegate()};
            }
            for (PropertiesFileEntry entry2 : PropertiesDataObject.this.secondaryEntries()) {
                if (!entryName.equals(entry2.getFile().getName())) continue;
                return new Node[]{entry2.getNodeDelegate()};
            }
            return null;
        }
    }
}

