/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.Util;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public class PropertiesEditorSupport
extends CloneableEditorSupport
implements EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie,
Serializable {
    private FileStatusListener fsStatusListener;
    private PropertiesEncoding.NewLineType newLineType = PropertiesEncoding.getDefaultNewLineType();
    transient PropertiesFileEntry myEntry;
    static final long serialVersionUID = 1787354011149868490L;

    public PropertiesEditorSupport(PropertiesFileEntry entry) {
        super((CloneableEditorSupport.Env)new Environment(entry), Lookups.singleton((Object)entry.getDataObject()));
        this.myEntry = entry;
    }

    protected boolean canClose() {
        if (this.hasOpenedTableComponent()) {
            return true;
        }
        MultiDataObject propDO = this.myEntry.getDataObject();
        if (propDO == null || !propDO.isModified()) {
            return true;
        }
        return super.canClose();
    }

    protected CloneableEditor createCloneableEditor() {
        return new PropertiesEditor(this);
    }

    private void attachStatusListener() {
        FileSystem fs;
        if (this.fsStatusListener != null) {
            return;
        }
        try {
            fs = this.myEntry.getFile().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return;
        }
        this.fsStatusListener = new FsStatusListener();
        fs.addFileStatusListener(FileUtil.weakFileStatusListener((FileStatusListener)this.fsStatusListener, (Object)fs));
    }

    private void updateEditorDisplayNames() {
        assert (EventQueue.isDispatchThread());
        String title = this.messageName();
        String htmlTitle = this.messageHtmlName();
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            TopComponent tc = (TopComponent)en.nextElement();
            tc.setDisplayName(title);
            tc.setHtmlDisplayName(htmlTitle);
        }
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        ((PropertiesEditor)editor).initialize(this.myEntry);
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument document = super.createStyledDocument(kit);
        document.putProperty("title", this.myEntry.getFile().toString());
        document.putProperty("stream", this.myEntry.getDataObject());
        document.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument document, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        PropertiesEncoding.PropCharsetDecoder decoder = new PropertiesEncoding.PropCharsetDecoder(new PropertiesEncoding.PropCharset());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, decoder));
        try {
            editorKit.read(reader, (Document)document, 0);
            this.newLineType = decoder.getNewLineType();
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument document, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        PropertiesEncoding.PropCharsetEncoder encoder = new PropertiesEncoding.PropCharsetEncoder(new PropertiesEncoding.PropCharset(), this.newLineType);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoder));
        try {
            editorKit.write(writer, (Document)document, 0, document.getLength());
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }

    protected boolean notifyModified() {
        this.myEntry.getHandler().autoParse();
        if (super.notifyModified()) {
            ((Environment)this.env).addSaveCookie();
            return true;
        }
        return false;
    }

    protected Task reloadDocument() {
        Task tsk = super.reloadDocument();
        tsk.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return tsk;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)this.env).removeSaveCookie();
    }

    public void open() {
        super.open();
        this.attachStatusListener();
    }

    protected void notifyClosed() {
        if (!this.hasOpenedTableComponent()) {
            boolean wasModified = this.isModified();
            super.notifyClosed();
            if (wasModified && this.myEntry.getFile().isValid() && !this.myEntry.getFile().isVirtual()) {
                this.myEntry.getHandler().reparseNowBlocking();
            }
        }
    }

    protected String messageOpening() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_ObjectOpen", (Object)name);
    }

    protected String messageOpened() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_ObjectOpened", (Object)name);
    }

    private String getRawMessageName() {
        return this.myEntry.getDataObject().getName() + '(' + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ')';
    }

    private String addModifiedInfo(String name) {
        int version = this.isModified() ? (this.myEntry.getFile().canWrite() ? 1 : 2) : (this.myEntry.getFile().canWrite() ? 3 : 0);
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_EditorName", (Object)new Integer(version), (Object)name);
    }

    protected String messageName() {
        if (!this.myEntry.getDataObject().isValid()) {
            return "";
        }
        return this.addModifiedInfo(this.getRawMessageName());
    }

    protected String messageHtmlName() {
        if (!this.myEntry.getDataObject().isValid()) {
            return null;
        }
        String rawName = this.getRawMessageName();
        String annotatedName = null;
        FileObject entry = this.myEntry.getFile();
        try {
            FileSystem.Status status = entry.getFileSystem().getStatus();
            if (status != null) {
                Set<FileObject> files = Collections.singleton(entry);
                if (status instanceof FileSystem.HtmlStatus) {
                    FileSystem.HtmlStatus hStatus = (FileSystem.HtmlStatus)status;
                    annotatedName = hStatus.annotateNameHtml(rawName, files);
                    if (rawName.equals(annotatedName)) {
                        annotatedName = null;
                    }
                    if (annotatedName != null && !annotatedName.startsWith("<html>")) {
                        annotatedName = "<html>" + annotatedName;
                    }
                }
                if (annotatedName == null) {
                    annotatedName = status.annotateName(rawName, files);
                }
            }
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
        String name = annotatedName != null ? annotatedName : rawName;
        return this.addModifiedInfo(name);
    }

    protected String messageSave() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"MSG_SaveFile", (Object)name);
    }

    protected String messageToolTip() {
        FileObject fo = this.myEntry.getFile();
        return FileUtil.getFileDisplayName((FileObject)fo);
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoStampFlagManager();
    }

    UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    void forceNotifyClosed() {
        super.notifyClosed();
    }

    private void saveThisEntry() throws IOException {
        super.saveDocument();
        if (!this.env.isModified()) {
            this.myEntry.setModified(false);
        }
    }

    public synchronized boolean hasOpenedTableComponent() {
        return ((PropertiesDataObject)this.myEntry.getDataObject()).getOpenSupport().hasOpenedTableComponent();
    }

    public synchronized boolean hasOpenedEditorComponent() {
        Enumeration en = this.allEditors.getComponents();
        return en.hasMoreElements();
    }

    private static final class Env
    extends Environment {
        static final long serialVersionUID = -9218186467757330339L;
        private PropertiesFileEntry entry;

        public Env(PropertiesFileEntry entry) {
            super(entry);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.entry != null) {
                ((Environment)this).entry = this.entry;
            }
        }
    }

    private static class Environment
    implements CloneableEditorSupport.Env,
    PropertyChangeListener,
    SaveCookie {
        static final long serialVersionUID = 354528097109874355L;
        protected PropertiesFileEntry entry;
        private transient FileLock fileLock;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;

        public Environment(PropertiesFileEntry entry) {
            this.entry = entry;
            entry.getFile().addFileChangeListener((FileChangeListener)new EnvironmentListener(this));
            entry.addPropertyChangeListener(this);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop().addPropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("valid".equals(evt.getPropertyName())) {
                if (Boolean.FALSE.equals(evt.getOldValue())) {
                    return;
                }
                PropertiesEditorSupport support = (PropertiesEditorSupport)this.findCloneableOpenSupport();
                if (support != null) {
                    this.unmarkModified();
                    support.close(false);
                }
            } else {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop().removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
            this.veto().addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            this.veto().removeVetoableChangeListener(l);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (PropertiesEditorSupport)this.entry.getCookieSet().getCookie(EditCookie.class);
        }

        public boolean isValid() {
            return this.entry.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.entry.isModified();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            this.entry.setModified(true);
        }

        public void unmarkModified() {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.entry.setModified(false);
        }

        public String getMimeType() {
            return this.entry.getFile().getMIMEType();
        }

        public Date getTime() {
            this.entry.getFile().refresh(false);
            return this.entry.getFile().lastModified();
        }

        public InputStream inputStream() throws IOException {
            return this.entry.getFile().getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            return this.entry.getFile().getOutputStream(this.fileLock);
        }

        public void save() throws IOException {
            ((PropertiesEditorSupport)this.findCloneableOpenSupport()).saveThisEntry();
        }

        private void firePropertyChange(String name, Object oldValue, Object newValue) {
            this.prop().firePropertyChange(name, oldValue, newValue);
        }

        private void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
            this.veto().fireVetoableChange(name, oldValue, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            if (this.propSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.propSupp == null) {
                        this.propSupp = new PropertyChangeSupport(this);
                    }
                }
            }
            return this.propSupp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            if (this.vetoSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.vetoSupp == null) {
                        this.vetoSupp = new VetoableChangeSupport(this);
                    }
                }
            }
            return this.vetoSupp;
        }

        private void addSaveCookie() {
            if (this.entry.getCookie(SaveCookie.class) == null) {
                this.entry.getCookieSet().add((Node.Cookie)this);
            }
            ((PropertiesDataObject)this.entry.getDataObject()).updateModificationStatus();
        }

        private void removeSaveCookie() {
            SaveCookie sc = this.entry.getCookie(SaveCookie.class);
            if (sc != null && sc.equals(this)) {
                this.entry.getCookieSet().remove((Node.Cookie)this);
            }
            PropertiesRequestProcessor.getInstance().post(new Runnable(){

                public void run() {
                    ((PropertiesDataObject)Environment.this.entry.getDataObject()).updateModificationStatus();
                }
            });
        }

        private void fileChanged(boolean expected, long time) {
            if (expected) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(time));
            }
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }

    private static final class EnvironmentListener
    extends FileChangeAdapter {
        private Reference<Environment> reference;

        public EnvironmentListener(Environment environment) {
            this.reference = new WeakReference<Environment>(environment);
        }

        public void fileChanged(FileEvent evt) {
            Environment environment = this.reference.get();
            if (environment != null) {
                if (!environment.entry.getFile().equals(evt.getFile())) {
                    evt.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)new EnvironmentListener(environment));
                    return;
                }
                if (evt.getFile().isVirtual()) {
                    environment.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.fileRemoved();
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)this);
                } else {
                    environment.fileChanged(evt.isExpected(), evt.getTime());
                }
            }
        }
    }

    final class FsStatusListener
    implements FileStatusListener,
    Runnable {
        FsStatusListener() {
        }

        public void annotationChanged(FileStatusEvent ev) {
            if (ev.isNameChange() && ev.hasChanged(PropertiesEditorSupport.this.myEntry.getFile())) {
                Mutex.EVENT.writeAccess((Runnable)this);
            }
        }

        public void run() {
            PropertiesEditorSupport.this.updateEditorDisplayNames();
        }
    }

    public class PropertiesEditAt
    implements EditCookie {
        private String key;

        PropertiesEditAt(String key) {
            this.key = key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void edit() {
            PropertiesEditor editor = (PropertiesEditor)PropertiesEditorSupport.super.openCloneableTopComponent();
            editor.requestActive();
            Element.ItemElem item = PropertiesEditorSupport.this.myEntry.getHandler().getStructure().getItem(this.key);
            if (item != null) {
                int offset = item.getKeyElem().getBounds().getBegin().getOffset();
                if (editor.getPane() != null && editor.getPane().getCaret() != null) {
                    editor.getPane().getCaret().setDot(offset);
                }
            }
        }
    }

    public static class PropertiesEditor
    extends CloneableEditor {
        protected transient PropertiesFileEntry entry;
        private transient PropertyChangeListener saveCookieLNode;
        static final long serialVersionUID = -2702087884943509637L;

        public PropertiesEditor() {
        }

        public PropertiesEditor(PropertiesEditorSupport support) {
            super((CloneableEditorSupport)support);
        }

        private void initialize(PropertiesFileEntry entry) {
            this.entry = entry;
            Node n = entry.getNodeDelegate();
            this.setActivatedNodes(new Node[]{n});
            this.updateName();
            this.saveCookieLNode = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName())) {
                        PropertiesEditor.super.updateName();
                    }
                }
            };
            this.entry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.saveCookieLNode, (Object)((Object)this.entry)));
        }

        protected boolean closeLast() {
            return super.closeLast();
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/properties/propertiesLocale.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.editlocale");
        }

        private JEditorPane getPane() {
            return this.pane;
        }
    }

    static class StampFlag {
        private long timeStamp;
        private Object atomicFlag;

        public StampFlag(long timeStamp, Object atomicFlag) {
            this.timeStamp = timeStamp;
            this.atomicFlag = atomicFlag;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public Object getAtomicFlag() {
            return this.atomicFlag;
        }
    }

    class UndoRedoStampFlagManager
    extends UndoRedo.Manager {
        WeakHashMap<UndoableEdit, StampFlag> stampFlags = new WeakHashMap(5);

        UndoRedoStampFlagManager() {
        }

        public synchronized boolean addEdit(UndoableEdit anEdit) {
            this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), ((PropertiesDataObject)PropertiesEditorSupport.this.myEntry.getDataObject()).getOpenSupport().atomicUndoRedoFlag));
            return super.addEdit(anEdit);
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), ((PropertiesDataObject)PropertiesEditorSupport.this.myEntry.getDataObject()).getOpenSupport().atomicUndoRedoFlag));
            return super.replaceEdit(anEdit);
        }

        public synchronized void undo() throws CannotUndoException {
            UndoableEdit anEdit = this.editToBeUndone();
            if (anEdit != null) {
                Object atomicFlag = this.stampFlags.get(anEdit).getAtomicFlag();
                super.undo();
                this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), atomicFlag));
            }
        }

        public synchronized void redo() throws CannotRedoException {
            UndoableEdit anEdit = this.editToBeRedone();
            if (anEdit != null) {
                Object atomicFlag = this.stampFlags.get(anEdit).getAtomicFlag();
                super.redo();
                this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), atomicFlag));
            }
        }

        public long getTimeStampOfEditToBeUndone() {
            UndoableEdit nextUndo = this.editToBeUndone();
            if (nextUndo == null) {
                return 0L;
            }
            return this.stampFlags.get(nextUndo).getTimeStamp();
        }

        public long getTimeStampOfEditToBeRedone() {
            UndoableEdit nextRedo = this.editToBeRedone();
            if (nextRedo == null) {
                return 0L;
            }
            return this.stampFlags.get(nextRedo).getTimeStamp();
        }

        public Object getAtomicFlagOfEditToBeUndone() {
            UndoableEdit nextUndo = this.editToBeUndone();
            if (nextUndo == null) {
                return null;
            }
            return this.stampFlags.get(nextUndo).getAtomicFlag();
        }

        public Object getAtomicFlagOfEditToBeRedone() {
            UndoableEdit nextRedo = this.editToBeRedone();
            if (nextRedo == null) {
                return null;
            }
            return this.stampFlags.get(nextRedo).getAtomicFlag();
        }
    }
}

