/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

final class PropertiesEncoding
extends FileEncodingQueryImplementation {
    private final Charset encoding = new PropCharset();

    public Charset getEncoding(FileObject file) {
        return this.encoding;
    }

    Charset getEncoding() {
        return this.encoding;
    }

    static NewLineType getDefaultNewLineType() {
        return Utilities.isWindows() ? NewLineType.CR_LF : NewLineType.LF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NewLineType {
        CR_LF,
        LF,
        CR;

    }

    static final class PropCharset
    extends Charset {
        PropCharset() {
            super("resource_bundle_charset", null);
        }

        public boolean contains(Charset charset) {
            return true;
        }

        public PropCharsetEncoder newEncoder() {
            return new PropCharsetEncoder(this);
        }

        public PropCharsetDecoder newDecoder() {
            return new PropCharsetDecoder(this);
        }
    }

    static final class PropCharsetDecoder
    extends CharsetDecoder {
        private static final float avgCharsPerByte = 1.0f;
        private static final float maxCharsPerByte = 5.0f;
        private static final int maxCharsPerByteInt = 5;
        private static final int inBufSize = 8192;
        private static final int outBufSize = 8192;
        private final byte[] inBuf = new byte[8192];
        private final char[] outBuf = new char[8192];
        private int[] nlTypesUsage = new int[NewLineType.values().length];
        private int inBufPos;
        private int outBufPos;
        private boolean emptyIn;
        private boolean fullOut;
        private boolean emptyInBuf;
        private State state;
        private int unicodeBytesRead;
        private int unicodeValue;
        private char[] unicodeValueChars = new char[3];
        private static final String hexadecimalChars = "0123456789abcdefABCDEF";

        PropCharsetDecoder(Charset charset) {
            super(charset, 1.0f, 5.0f);
            this.implReset();
        }

        protected void implReset() {
            this.inBufPos = 0;
            this.outBufPos = 0;
            this.emptyIn = false;
            this.fullOut = false;
            this.emptyInBuf = true;
            this.state = State.INITIAL;
            this.unicodeBytesRead = 0;
            for (NewLineType nlType : NewLineType.values()) {
                this.nlTypesUsage[nlType.ordinal()] = 0;
            }
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            this.emptyIn = false;
            this.fullOut = false;
            try {
                block3: while (true) {
                    this.readIn(in);
                    do {
                        CoderResult coderResult;
                        if ((coderResult = this.decodeBuf()) != null) {
                            return coderResult;
                        }
                        if (this.emptyInBuf && !this.emptyIn) continue block3;
                        if (this.emptyIn && this.hasPendingCharacters()) {
                            this.handlePendingCharacters();
                        }
                        this.flushOutBuf(out);
                        if (!this.fullOut) continue;
                        return CoderResult.OVERFLOW;
                    } while (!this.emptyInBuf || !this.emptyIn || this.hasPendingCharacters());
                    break;
                }
                return CoderResult.UNDERFLOW;
            }
            catch (BufferUnderflowException ex) {
                assert (false);
                return CoderResult.UNDERFLOW;
            }
            catch (BufferOverflowException ex) {
                assert (false);
                return CoderResult.OVERFLOW;
            }
        }

        private boolean hasPendingCharacters() {
            return this.state != State.INITIAL;
        }

        private void handlePendingCharacters() {
            if (!this.hasPendingCharacters()) {
                return;
            }
            switch (this.state) {
                case INITIAL: {
                    assert (false);
                    break;
                }
                case CR: {
                    this.outBuf[this.outBufPos++] = 10;
                    int n = NewLineType.CR.ordinal();
                    this.nlTypesUsage[n] = this.nlTypesUsage[n] + 1;
                    break;
                }
                case BACKSLASH: {
                    this.outBuf[this.outBufPos++] = 92;
                    break;
                }
                case UNICODE: {
                    this.outBuf[this.outBufPos++] = 92;
                    this.outBuf[this.outBufPos++] = 117;
                    assert (this.unicodeBytesRead >= 0 && this.unicodeBytesRead < 4);
                    for (int i = 0; i < this.unicodeBytesRead; ++i) {
                        this.outBuf[this.outBufPos++] = this.unicodeValueChars[i];
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void readIn(ByteBuffer in) {
            if (this.emptyIn) {
                return;
            }
            int inRemaining = in.remaining();
            if (inRemaining == 0) {
                this.emptyIn = true;
                return;
            }
            int bufRemaining = this.inBuf.length - this.inBufPos;
            if (bufRemaining == 0) {
                return;
            }
            int length = Math.min(inRemaining, bufRemaining);
            in.get(this.inBuf, this.inBufPos, length);
            this.inBufPos += length;
            this.emptyInBuf = false;
            if (length == inRemaining) {
                assert (in.remaining() == 0);
                this.emptyIn = true;
            }
        }

        private CoderResult decodeBuf() {
            if (this.emptyInBuf) {
                return null;
            }
            CoderResult result = null;
            int decodingInBufPos = 0;
            while (decodingInBufPos < this.inBufPos && this.outBufPos <= 8187) {
                int decodedChars;
                if ((decodedChars = this.decodeByte(this.inBuf[decodingInBufPos++])) >= 0) continue;
                --decodingInBufPos;
                this.unicodeBytesRead = 0;
                this.unicodeValue = 0;
                this.state = State.INITIAL;
            }
            int remainder = this.inBufPos - decodingInBufPos;
            if (remainder != 0) {
                System.arraycopy(this.inBuf, decodingInBufPos, this.inBuf, 0, remainder);
            }
            this.inBufPos = remainder;
            this.emptyInBuf = this.inBufPos == 0;
            return result;
        }

        private boolean flushOutBuf(CharBuffer out) {
            if (this.outBufPos == 0) {
                return false;
            }
            if (this.fullOut) {
                return true;
            }
            int outRemaining = out.remaining();
            if (outRemaining == 0) {
                this.fullOut = true;
                return true;
            }
            int length = Math.min(outRemaining, this.outBufPos);
            out.put(this.outBuf, 0, length);
            int remainder = this.outBufPos - length;
            if (remainder != 0) {
                System.arraycopy(this.outBuf, length, this.outBuf, 0, remainder);
            }
            this.outBufPos = remainder;
            if (length == outRemaining) {
                assert (out.remaining() == 0);
                this.fullOut = true;
            }
            return remainder != 0;
        }

        private int decodeByte(byte b) {
            int bInt;
            int oldPos = this.outBufPos;
            int n = bInt = b >= 0 ? b : b + 256;
            assert (bInt >= 0 && (bInt & 0xFF) == bInt);
            char bChar = (char)bInt;
            switch (this.state) {
                case INITIAL: {
                    if (bChar == '\r') {
                        this.state = State.CR;
                        break;
                    }
                    if (bChar == '\\') {
                        this.state = State.BACKSLASH;
                        break;
                    }
                    if (bChar == '\n') {
                        this.outBuf[this.outBufPos++] = bChar;
                        int n2 = NewLineType.LF.ordinal();
                        this.nlTypesUsage[n2] = this.nlTypesUsage[n2] + 1;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = bChar;
                    break;
                }
                case CR: {
                    if (bChar == '\r') {
                        this.outBuf[this.outBufPos++] = 10;
                        int n3 = NewLineType.CR.ordinal();
                        this.nlTypesUsage[n3] = this.nlTypesUsage[n3] + 1;
                        break;
                    }
                    if (bChar == '\n') {
                        this.outBuf[this.outBufPos++] = 10;
                        int n4 = NewLineType.CR_LF.ordinal();
                        this.nlTypesUsage[n4] = this.nlTypesUsage[n4] + 1;
                        this.state = State.INITIAL;
                        break;
                    }
                    if (bChar == '\\') {
                        this.outBuf[this.outBufPos++] = 10;
                        int n5 = NewLineType.CR.ordinal();
                        this.nlTypesUsage[n5] = this.nlTypesUsage[n5] + 1;
                        this.state = State.BACKSLASH;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = 10;
                    this.outBuf[this.outBufPos++] = bChar;
                    int n6 = NewLineType.CR.ordinal();
                    this.nlTypesUsage[n6] = this.nlTypesUsage[n6] + 1;
                    this.state = State.INITIAL;
                    break;
                }
                case BACKSLASH: {
                    if (bChar == '\r') {
                        this.outBuf[this.outBufPos++] = 92;
                        this.state = State.CR;
                        break;
                    }
                    if (bChar == '\n') {
                        this.outBuf[this.outBufPos++] = 92;
                        this.outBuf[this.outBufPos++] = 10;
                        int n7 = NewLineType.LF.ordinal();
                        this.nlTypesUsage[n7] = this.nlTypesUsage[n7] + 1;
                        this.state = State.INITIAL;
                        break;
                    }
                    if (bChar == 'u') {
                        this.state = State.UNICODE;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = 92;
                    this.outBuf[this.outBufPos++] = bChar;
                    this.state = State.INITIAL;
                    break;
                }
                case UNICODE: {
                    boolean malformed = false;
                    int index = hexadecimalChars.indexOf(bChar);
                    if (index >= 0) {
                        if (index > 15) {
                            index -= 6;
                        }
                        assert (index <= 15);
                        this.unicodeValue = this.unicodeValue << 4 | index;
                        if (++this.unicodeBytesRead == 4) {
                            this.outBuf[this.outBufPos++] = (char)this.unicodeValue;
                            this.state = State.INITIAL;
                        } else {
                            this.unicodeValueChars[this.unicodeBytesRead - 1] = bChar;
                        }
                    } else {
                        malformed = true;
                        this.outBuf[this.outBufPos++] = 92;
                        this.outBuf[this.outBufPos++] = 117;
                        for (int i = 0; i < this.unicodeBytesRead; ++i) {
                            this.outBuf[this.outBufPos++] = this.unicodeValueChars[i];
                        }
                        this.state = State.INITIAL;
                    }
                    if (this.state == State.UNICODE) break;
                    this.unicodeBytesRead = 0;
                    this.unicodeValue = 0;
                    if (!malformed) break;
                    return -1;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this.outBufPos - oldPos;
        }

        char[] decodeBytesForTests(byte[] bytes) throws CharacterCodingException {
            CharBuffer resultBuf = this.decode(ByteBuffer.wrap(bytes));
            char[] resultBufArray = resultBuf.array();
            int resultBufPos = resultBuf.limit();
            if (resultBufPos == resultBufArray.length) {
                return resultBufArray;
            }
            char[] result = new char[resultBufPos];
            System.arraycopy(resultBufArray, 0, result, 0, resultBufPos);
            return result;
        }

        NewLineType getNewLineType() {
            NewLineType nlType = PropertiesEncoding.getDefaultNewLineType();
            int nlTypeUsage = this.nlTypesUsage[nlType.ordinal()];
            for (NewLineType testNlType : NewLineType.values()) {
                if (this.nlTypesUsage[testNlType.ordinal()] <= nlTypeUsage) continue;
                nlType = testNlType;
                nlTypeUsage = this.nlTypesUsage[nlType.ordinal()];
            }
            return nlType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            INITIAL,
            CR,
            BACKSLASH,
            UNICODE;

        }
    }

    static final class PropCharsetEncoder
    extends CharsetEncoder {
        private static final int avgEncodedTokenLen = 3;
        private static final int maxEncodedTokenLen = 6;
        private static final int inBufSize = 8192;
        private static final int outBufSize = 24576;
        private final char[] inBuf = new char[8192];
        private final byte[] outBuf = new byte[24576];
        private final NewLineType nlType;
        private int inBufPos;
        private int outBufPos;
        private boolean emptyIn;
        private boolean fullOut;
        private boolean emptyInBuf;
        private static final byte zeroByte = 48;
        private static final String backslashChars = "\t\f\r";
        private static final byte[] backslashCharsRepl = new byte[]{116, 102, 114};
        private static final byte[] hexadecimalChars = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

        PropCharsetEncoder(Charset charset) {
            this(charset, PropertiesEncoding.getDefaultNewLineType());
        }

        PropCharsetEncoder(Charset charset, NewLineType nlType) {
            super(charset, 3.0f, 6.0f);
            this.implReset();
            this.nlType = nlType;
        }

        protected void implReset() {
            this.inBufPos = 0;
            this.outBufPos = 0;
            this.emptyIn = false;
            this.fullOut = false;
            this.emptyInBuf = true;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            this.emptyIn = false;
            this.fullOut = false;
            try {
                block3: while (true) {
                    this.readIn(in);
                    do {
                        this.encodeBuf();
                        if (this.emptyInBuf && !this.emptyIn) continue block3;
                        this.flushOutBuf(out);
                        if (!this.fullOut) continue;
                        return CoderResult.OVERFLOW;
                    } while (!this.emptyInBuf || !this.emptyIn);
                    break;
                }
                return CoderResult.UNDERFLOW;
            }
            catch (BufferUnderflowException ex) {
                assert (false);
                return CoderResult.UNDERFLOW;
            }
            catch (BufferOverflowException ex) {
                assert (false);
                return CoderResult.OVERFLOW;
            }
        }

        protected CoderResult implFlush(ByteBuffer out) {
            return this.flushOutBuf(out) ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }

        private void readIn(CharBuffer in) {
            if (this.emptyIn) {
                return;
            }
            int inRemaining = in.remaining();
            if (inRemaining == 0) {
                this.emptyIn = true;
                return;
            }
            int bufRemaining = this.inBuf.length - this.inBufPos;
            if (bufRemaining == 0) {
                return;
            }
            int length = Math.min(inRemaining, bufRemaining);
            in.get(this.inBuf, this.inBufPos, length);
            this.inBufPos += length;
            this.emptyInBuf = false;
            if (length == inRemaining) {
                assert (in.remaining() == 0);
                this.emptyIn = true;
            }
        }

        private void encodeBuf() {
            if (this.emptyInBuf) {
                return;
            }
            int encodingInBufPos = 0;
            while (encodingInBufPos < this.inBufPos && this.outBufPos <= 24570) {
                this.encodeChar(this.inBuf[encodingInBufPos++]);
            }
            int remainder = this.inBufPos - encodingInBufPos;
            if (remainder != 0) {
                System.arraycopy(this.inBuf, encodingInBufPos, this.inBuf, 0, remainder);
            }
            this.inBufPos = remainder;
            this.emptyInBuf = this.inBufPos == 0;
        }

        private boolean flushOutBuf(ByteBuffer out) {
            if (this.fullOut) {
                return true;
            }
            int outRemaining = out.remaining();
            if (outRemaining == 0) {
                this.fullOut = true;
                return true;
            }
            if (this.outBufPos == 0) {
                return false;
            }
            int length = Math.min(outRemaining, this.outBufPos);
            out.put(this.outBuf, 0, length);
            int remainder = this.outBufPos - length;
            if (remainder != 0) {
                System.arraycopy(this.outBuf, length, this.outBuf, 0, remainder);
            }
            this.outBufPos = remainder;
            if (length == outRemaining) {
                assert (out.remaining() == 0);
                this.fullOut = true;
            }
            return remainder != 0;
        }

        private int encodeChar(char c) {
            int oldPos = this.outBufPos;
            char cInt = c;
            if (c == '\n') {
                if (this.nlType != NewLineType.LF) {
                    this.outBuf[this.outBufPos++] = 13;
                }
                if (this.nlType != NewLineType.CR) {
                    this.outBuf[this.outBufPos++] = 10;
                }
            } else {
                int index = backslashChars.indexOf(c);
                if (index >= 0) {
                    this.outBuf[this.outBufPos++] = 92;
                    this.outBuf[this.outBufPos++] = backslashCharsRepl[index];
                } else if (c < ' ' || c > '~') {
                    this.outBuf[this.outBufPos++] = 92;
                    this.outBuf[this.outBufPos++] = 117;
                    if (c >= '\u0100') {
                        this.outBuf[this.outBufPos++] = hexadecimalChars[cInt >> 12 & 0xF];
                        this.outBuf[this.outBufPos++] = hexadecimalChars[cInt >> 8 & 0xF];
                    } else {
                        this.outBuf[this.outBufPos++] = 48;
                        this.outBuf[this.outBufPos++] = 48;
                    }
                    this.outBuf[this.outBufPos++] = hexadecimalChars[cInt >> 4 & 0xF];
                    this.outBuf[this.outBufPos++] = hexadecimalChars[cInt & 0xF];
                } else {
                    this.outBuf[this.outBufPos++] = (byte)c;
                }
            }
            return this.outBufPos - oldPos;
        }

        byte[] encodeCharForTests(char c) {
            this.reset();
            int tokenLength = this.encodeChar(c);
            byte[] result = new byte[tokenLength];
            System.arraycopy(this.outBuf, 0, result, 0, tokenLength);
            return result;
        }

        byte[] encodeStringForTests(String s) throws CharacterCodingException {
            ByteBuffer resultBuf = this.encode(CharBuffer.wrap(s));
            byte[] resultBufArray = resultBuf.array();
            int resultBufPos = resultBuf.limit();
            if (resultBufPos == resultBufArray.length) {
                return resultBufArray;
            }
            byte[] result = new byte[resultBufPos];
            System.arraycopy(resultBufArray, 0, result, 0, resultBufPos);
            return result;
        }
    }
}

