/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class AutoupdateCheckScheduler {
    private static RequestProcessor.Task regularlyCheck = null;
    private static final RequestProcessor REGULARLY_CHECK_TIMER = new RequestProcessor("auto-checker-reqularly-timer", 1, true);
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.AutoupdateCheckScheduler");
    private static Runnable doCheck = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(doCheck);
            }
            AutoupdateCheckScheduler.scheduleRefreshProviders();
        }
    };

    private AutoupdateCheckScheduler() {
    }

    public static void signOn() {
        AutoupdateSettings.getIdeIdentity();
        if (AutoupdateCheckScheduler.timeToCheck()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RequestProcessor.getDefault().post(doCheck, 5000);
                }
            });
        }
    }

    private static void scheduleRefreshProviders() {
        try {
            assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run refreshProviders in EQ!";
            UpdateUnitProviderImpl.refreshProviders(null, true);
        }
        catch (IOException ioe) {
            err.log(Level.INFO, ioe.getMessage(), ioe);
        }
    }

    public static boolean timeToCheck() {
        if (AutoupdateCheckScheduler.getReqularlyTimerTask() != null && AutoupdateCheckScheduler.getReqularlyTimerTask().getDelay() <= 0 && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            AutoupdateCheckScheduler.getReqularlyTimerTask().schedule(AutoupdateCheckScheduler.getWaitPeriod());
            return true;
        }
        if (AutoupdateSettings.getLastCheck() == null) {
            return true;
        }
        switch (AutoupdateSettings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        Date lastCheck = AutoupdateSettings.getLastCheck();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(lastCheck);
        calendar.set(10, 0);
        calendar.set(9, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (AutoupdateSettings.getPeriod()) {
            case 1: {
                calendar.add(5, 1);
                break;
            }
            case 2: {
                calendar.add(3, 1);
                break;
            }
            case 3: {
                calendar.add(3, 2);
                break;
            }
            case 4: {
                calendar.add(2, 1);
            }
        }
        return calendar.getTime().before(new Date());
    }

    private static RequestProcessor.Task getReqularlyTimerTask() {
        if (regularlyCheck == null && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            int waitPeriod;
            int restTime = waitPeriod = AutoupdateCheckScheduler.getWaitPeriod();
            if (AutoupdateSettings.getLastCheck() != null) {
                restTime = waitPeriod - (int)(System.currentTimeMillis() - AutoupdateSettings.getLastCheck().getTime());
            }
            if (restTime <= 0) {
                restTime = waitPeriod;
            }
            regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, restTime, 1);
        }
        return regularlyCheck;
    }

    private static int getWaitPeriod() {
        switch (AutoupdateSettings.getPeriod()) {
            case 5: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 86400000;
            }
            case 2: {
                return 604800000;
            }
            case 3: {
                return 1209600000;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }
}

